/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.pagamentocredito;

import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.TipoCadastro;
import java.time.LocalDate;
import lombok.Generated;

public class PagamentoCreditoOrigemDTO {
    private Long entidadePagamento;
    private Long exercicioPagamento;
    private Long pagamento;
    private LocalDate dataPagamento;
    private Long idBoleto;
    private Long entidadeBoleto;
    private Long exercicioBoleto;
    private Long boleto;
    private Long idCadastro;
    private TipoCadastro tipoCadastro;
    private Long cadastroGeral;
    private String nomeContribuinte;

    public static PagamentoCreditoOrigemDTO from(Pagamento pagamento) {
        PagamentoCreditoOrigemDTO dto = new PagamentoCreditoOrigemDTO();
        dto.setEntidadePagamento(pagamento.getId().getEntidade());
        dto.setExercicioPagamento(pagamento.getId().getExercicioPagamento());
        dto.setPagamento(pagamento.getId().getPagamento());
        dto.setDataPagamento(pagamento.getDataPagamento());
        dto.setIdBoleto(pagamento.getPagamentoBoleto().getBoleto().getId());
        dto.setEntidadeBoleto(pagamento.getPagamentoBoleto().getBoleto().getEntidade());
        dto.setExercicioBoleto(pagamento.getPagamentoBoleto().getBoleto().getExercicioBloqueto());
        dto.setBoleto(pagamento.getPagamentoBoleto().getBoleto().getBloqueto());
        dto.setIdCadastro(pagamento.getPagamentoBoleto().getBoleto().getCadastroGeral().getId());
        dto.setTipoCadastro(pagamento.getPagamentoBoleto().getBoleto().getCadastroGeral().getTipoCadastro());
        dto.setCadastroGeral(pagamento.getPagamentoBoleto().getBoleto().getCadastroGeral().getCadastroGeral());
        dto.setNomeContribuinte(pagamento.getPagamentoBoleto().getBoleto().getPessoa().getNome());
        return dto;
    }

    @Generated
    public PagamentoCreditoOrigemDTO() {
    }

    @Generated
    public Long getEntidadePagamento() {
        return this.entidadePagamento;
    }

    @Generated
    public Long getExercicioPagamento() {
        return this.exercicioPagamento;
    }

    @Generated
    public Long getPagamento() {
        return this.pagamento;
    }

    @Generated
    public LocalDate getDataPagamento() {
        return this.dataPagamento;
    }

    @Generated
    public Long getIdBoleto() {
        return this.idBoleto;
    }

    @Generated
    public Long getEntidadeBoleto() {
        return this.entidadeBoleto;
    }

    @Generated
    public Long getExercicioBoleto() {
        return this.exercicioBoleto;
    }

    @Generated
    public Long getBoleto() {
        return this.boleto;
    }

    @Generated
    public Long getIdCadastro() {
        return this.idCadastro;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getNomeContribuinte() {
        return this.nomeContribuinte;
    }

    @Generated
    public void setEntidadePagamento(Long entidadePagamento) {
        this.entidadePagamento = entidadePagamento;
    }

    @Generated
    public void setExercicioPagamento(Long exercicioPagamento) {
        this.exercicioPagamento = exercicioPagamento;
    }

    @Generated
    public void setPagamento(Long pagamento) {
        this.pagamento = pagamento;
    }

    @Generated
    public void setDataPagamento(LocalDate dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Generated
    public void setIdBoleto(Long idBoleto) {
        this.idBoleto = idBoleto;
    }

    @Generated
    public void setEntidadeBoleto(Long entidadeBoleto) {
        this.entidadeBoleto = entidadeBoleto;
    }

    @Generated
    public void setExercicioBoleto(Long exercicioBoleto) {
        this.exercicioBoleto = exercicioBoleto;
    }

    @Generated
    public void setBoleto(Long boleto) {
        this.boleto = boleto;
    }

    @Generated
    public void setIdCadastro(Long idCadastro) {
        this.idCadastro = idCadastro;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setNomeContribuinte(String nomeContribuinte) {
        this.nomeContribuinte = nomeContribuinte;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoCreditoOrigemDTO)) {
            return false;
        }
        PagamentoCreditoOrigemDTO other = (PagamentoCreditoOrigemDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidadePagamento = this.getEntidadePagamento();
        Long other$entidadePagamento = other.getEntidadePagamento();
        if (this$entidadePagamento == null ? other$entidadePagamento != null : !((Object)this$entidadePagamento).equals(other$entidadePagamento)) {
            return false;
        }
        Long this$exercicioPagamento = this.getExercicioPagamento();
        Long other$exercicioPagamento = other.getExercicioPagamento();
        if (this$exercicioPagamento == null ? other$exercicioPagamento != null : !((Object)this$exercicioPagamento).equals(other$exercicioPagamento)) {
            return false;
        }
        Long this$pagamento = this.getPagamento();
        Long other$pagamento = other.getPagamento();
        if (this$pagamento == null ? other$pagamento != null : !((Object)this$pagamento).equals(other$pagamento)) {
            return false;
        }
        Long this$idBoleto = this.getIdBoleto();
        Long other$idBoleto = other.getIdBoleto();
        if (this$idBoleto == null ? other$idBoleto != null : !((Object)this$idBoleto).equals(other$idBoleto)) {
            return false;
        }
        Long this$entidadeBoleto = this.getEntidadeBoleto();
        Long other$entidadeBoleto = other.getEntidadeBoleto();
        if (this$entidadeBoleto == null ? other$entidadeBoleto != null : !((Object)this$entidadeBoleto).equals(other$entidadeBoleto)) {
            return false;
        }
        Long this$exercicioBoleto = this.getExercicioBoleto();
        Long other$exercicioBoleto = other.getExercicioBoleto();
        if (this$exercicioBoleto == null ? other$exercicioBoleto != null : !((Object)this$exercicioBoleto).equals(other$exercicioBoleto)) {
            return false;
        }
        Long this$boleto = this.getBoleto();
        Long other$boleto = other.getBoleto();
        if (this$boleto == null ? other$boleto != null : !((Object)this$boleto).equals(other$boleto)) {
            return false;
        }
        Long this$idCadastro = this.getIdCadastro();
        Long other$idCadastro = other.getIdCadastro();
        if (this$idCadastro == null ? other$idCadastro != null : !((Object)this$idCadastro).equals(other$idCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        LocalDate this$dataPagamento = this.getDataPagamento();
        LocalDate other$dataPagamento = other.getDataPagamento();
        if (this$dataPagamento == null ? other$dataPagamento != null : !((Object)this$dataPagamento).equals(other$dataPagamento)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$nomeContribuinte = this.getNomeContribuinte();
        String other$nomeContribuinte = other.getNomeContribuinte();
        return !(this$nomeContribuinte == null ? other$nomeContribuinte != null : !this$nomeContribuinte.equals(other$nomeContribuinte));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoCreditoOrigemDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidadePagamento = this.getEntidadePagamento();
        result = result * 59 + ($entidadePagamento == null ? 43 : ((Object)$entidadePagamento).hashCode());
        Long $exercicioPagamento = this.getExercicioPagamento();
        result = result * 59 + ($exercicioPagamento == null ? 43 : ((Object)$exercicioPagamento).hashCode());
        Long $pagamento = this.getPagamento();
        result = result * 59 + ($pagamento == null ? 43 : ((Object)$pagamento).hashCode());
        Long $idBoleto = this.getIdBoleto();
        result = result * 59 + ($idBoleto == null ? 43 : ((Object)$idBoleto).hashCode());
        Long $entidadeBoleto = this.getEntidadeBoleto();
        result = result * 59 + ($entidadeBoleto == null ? 43 : ((Object)$entidadeBoleto).hashCode());
        Long $exercicioBoleto = this.getExercicioBoleto();
        result = result * 59 + ($exercicioBoleto == null ? 43 : ((Object)$exercicioBoleto).hashCode());
        Long $boleto = this.getBoleto();
        result = result * 59 + ($boleto == null ? 43 : ((Object)$boleto).hashCode());
        Long $idCadastro = this.getIdCadastro();
        result = result * 59 + ($idCadastro == null ? 43 : ((Object)$idCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        LocalDate $dataPagamento = this.getDataPagamento();
        result = result * 59 + ($dataPagamento == null ? 43 : ((Object)$dataPagamento).hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $nomeContribuinte = this.getNomeContribuinte();
        result = result * 59 + ($nomeContribuinte == null ? 43 : $nomeContribuinte.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PagamentoCreditoOrigemDTO(entidadePagamento=" + this.getEntidadePagamento() + ", exercicioPagamento=" + this.getExercicioPagamento() + ", pagamento=" + this.getPagamento() + ", dataPagamento=" + this.getDataPagamento() + ", idBoleto=" + this.getIdBoleto() + ", entidadeBoleto=" + this.getEntidadeBoleto() + ", exercicioBoleto=" + this.getExercicioBoleto() + ", boleto=" + this.getBoleto() + ", idCadastro=" + this.getIdCadastro() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", nomeContribuinte=" + this.getNomeContribuinte() + ")";
    }
}

