/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.pagamento;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.dto.BoletoDTO;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class PagamentoLoteManualDTO {
    @NotNull(message="Campo Entidade \u00e9 obrigat\u00f3rio.")
    private @NotNull(message="Campo Entidade \u00e9 obrigat\u00f3rio.") Long entidade;
    @NotNull(message="Campo Exerc\u00edcio \u00e9 obrigat\u00f3rio.")
    private @NotNull(message="Campo Exerc\u00edcio \u00e9 obrigat\u00f3rio.") Long exercicio;
    @NotNull(message="Campo Data Lote \u00e9 obrigat\u00f3rio.")
    private @NotNull(message="Campo Data Lote \u00e9 obrigat\u00f3rio.") LocalDate dataLote;
    @NotNull(message="Campo Data Movimento \u00e9 obrigat\u00f3rio.")
    private @NotNull(message="Campo Data Movimento \u00e9 obrigat\u00f3rio.") LocalDate dataMovimento;
    @NotNull(message="Campo Data Cr\u00e9dito \u00e9 obrigat\u00f3rio.")
    private @NotNull(message="Campo Data Cr\u00e9dito \u00e9 obrigat\u00f3rio.") LocalDate dataCredito;
    @NotNull(message="Campo Conv\u00eanio \u00e9 obrigat\u00f3rio.")
    private @NotNull(message="Campo Conv\u00eanio \u00e9 obrigat\u00f3rio.") Long convenio;
    private String observacao;
    @NotNull(message="Campo obrigat\u00f3rio, necess\u00e1rio informar pelo menos um boleto.")
    @NotEmpty(message="Necess\u00e1rio informar pelo menos um boleto.")
    private @NotNull(message="Campo obrigat\u00f3rio, necess\u00e1rio informar pelo menos um boleto.") @NotEmpty(message="Necess\u00e1rio informar pelo menos um boleto.") List<BoletoDTO> boletos;

    public static PagamentoLoteManualDTO from(Bloqueto boleto, Long convenioId, LocalDate dataCredito, Long exercicio, LocalDate dataAtual) {
        PagamentoLoteManualDTO pagamentoLoteManualDTO = new PagamentoLoteManualDTO();
        pagamentoLoteManualDTO.setEntidade(boleto.getEntidade());
        pagamentoLoteManualDTO.setExercicio(exercicio);
        pagamentoLoteManualDTO.setDataLote(dataAtual);
        pagamentoLoteManualDTO.setDataMovimento(dataAtual);
        pagamentoLoteManualDTO.setConvenio(convenioId);
        pagamentoLoteManualDTO.setDataCredito(dataCredito);
        pagamentoLoteManualDTO.setBoletos(Collections.singletonList(BoletoDTO.from((Bloqueto)boleto)));
        return pagamentoLoteManualDTO;
    }

    @Generated
    public PagamentoLoteManualDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public LocalDate getDataLote() {
        return this.dataLote;
    }

    @Generated
    public LocalDate getDataMovimento() {
        return this.dataMovimento;
    }

    @Generated
    public LocalDate getDataCredito() {
        return this.dataCredito;
    }

    @Generated
    public Long getConvenio() {
        return this.convenio;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public List<BoletoDTO> getBoletos() {
        return this.boletos;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDataLote(LocalDate dataLote) {
        this.dataLote = dataLote;
    }

    @Generated
    public void setDataMovimento(LocalDate dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    @Generated
    public void setDataCredito(LocalDate dataCredito) {
        this.dataCredito = dataCredito;
    }

    @Generated
    public void setConvenio(Long convenio) {
        this.convenio = convenio;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setBoletos(List<BoletoDTO> boletos) {
        this.boletos = boletos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoLoteManualDTO)) {
            return false;
        }
        PagamentoLoteManualDTO other = (PagamentoLoteManualDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$convenio = this.getConvenio();
        Long other$convenio = other.getConvenio();
        if (this$convenio == null ? other$convenio != null : !((Object)this$convenio).equals(other$convenio)) {
            return false;
        }
        LocalDate this$dataLote = this.getDataLote();
        LocalDate other$dataLote = other.getDataLote();
        if (this$dataLote == null ? other$dataLote != null : !((Object)this$dataLote).equals(other$dataLote)) {
            return false;
        }
        LocalDate this$dataMovimento = this.getDataMovimento();
        LocalDate other$dataMovimento = other.getDataMovimento();
        if (this$dataMovimento == null ? other$dataMovimento != null : !((Object)this$dataMovimento).equals(other$dataMovimento)) {
            return false;
        }
        LocalDate this$dataCredito = this.getDataCredito();
        LocalDate other$dataCredito = other.getDataCredito();
        if (this$dataCredito == null ? other$dataCredito != null : !((Object)this$dataCredito).equals(other$dataCredito)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        List this$boletos = this.getBoletos();
        List other$boletos = other.getBoletos();
        return !(this$boletos == null ? other$boletos != null : !((Object)this$boletos).equals(other$boletos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoLoteManualDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $convenio = this.getConvenio();
        result = result * 59 + ($convenio == null ? 43 : ((Object)$convenio).hashCode());
        LocalDate $dataLote = this.getDataLote();
        result = result * 59 + ($dataLote == null ? 43 : ((Object)$dataLote).hashCode());
        LocalDate $dataMovimento = this.getDataMovimento();
        result = result * 59 + ($dataMovimento == null ? 43 : ((Object)$dataMovimento).hashCode());
        LocalDate $dataCredito = this.getDataCredito();
        result = result * 59 + ($dataCredito == null ? 43 : ((Object)$dataCredito).hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        List $boletos = this.getBoletos();
        result = result * 59 + ($boletos == null ? 43 : ((Object)$boletos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PagamentoLoteManualDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", dataLote=" + this.getDataLote() + ", dataMovimento=" + this.getDataMovimento() + ", dataCredito=" + this.getDataCredito() + ", convenio=" + this.getConvenio() + ", observacao=" + this.getObservacao() + ", boletos=" + this.getBoletos() + ")";
    }
}

