/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.mobile;

import br.com.elotech.gateway.dto.DebitoContratoParcelamentoDTO;
import br.com.elotech.tributos.dto.mobile.DebitoParcelaMobileDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class DebitoMobileDTO {
    private Integer exercicio;
    private Integer tipoCadastro;
    private Long cadastroGeral;
    private Long idDebito;
    private Long idParcelamento;
    private String descricaoVisualizacao;
    private BigDecimal valor = BigDecimal.ZERO;
    private List<DebitoContratoParcelamentoDTO> debitosContratoParcelamento;
    private List<DebitoParcelaMobileDTO> parcelas = new ArrayList();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        int idDebitoHashCode = 0;
        if (this.idDebito != null) {
            idDebitoHashCode = this.idDebito.hashCode();
        }
        result = 31 * result + idDebitoHashCode;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DebitoMobileDTO other = (DebitoMobileDTO)obj;
        return !(this.idDebito == null ? other.idDebito != null : !this.idDebito.equals(other.idDebito));
    }

    public void addAllParcelaMobileDTO(List<DebitoParcelaMobileDTO> novasParcelas) {
        novasParcelas.forEach(novaParcela -> {
            boolean parcelaJaExiste;
            boolean bl = parcelaJaExiste = this.parcelas.indexOf(novaParcela) >= 0;
            if (!parcelaJaExiste) {
                this.parcelas.add(novaParcela);
            }
        });
    }

    @Generated
    public DebitoMobileDTO() {
    }

    @Generated
    public Integer getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Integer getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public Long getIdParcelamento() {
        return this.idParcelamento;
    }

    @Generated
    public String getDescricaoVisualizacao() {
        return this.descricaoVisualizacao;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public List<DebitoContratoParcelamentoDTO> getDebitosContratoParcelamento() {
        return this.debitosContratoParcelamento;
    }

    @Generated
    public List<DebitoParcelaMobileDTO> getParcelas() {
        return this.parcelas;
    }

    @Generated
    public void setExercicio(Integer exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(Integer tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setIdParcelamento(Long idParcelamento) {
        this.idParcelamento = idParcelamento;
    }

    @Generated
    public void setDescricaoVisualizacao(String descricaoVisualizacao) {
        this.descricaoVisualizacao = descricaoVisualizacao;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setDebitosContratoParcelamento(List<DebitoContratoParcelamentoDTO> debitosContratoParcelamento) {
        this.debitosContratoParcelamento = debitosContratoParcelamento;
    }

    @Generated
    public void setParcelas(List<DebitoParcelaMobileDTO> parcelas) {
        this.parcelas = parcelas;
    }

    @Generated
    public String toString() {
        return "DebitoMobileDTO(exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", idDebito=" + this.getIdDebito() + ", idParcelamento=" + this.getIdParcelamento() + ", descricaoVisualizacao=" + this.getDescricaoVisualizacao() + ", valor=" + this.getValor() + ", debitosContratoParcelamento=" + this.getDebitosContratoParcelamento() + ", parcelas=" + this.getParcelas() + ")";
    }
}

