/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoelogeo;

import br.com.elotech.tributos.domain.ModeloCampo;
import br.com.elotech.tributos.domain.ModeloResposta;
import br.com.elotech.tributos.domain.camposdinamicos.Alternativa;
import br.com.elotech.tributos.domain.camposdinamicos.Campo;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.dto.camposdinamicos.RespostaElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.ModeloCampoElogeoDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;

public class ModeloRespostaElogeoDTO {
    @Schema(description="Campo obrigat\u00f3rio caso seja clientes On-Premise")
    private Long id;
    private Long codigo;
    private String descricao;
    private ModeloCampoElogeoDTO campo;

    public static ModeloRespostaElogeoDTO from(ModeloResposta entity) {
        ModeloRespostaElogeoDTO modeloRespostaElogeoDTO = new ModeloRespostaElogeoDTO();
        modeloRespostaElogeoDTO.setId(entity.getId());
        modeloRespostaElogeoDTO.setCodigo(entity.getModeloResposta());
        modeloRespostaElogeoDTO.setDescricao(entity.getDescricao());
        modeloRespostaElogeoDTO.setCampo(ModeloCampoElogeoDTO.from((ModeloCampo)entity.getModeloCampo()));
        return modeloRespostaElogeoDTO;
    }

    public static ModeloRespostaElogeoDTO from(Alternativa entity) {
        ModeloRespostaElogeoDTO modeloRespostaElogeoDTO = new ModeloRespostaElogeoDTO();
        modeloRespostaElogeoDTO.setId(entity.getId());
        modeloRespostaElogeoDTO.setCodigo(entity.getCodigo());
        modeloRespostaElogeoDTO.setDescricao(entity.getDescricao());
        modeloRespostaElogeoDTO.setCampo(ModeloCampoElogeoDTO.from((Campo)entity.getCampo()));
        return modeloRespostaElogeoDTO;
    }

    public static ModeloRespostaElogeoDTO from(Resposta resposta) {
        ModeloRespostaElogeoDTO modeloRespostaElogeoDTO = new ModeloRespostaElogeoDTO();
        Alternativa alternativa = resposta.getAlternativa();
        if (ObjectUtils.isNotEmpty((Object)alternativa)) {
            modeloRespostaElogeoDTO.setId(resposta.getId());
            modeloRespostaElogeoDTO.setCodigo(alternativa.getId());
            modeloRespostaElogeoDTO.setDescricao(alternativa.getDescricao());
        } else {
            modeloRespostaElogeoDTO.setId(resposta.getId());
            modeloRespostaElogeoDTO.setDescricao(resposta.getValor());
        }
        modeloRespostaElogeoDTO.setCampo(ModeloCampoElogeoDTO.from((Campo)resposta.getCampo()));
        return modeloRespostaElogeoDTO;
    }

    public static ModeloRespostaElogeoDTO from(RespostaElogeoDTO dto) {
        ModeloRespostaElogeoDTO modeloRespostaElogeoDTO = new ModeloRespostaElogeoDTO();
        modeloRespostaElogeoDTO.setId(dto.getResposta().getId());
        Alternativa alternativa = dto.getResposta().getAlternativa();
        if (ObjectUtils.isNotEmpty((Object)alternativa)) {
            modeloRespostaElogeoDTO.setCodigo(alternativa.getCodigo());
            modeloRespostaElogeoDTO.setDescricao(alternativa.getDescricao());
        }
        modeloRespostaElogeoDTO.setCampo(ModeloCampoElogeoDTO.from((Campo)dto.getResposta().getCampo()));
        return modeloRespostaElogeoDTO;
    }

    @Generated
    public ModeloRespostaElogeoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getCodigo() {
        return this.codigo;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public ModeloCampoElogeoDTO getCampo() {
        return this.campo;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setCampo(ModeloCampoElogeoDTO campo) {
        this.campo = campo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModeloRespostaElogeoDTO)) {
            return false;
        }
        ModeloRespostaElogeoDTO other = (ModeloRespostaElogeoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        ModeloCampoElogeoDTO this$campo = this.getCampo();
        ModeloCampoElogeoDTO other$campo = other.getCampo();
        return !(this$campo == null ? other$campo != null : !this$campo.equals(other$campo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModeloRespostaElogeoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        ModeloCampoElogeoDTO $campo = this.getCampo();
        result = result * 59 + ($campo == null ? 43 : $campo.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ModeloRespostaElogeoDTO(id=" + this.getId() + ", codigo=" + this.getCodigo() + ", descricao=" + this.getDescricao() + ", campo=" + this.getCampo() + ")";
    }
}

