/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoelogeo;

import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestadaGenerica;
import br.com.elotech.tributos.dto.integracaoelogeo.CadastroImobiliarioTestadaGenericaElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.LogradouroElogeoDTO;
import br.com.elotech.tributos.util.BooleanToStringUtils;
import java.math.BigDecimal;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class CadastroImobiliarioTestadaGenericaElogeoDTO {
    private Long id;
    @NotNull
    private Long codigo;
    @NotNull
    private BigDecimal tamanho = BigDecimal.ZERO;
    private BigDecimal profundidade = BigDecimal.ZERO;
    private String face;
    private BigDecimal valorM2 = BigDecimal.ZERO;
    @NotNull
    private String principal;
    private String numero;
    @NotNull
    @Valid
    private LogradouroElogeoDTO logradouro;

    public static Builder builder() {
        return new Builder();
    }

    public static CadastroImobiliarioTestadaGenericaElogeoDTO from(CadastroImobiliarioTestadaGenerica entity) {
        return CadastroImobiliarioTestadaGenericaElogeoDTO.builder().id(entity.getId()).codigo(entity.getCodigoTestadaGenerica()).tamanho(entity.getTamanho()).profundidade(entity.getProfundidade()).face(entity.getFace()).valorM2(entity.getValorM2()).principal(entity.getPrincipal().booleanValue()).numero(entity.getNumero()).logradouro((LogradouroElogeoDTO)Optional.ofNullable(entity.getLogradouro()).map(LogradouroElogeoDTO::from).orElse(null)).build();
    }

    public CadastroImobiliarioTestadaGenerica toEntity(Logradouro logradouro) {
        CadastroImobiliarioTestadaGenerica entity = new CadastroImobiliarioTestadaGenerica();
        entity.setId(this.getId());
        entity.setCodigoTestadaGenerica(this.getCodigo());
        entity.setTamanho(this.getTamanho());
        entity.setProfundidade(this.getProfundidade());
        entity.setFace(this.getFace());
        entity.setValorM2(this.getValorM2());
        Optional.ofNullable(this.getPrincipal()).ifPresent(principal -> entity.setPrincipal(BooleanToStringUtils.getStringAsBoolean((String)principal)));
        entity.setNumero(this.getNumero());
        entity.setLogradouro(logradouro);
        return entity;
    }

    @Generated
    public CadastroImobiliarioTestadaGenericaElogeoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getCodigo() {
        return this.codigo;
    }

    @Generated
    public BigDecimal getTamanho() {
        return this.tamanho;
    }

    @Generated
    public BigDecimal getProfundidade() {
        return this.profundidade;
    }

    @Generated
    public String getFace() {
        return this.face;
    }

    @Generated
    public BigDecimal getValorM2() {
        return this.valorM2;
    }

    @Generated
    public String getPrincipal() {
        return this.principal;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public LogradouroElogeoDTO getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setTamanho(BigDecimal tamanho) {
        this.tamanho = tamanho;
    }

    @Generated
    public void setProfundidade(BigDecimal profundidade) {
        this.profundidade = profundidade;
    }

    @Generated
    public void setFace(String face) {
        this.face = face;
    }

    @Generated
    public void setValorM2(BigDecimal valorM2) {
        this.valorM2 = valorM2;
    }

    @Generated
    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setLogradouro(LogradouroElogeoDTO logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroImobiliarioTestadaGenericaElogeoDTO)) {
            return false;
        }
        CadastroImobiliarioTestadaGenericaElogeoDTO other = (CadastroImobiliarioTestadaGenericaElogeoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo)) {
            return false;
        }
        BigDecimal this$tamanho = this.getTamanho();
        BigDecimal other$tamanho = other.getTamanho();
        if (this$tamanho == null ? other$tamanho != null : !((Object)this$tamanho).equals(other$tamanho)) {
            return false;
        }
        BigDecimal this$profundidade = this.getProfundidade();
        BigDecimal other$profundidade = other.getProfundidade();
        if (this$profundidade == null ? other$profundidade != null : !((Object)this$profundidade).equals(other$profundidade)) {
            return false;
        }
        String this$face = this.getFace();
        String other$face = other.getFace();
        if (this$face == null ? other$face != null : !this$face.equals(other$face)) {
            return false;
        }
        BigDecimal this$valorM2 = this.getValorM2();
        BigDecimal other$valorM2 = other.getValorM2();
        if (this$valorM2 == null ? other$valorM2 != null : !((Object)this$valorM2).equals(other$valorM2)) {
            return false;
        }
        String this$principal = this.getPrincipal();
        String other$principal = other.getPrincipal();
        if (this$principal == null ? other$principal != null : !this$principal.equals(other$principal)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        LogradouroElogeoDTO this$logradouro = this.getLogradouro();
        LogradouroElogeoDTO other$logradouro = other.getLogradouro();
        return !(this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroImobiliarioTestadaGenericaElogeoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        BigDecimal $tamanho = this.getTamanho();
        result = result * 59 + ($tamanho == null ? 43 : ((Object)$tamanho).hashCode());
        BigDecimal $profundidade = this.getProfundidade();
        result = result * 59 + ($profundidade == null ? 43 : ((Object)$profundidade).hashCode());
        String $face = this.getFace();
        result = result * 59 + ($face == null ? 43 : $face.hashCode());
        BigDecimal $valorM2 = this.getValorM2();
        result = result * 59 + ($valorM2 == null ? 43 : ((Object)$valorM2).hashCode());
        String $principal = this.getPrincipal();
        result = result * 59 + ($principal == null ? 43 : $principal.hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        LogradouroElogeoDTO $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CadastroImobiliarioTestadaGenericaElogeoDTO(id=" + this.getId() + ", codigo=" + this.getCodigo() + ", tamanho=" + this.getTamanho() + ", profundidade=" + this.getProfundidade() + ", face=" + this.getFace() + ", valorM2=" + this.getValorM2() + ", principal=" + this.getPrincipal() + ", numero=" + this.getNumero() + ", logradouro=" + this.getLogradouro() + ")";
    }
}

