/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoelogeo;

import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.imobiliario.BoletimImobiliarioTerreno;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.dto.camposdinamicos.RespostaDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.BairroElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.CadastroImobiliarioElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.CidadeElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.LogradouroElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.PessoaElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.ProprietarioElogeoDTO;
import br.com.elotech.tributos.util.BooleanToStringUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class CadastroGeralElogeoDTO {
    private Long id;
    private Long codigo;
    private TipoCadastro tipo;
    private String numero;
    private String complemento;
    private Long cep;
    private LocalDate dataInclusao;
    private LocalDate dataAlteracao;
    private String exclusaoLogica;
    private String englobado;
    private String correspondenciaLocal;
    private PessoaElogeoDTO pessoa;
    private LogradouroElogeoDTO logradouro;
    private BairroElogeoDTO bairro;
    private CidadeElogeoDTO cidade;
    private CadastroImobiliarioElogeoDTO imobiliario;
    private List<ProprietarioElogeoDTO> proprietarios;

    public static CadastroGeralElogeoDTO from(CadastroImobiliario cadastroImobiliarioEntity, List<BoletimImobiliarioTerreno> boletimTerreno) {
        CadastroGeralElogeoDTO cadastroGeralElogeoDTO = new CadastroGeralElogeoDTO();
        cadastroGeralElogeoDTO.setId(cadastroImobiliarioEntity.getId());
        cadastroGeralElogeoDTO.setCodigo(cadastroImobiliarioEntity.getCadastroGeral());
        cadastroGeralElogeoDTO.setTipo(cadastroImobiliarioEntity.getTipoCadastro());
        cadastroGeralElogeoDTO.setNumero(cadastroImobiliarioEntity.getNumero());
        cadastroGeralElogeoDTO.setComplemento(cadastroImobiliarioEntity.getComplemento());
        cadastroGeralElogeoDTO.setCep(cadastroImobiliarioEntity.getCep());
        cadastroGeralElogeoDTO.setDataInclusao(cadastroImobiliarioEntity.getDataInclusao());
        cadastroGeralElogeoDTO.setDataAlteracao(cadastroImobiliarioEntity.getDataAlteracao());
        cadastroGeralElogeoDTO.setExclusaoLogica(BooleanToStringUtils.getBooleanAsString((Boolean)cadastroImobiliarioEntity.getExclusaoLogica()));
        cadastroGeralElogeoDTO.setEnglobado(BooleanToStringUtils.getBooleanAsString((Boolean)cadastroImobiliarioEntity.getEnglobado()));
        cadastroGeralElogeoDTO.setCorrespondenciaLocal(BooleanToStringUtils.getBooleanAsString((Boolean)cadastroImobiliarioEntity.getCorrespondenciaLocal()));
        cadastroGeralElogeoDTO.setPessoa(PessoaElogeoDTO.from((Pessoa)cadastroImobiliarioEntity.getPessoa()));
        cadastroGeralElogeoDTO.setLogradouro((LogradouroElogeoDTO)Optional.ofNullable(cadastroImobiliarioEntity.getLogradouro()).map(logradouro -> LogradouroElogeoDTO.from((Logradouro)cadastroImobiliarioEntity.getLogradouro())).orElse(null));
        cadastroGeralElogeoDTO.setBairro((BairroElogeoDTO)Optional.ofNullable(cadastroImobiliarioEntity.getBairro()).map(bairro -> BairroElogeoDTO.from((Bairro)cadastroImobiliarioEntity.getBairro())).orElse(null));
        cadastroGeralElogeoDTO.setCidade((CidadeElogeoDTO)Optional.ofNullable(cadastroImobiliarioEntity.getCidade()).map(cidade -> CidadeElogeoDTO.from((Cidade)cadastroImobiliarioEntity.getCidade())).orElse(null));
        cadastroGeralElogeoDTO.setImobiliario(CadastroImobiliarioElogeoDTO.from((CadastroImobiliario)cadastroImobiliarioEntity, boletimTerreno));
        cadastroGeralElogeoDTO.setProprietarios(cadastroImobiliarioEntity.getProprietarios().stream().map(ProprietarioElogeoDTO::from).collect(Collectors.toList()));
        return cadastroGeralElogeoDTO;
    }

    public static CadastroGeralElogeoDTO oxyFrom(CadastroImobiliario cadastroImobiliarioEntity, List<RespostaDTO> boletimTerreno) {
        CadastroGeralElogeoDTO cadastroGeralElogeoDTO = new CadastroGeralElogeoDTO();
        cadastroGeralElogeoDTO.setId(cadastroImobiliarioEntity.getId());
        cadastroGeralElogeoDTO.setCodigo(cadastroImobiliarioEntity.getCadastroGeral());
        cadastroGeralElogeoDTO.setTipo(cadastroImobiliarioEntity.getTipoCadastro());
        cadastroGeralElogeoDTO.setNumero(cadastroImobiliarioEntity.getNumero());
        cadastroGeralElogeoDTO.setComplemento(cadastroImobiliarioEntity.getComplemento());
        cadastroGeralElogeoDTO.setCep(cadastroImobiliarioEntity.getCep());
        cadastroGeralElogeoDTO.setDataInclusao(cadastroImobiliarioEntity.getDataInclusao());
        cadastroGeralElogeoDTO.setDataAlteracao(cadastroImobiliarioEntity.getDataAlteracao());
        cadastroGeralElogeoDTO.setExclusaoLogica(BooleanToStringUtils.getBooleanAsString((Boolean)cadastroImobiliarioEntity.getExclusaoLogica()));
        cadastroGeralElogeoDTO.setEnglobado(BooleanToStringUtils.getBooleanAsString((Boolean)cadastroImobiliarioEntity.getEnglobado()));
        cadastroGeralElogeoDTO.setCorrespondenciaLocal(BooleanToStringUtils.getBooleanAsString((Boolean)cadastroImobiliarioEntity.getCorrespondenciaLocal()));
        cadastroGeralElogeoDTO.setPessoa(PessoaElogeoDTO.from((Pessoa)cadastroImobiliarioEntity.getPessoa()));
        cadastroGeralElogeoDTO.setLogradouro((LogradouroElogeoDTO)Optional.ofNullable(cadastroImobiliarioEntity.getLogradouro()).map(LogradouroElogeoDTO::from).orElse(null));
        cadastroGeralElogeoDTO.setBairro((BairroElogeoDTO)Optional.ofNullable(cadastroImobiliarioEntity.getBairro()).map(BairroElogeoDTO::from).orElse(null));
        cadastroGeralElogeoDTO.setCidade((CidadeElogeoDTO)Optional.ofNullable(cadastroImobiliarioEntity.getCidade()).map(CidadeElogeoDTO::from).orElse(null));
        cadastroGeralElogeoDTO.setImobiliario(CadastroImobiliarioElogeoDTO.oxyFrom((CadastroImobiliario)cadastroImobiliarioEntity, boletimTerreno));
        cadastroGeralElogeoDTO.setProprietarios(cadastroImobiliarioEntity.getProprietarios().stream().map(ProprietarioElogeoDTO::from).collect(Collectors.toList()));
        return cadastroGeralElogeoDTO;
    }

    @Generated
    public CadastroGeralElogeoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getCodigo() {
        return this.codigo;
    }

    @Generated
    public TipoCadastro getTipo() {
        return this.tipo;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public Long getCep() {
        return this.cep;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    @Generated
    public String getExclusaoLogica() {
        return this.exclusaoLogica;
    }

    @Generated
    public String getEnglobado() {
        return this.englobado;
    }

    @Generated
    public String getCorrespondenciaLocal() {
        return this.correspondenciaLocal;
    }

    @Generated
    public PessoaElogeoDTO getPessoa() {
        return this.pessoa;
    }

    @Generated
    public LogradouroElogeoDTO getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public BairroElogeoDTO getBairro() {
        return this.bairro;
    }

    @Generated
    public CidadeElogeoDTO getCidade() {
        return this.cidade;
    }

    @Generated
    public CadastroImobiliarioElogeoDTO getImobiliario() {
        return this.imobiliario;
    }

    @Generated
    public List<ProprietarioElogeoDTO> getProprietarios() {
        return this.proprietarios;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setTipo(TipoCadastro tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setCep(Long cep) {
        this.cep = cep;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @Generated
    public void setExclusaoLogica(String exclusaoLogica) {
        this.exclusaoLogica = exclusaoLogica;
    }

    @Generated
    public void setEnglobado(String englobado) {
        this.englobado = englobado;
    }

    @Generated
    public void setCorrespondenciaLocal(String correspondenciaLocal) {
        this.correspondenciaLocal = correspondenciaLocal;
    }

    @Generated
    public void setPessoa(PessoaElogeoDTO pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setLogradouro(LogradouroElogeoDTO logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setBairro(BairroElogeoDTO bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setCidade(CidadeElogeoDTO cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setImobiliario(CadastroImobiliarioElogeoDTO imobiliario) {
        this.imobiliario = imobiliario;
    }

    @Generated
    public void setProprietarios(List<ProprietarioElogeoDTO> proprietarios) {
        this.proprietarios = proprietarios;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroGeralElogeoDTO)) {
            return false;
        }
        CadastroGeralElogeoDTO other = (CadastroGeralElogeoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo)) {
            return false;
        }
        Long this$cep = this.getCep();
        Long other$cep = other.getCep();
        if (this$cep == null ? other$cep != null : !((Object)this$cep).equals(other$cep)) {
            return false;
        }
        TipoCadastro this$tipo = this.getTipo();
        TipoCadastro other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        if (this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento)) {
            return false;
        }
        LocalDate this$dataInclusao = this.getDataInclusao();
        LocalDate other$dataInclusao = other.getDataInclusao();
        if (this$dataInclusao == null ? other$dataInclusao != null : !((Object)this$dataInclusao).equals(other$dataInclusao)) {
            return false;
        }
        LocalDate this$dataAlteracao = this.getDataAlteracao();
        LocalDate other$dataAlteracao = other.getDataAlteracao();
        if (this$dataAlteracao == null ? other$dataAlteracao != null : !((Object)this$dataAlteracao).equals(other$dataAlteracao)) {
            return false;
        }
        String this$exclusaoLogica = this.getExclusaoLogica();
        String other$exclusaoLogica = other.getExclusaoLogica();
        if (this$exclusaoLogica == null ? other$exclusaoLogica != null : !this$exclusaoLogica.equals(other$exclusaoLogica)) {
            return false;
        }
        String this$englobado = this.getEnglobado();
        String other$englobado = other.getEnglobado();
        if (this$englobado == null ? other$englobado != null : !this$englobado.equals(other$englobado)) {
            return false;
        }
        String this$correspondenciaLocal = this.getCorrespondenciaLocal();
        String other$correspondenciaLocal = other.getCorrespondenciaLocal();
        if (this$correspondenciaLocal == null ? other$correspondenciaLocal != null : !this$correspondenciaLocal.equals(other$correspondenciaLocal)) {
            return false;
        }
        PessoaElogeoDTO this$pessoa = this.getPessoa();
        PessoaElogeoDTO other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !this$pessoa.equals(other$pessoa)) {
            return false;
        }
        LogradouroElogeoDTO this$logradouro = this.getLogradouro();
        LogradouroElogeoDTO other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        BairroElogeoDTO this$bairro = this.getBairro();
        BairroElogeoDTO other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        CidadeElogeoDTO this$cidade = this.getCidade();
        CidadeElogeoDTO other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !this$cidade.equals(other$cidade)) {
            return false;
        }
        CadastroImobiliarioElogeoDTO this$imobiliario = this.getImobiliario();
        CadastroImobiliarioElogeoDTO other$imobiliario = other.getImobiliario();
        if (this$imobiliario == null ? other$imobiliario != null : !this$imobiliario.equals(other$imobiliario)) {
            return false;
        }
        List this$proprietarios = this.getProprietarios();
        List other$proprietarios = other.getProprietarios();
        return !(this$proprietarios == null ? other$proprietarios != null : !((Object)this$proprietarios).equals(other$proprietarios));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroGeralElogeoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        Long $cep = this.getCep();
        result = result * 59 + ($cep == null ? 43 : ((Object)$cep).hashCode());
        TipoCadastro $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        LocalDate $dataInclusao = this.getDataInclusao();
        result = result * 59 + ($dataInclusao == null ? 43 : ((Object)$dataInclusao).hashCode());
        LocalDate $dataAlteracao = this.getDataAlteracao();
        result = result * 59 + ($dataAlteracao == null ? 43 : ((Object)$dataAlteracao).hashCode());
        String $exclusaoLogica = this.getExclusaoLogica();
        result = result * 59 + ($exclusaoLogica == null ? 43 : $exclusaoLogica.hashCode());
        String $englobado = this.getEnglobado();
        result = result * 59 + ($englobado == null ? 43 : $englobado.hashCode());
        String $correspondenciaLocal = this.getCorrespondenciaLocal();
        result = result * 59 + ($correspondenciaLocal == null ? 43 : $correspondenciaLocal.hashCode());
        PessoaElogeoDTO $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : $pessoa.hashCode());
        LogradouroElogeoDTO $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        BairroElogeoDTO $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        CidadeElogeoDTO $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : $cidade.hashCode());
        CadastroImobiliarioElogeoDTO $imobiliario = this.getImobiliario();
        result = result * 59 + ($imobiliario == null ? 43 : $imobiliario.hashCode());
        List $proprietarios = this.getProprietarios();
        result = result * 59 + ($proprietarios == null ? 43 : ((Object)$proprietarios).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CadastroGeralElogeoDTO(id=" + this.getId() + ", codigo=" + this.getCodigo() + ", tipo=" + this.getTipo() + ", numero=" + this.getNumero() + ", complemento=" + this.getComplemento() + ", cep=" + this.getCep() + ", dataInclusao=" + this.getDataInclusao() + ", dataAlteracao=" + this.getDataAlteracao() + ", exclusaoLogica=" + this.getExclusaoLogica() + ", englobado=" + this.getEnglobado() + ", correspondenciaLocal=" + this.getCorrespondenciaLocal() + ", pessoa=" + this.getPessoa() + ", logradouro=" + this.getLogradouro() + ", bairro=" + this.getBairro() + ", cidade=" + this.getCidade() + ", imobiliario=" + this.getImobiliario() + ", proprietarios=" + this.getProprietarios() + ")";
    }
}

