/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.delbank;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.WebHookDadosDelBankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.enums.EventTypeWebHookDelbank;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.enums.StatusPixDelbank;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WebHookDadosDelBankDTO {
    private EventTypeWebHookDelbank eventType;
    private String correlationId;
    private String referenceId;
    private String endToEndId;
    private BigDecimal valor;
    private StatusPixDelbank statusRecebimento;
    private String dataReferencia;
    private static final String EVENT_TYPE = "proof.eventType";
    private static final String STATUS_PAGAMENTO = "proof.status";
    private static final String IDENTIFICADOR_PIX_TXID = "correlationId";
    private static final String E2E = "endToEndId";
    private static final String VALOR = "amount";
    private static final String REFERENCIA_ID = "referenceId";
    private static final String DATA_HORA_CRIACAO = "createdAt";

    public static List<WebHookDadosDelBankDTO> from(JsonNode jsonWebHook) {
        if (jsonWebHook == null || jsonWebHook.isEmpty()) {
            throw new EloValidationException("O JSON do WebHook est\u00e1 vazio ou nulo.");
        }
        return Collections.singletonList(WebHookDadosDelBankDTO.builder().correlationId(WebHookDadosDelBankDTO.getString((JsonNode)jsonWebHook, (String)"correlationId")).endToEndId(WebHookDadosDelBankDTO.getString((JsonNode)jsonWebHook, (String)"endToEndId")).valor(WebHookDadosDelBankDTO.getBigDecimal((JsonNode)jsonWebHook, (String)"amount")).referenceId(WebHookDadosDelBankDTO.getString((JsonNode)jsonWebHook, (String)"referenceId")).statusRecebimento(StatusPixDelbank.fromValue((String)WebHookDadosDelBankDTO.getString((JsonNode)jsonWebHook, (String)"proof.status"))).eventType(EventTypeWebHookDelbank.fromValue((String)WebHookDadosDelBankDTO.getString((JsonNode)jsonWebHook, (String)"proof.eventType"))).dataReferencia(WebHookDadosDelBankDTO.formatarData((JsonNode)jsonWebHook.get("createdAt"))).build());
    }

    private static String getString(JsonNode jsonNode, String campo) {
        JsonNode node = WebHookDadosDelBankDTO.getNestedJsonNode((JsonNode)jsonNode, (String)campo);
        return node != null && node.isTextual() ? node.asText() : null;
    }

    private static BigDecimal getBigDecimal(JsonNode jsonNode, String campo) {
        return jsonNode.hasNonNull(campo) ? new BigDecimal(jsonNode.get(campo).asText()) : null;
    }

    private static JsonNode getNestedJsonNode(JsonNode jsonNode, String campo) {
        if (jsonNode == null || campo == null || campo.isEmpty()) {
            return null;
        }
        String[] chaves = campo.split("\\.");
        JsonNode currentNode = jsonNode;
        for (String chave : chaves) {
            if (currentNode == null || !currentNode.hasNonNull(chave)) {
                return null;
            }
            currentNode = currentNode.get(chave);
        }
        return currentNode;
    }

    private static String formatarData(JsonNode dataEventoNode) {
        if (dataEventoNode == null || !dataEventoNode.isTextual()) {
            throw new EloValidationException(String.format("Campo %s n\u00e3o encontrado ou inv\u00e1lido no retorno do WebHook.", "createdAt"));
        }
        try {
            return LocalDate.parse(dataEventoNode.asText().substring(0, 10)).toString();
        }
        catch (DateTimeException e) {
            throw new EloValidationException(String.format("Data inv\u00e1lida recebida pelo WEBHOOK: %s", dataEventoNode.asText()));
        }
    }

    @Generated
    public static WebHookDadosDelBankDTOBuilder builder() {
        return new WebHookDadosDelBankDTOBuilder();
    }

    @Generated
    public EventTypeWebHookDelbank getEventType() {
        return this.eventType;
    }

    @Generated
    public String getCorrelationId() {
        return this.correlationId;
    }

    @Generated
    public String getReferenceId() {
        return this.referenceId;
    }

    @Generated
    public String getEndToEndId() {
        return this.endToEndId;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public StatusPixDelbank getStatusRecebimento() {
        return this.statusRecebimento;
    }

    @Generated
    public String getDataReferencia() {
        return this.dataReferencia;
    }

    @Generated
    public void setEventType(EventTypeWebHookDelbank eventType) {
        this.eventType = eventType;
    }

    @Generated
    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    @Generated
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Generated
    public void setEndToEndId(String endToEndId) {
        this.endToEndId = endToEndId;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setStatusRecebimento(StatusPixDelbank statusRecebimento) {
        this.statusRecebimento = statusRecebimento;
    }

    @Generated
    public void setDataReferencia(String dataReferencia) {
        this.dataReferencia = dataReferencia;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebHookDadosDelBankDTO)) {
            return false;
        }
        WebHookDadosDelBankDTO other = (WebHookDadosDelBankDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        EventTypeWebHookDelbank this$eventType = this.getEventType();
        EventTypeWebHookDelbank other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        String this$correlationId = this.getCorrelationId();
        String other$correlationId = other.getCorrelationId();
        if (this$correlationId == null ? other$correlationId != null : !this$correlationId.equals(other$correlationId)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        String this$endToEndId = this.getEndToEndId();
        String other$endToEndId = other.getEndToEndId();
        if (this$endToEndId == null ? other$endToEndId != null : !this$endToEndId.equals(other$endToEndId)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        StatusPixDelbank this$statusRecebimento = this.getStatusRecebimento();
        StatusPixDelbank other$statusRecebimento = other.getStatusRecebimento();
        if (this$statusRecebimento == null ? other$statusRecebimento != null : !this$statusRecebimento.equals(other$statusRecebimento)) {
            return false;
        }
        String this$dataReferencia = this.getDataReferencia();
        String other$dataReferencia = other.getDataReferencia();
        return !(this$dataReferencia == null ? other$dataReferencia != null : !this$dataReferencia.equals(other$dataReferencia));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WebHookDadosDelBankDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventTypeWebHookDelbank $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        String $correlationId = this.getCorrelationId();
        result = result * 59 + ($correlationId == null ? 43 : $correlationId.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        String $endToEndId = this.getEndToEndId();
        result = result * 59 + ($endToEndId == null ? 43 : $endToEndId.hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        StatusPixDelbank $statusRecebimento = this.getStatusRecebimento();
        result = result * 59 + ($statusRecebimento == null ? 43 : $statusRecebimento.hashCode());
        String $dataReferencia = this.getDataReferencia();
        result = result * 59 + ($dataReferencia == null ? 43 : $dataReferencia.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WebHookDadosDelBankDTO(eventType=" + this.getEventType() + ", correlationId=" + this.getCorrelationId() + ", referenceId=" + this.getReferenceId() + ", endToEndId=" + this.getEndToEndId() + ", valor=" + this.getValor() + ", statusRecebimento=" + this.getStatusRecebimento() + ", dataReferencia=" + this.getDataReferencia() + ")";
    }

    @Generated
    public WebHookDadosDelBankDTO(EventTypeWebHookDelbank eventType, String correlationId, String referenceId, String endToEndId, BigDecimal valor, StatusPixDelbank statusRecebimento, String dataReferencia) {
        this.eventType = eventType;
        this.correlationId = correlationId;
        this.referenceId = referenceId;
        this.endToEndId = endToEndId;
        this.valor = valor;
        this.statusRecebimento = statusRecebimento;
        this.dataReferencia = dataReferencia;
    }

    @Generated
    public WebHookDadosDelBankDTO() {
    }
}

