/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.delbank;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.AddressDelBankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.DiscountQrCodeDelBankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.GerarQrCodePixDelBankRequestDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.PayerDelBankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.TaxesQrCodeDelbankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.enums.TaxesTypeDelbank;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GerarQrCodePixDelBankRequestDTO {
    private String correlationId;
    private BigDecimal amount;
    private LocalDate dueDate;
    private Long expiresIn;
    private PayerDelBankDTO payer;
    private TaxesQrCodeDelbankDTO taxes;
    private String formatResponse;
    private String description;
    private String pixKey;
    private String additionalInformation;
    private static final String ISENTO = "ISENTO";
    private static final Long TIPO_SEM_DESCONTO = 0L;
    private static final Long TIPO_DESCONTO_FIXO = 1L;
    private static final Long TIPO_DESCONTO_PERCENTUAL = 2L;
    private static final Long TIPO_MULTA_ISENTO = 0L;
    private static final Long TIPO_MULTA_FIXO = 1L;
    private static final Long TIPO_MULTA_PERCENTUAL = 2L;
    private static final Long TIPO_JUROS_ISENTO = 3L;
    private static final Long TIPO_JUROS_FIXO = 1L;
    private static final Long TIPO_JUROS_PERCENTUAL = 2L;
    private static final String PERCENTUAL = "PERCENTAGE";
    private static final String FIXO = "FIXED_AMOUNT";
    public static final String PAYLOAD_AND_QRCODE = "PAYLOAD_AND_QRCODE";

    public static GerarQrCodePixDelBankRequestDTO from(Bloqueto bloqueto, ParametroCNAB240 parametroCNAB240) {
        Pessoa pessoa = bloqueto.getPessoa();
        EnderecoPessoa enderecoPrincipal = pessoa.getEnderecoPrincipal();
        GerarQrCodePixDelBankRequestDTOBuilder dtoBuilder = GerarQrCodePixDelBankRequestDTO.builder().correlationId(UUID.randomUUID().toString()).formatResponse("PAYLOAD_AND_QRCODE").amount(bloqueto.getValorBloqueto()).dueDate(bloqueto.getDataVencimento()).expiresIn(Long.valueOf(GerarQrCodePixDelBankRequestDTO.calcularExpiresIn((LocalDate)bloqueto.getDataVencimento()))).payer(GerarQrCodePixDelBankRequestDTO.builderPayer((Pessoa)pessoa, (EnderecoPessoa)enderecoPrincipal));
        TaxesQrCodeDelbankDTO taxes = GerarQrCodePixDelBankRequestDTO.builderTaxes((Bloqueto)bloqueto, (ParametroCNAB240)parametroCNAB240);
        if (taxes != null) {
            dtoBuilder.taxes(taxes);
        }
        GerarQrCodePixDelBankRequestDTO dto = dtoBuilder.build();
        GerarQrCodePixDelBankRequestDTO.validarParametrosObrigatorios((GerarQrCodePixDelBankRequestDTO)dto);
        return dto;
    }

    public static long calcularExpiresIn(LocalDate dataVencimento) {
        return Math.max(0L, LocalDateTime.now().until(dataVencimento.atTime(LocalTime.MAX), ChronoUnit.SECONDS));
    }

    public static PayerDelBankDTO builderPayer(Pessoa pessoa, EnderecoPessoa enderecoPrincipal) {
        return PayerDelBankDTO.builder().name(StringUtils.substring((String)pessoa.getNome(), (int)0, (int)40)).document(pessoa.getCnpjCpfSemMascara()).address(GerarQrCodePixDelBankRequestDTO.builderAddress((EnderecoPessoa)enderecoPrincipal)).build();
    }

    public static AddressDelBankDTO builderAddress(EnderecoPessoa enderecoPessoa) {
        if (enderecoPessoa == null) {
            return null;
        }
        return AddressDelBankDTO.builder().cityName(Optional.ofNullable(enderecoPessoa.getCidade()).map(Cidade::getDescricao).map(desc -> desc.length() > 50 ? desc.substring(0, 50) : desc).orElse("")).zipCode(Optional.ofNullable(enderecoPessoa.getCep()).map(cep -> StringUtils.leftPad((String)cep.toString(), (int)8, (String)"0")).orElse(StringUtils.leftPad((String)"0", (int)8, (String)"0"))).uf(Optional.ofNullable(enderecoPessoa.getCidade()).map(Cidade::getUnidadeFederacao).orElse("")).state(Optional.ofNullable(enderecoPessoa.getCidade()).map(Cidade::getUnidadeFederacao).orElse("")).street(Optional.ofNullable(enderecoPessoa.getLogradouro()).map(logradouro -> GerarQrCodePixDelBankRequestDTO.formatarStreet((String)logradouro.getTipoLogradouroDescricao(), (String)logradouro.getDescricao(), (String)enderecoPessoa.getNumero(), (String)enderecoPessoa.getComplemento())).orElse("")).build();
    }

    public static String formatarStreet(String tipoLogradouro, String descricaoLogradouro, String numero, String complemento) {
        String formatted = String.format("%s %s %s %s", Optional.ofNullable(tipoLogradouro).orElse(""), Optional.ofNullable(descricaoLogradouro).orElse(""), Optional.ofNullable(StringUtils.substring((String)numero, (int)0, (int)15)).orElse(""), Optional.ofNullable(StringUtils.substring((String)complemento, (int)0, (int)30)).orElse(""));
        return StringUtils.substring((String)StringUtils.normalizeSpace((String)formatted), (int)0, (int)40);
    }

    public static void validarParametrosObrigatorios(GerarQrCodePixDelBankRequestDTO dto) {
        Validate.notNull((Object)dto);
        Validate.notNull((Object)dto.getDueDate(), (String)"A data de vencimento \u00e9 obrigat\u00f3rio");
        Validate.notNull((Object)dto.getAmount(), (String)"O valor do Qrcode \u00e9 obrigat\u00f3rio");
        Validate.notNull((Object)dto.getCorrelationId(), (String)"Identificador da cobran\u00e7a \u00e9 obrigat\u00f3rio");
    }

    private static TaxesQrCodeDelbankDTO builderTaxes(Bloqueto bloqueto, ParametroCNAB240 parametroCNAB240) {
        String fineType;
        String interestType;
        if (!Objects.nonNull(parametroCNAB240)) {
            return null;
        }
        TaxesQrCodeDelbankDTO.TaxesQrCodeDelbankDTOBuilder builder = TaxesQrCodeDelbankDTO.builder().rebateType(null);
        String discountType = GerarQrCodePixDelBankRequestDTO.getTipoDesconto((ParametroCNAB240)parametroCNAB240);
        if (!discountType.equalsIgnoreCase("ISENTO")) {
            builder.discountType(discountType).discountsDueDate(GerarQrCodePixDelBankRequestDTO.builderItensDueDate((ParametroCNAB240)parametroCNAB240, (Bloqueto)bloqueto));
        }
        if (!(interestType = GerarQrCodePixDelBankRequestDTO.getTipoJuros((ParametroCNAB240)parametroCNAB240)).equalsIgnoreCase("ISENTO")) {
            builder.interestType(interestType).interestAmount(Optional.ofNullable(parametroCNAB240.getValorJurosDiaTaxa()).orElse(BigDecimal.ZERO));
        }
        if (!(fineType = GerarQrCodePixDelBankRequestDTO.getTipoMulta((ParametroCNAB240)parametroCNAB240)).equalsIgnoreCase("ISENTO")) {
            builder.fineType(fineType).fineAmount(Optional.ofNullable(parametroCNAB240.getValorPercentualMulta()).orElse(BigDecimal.ZERO));
        }
        return builder.build();
    }

    private static List<DiscountQrCodeDelBankDTO> builderItensDueDate(ParametroCNAB240 parametrosCNAB240, Bloqueto boleto) {
        return Stream.of(DiscountQrCodeDelBankDTO.builder().dueDate(boleto.getDataVencimento()).amount(parametrosCNAB240.getValorPercentualDesconto()).build()).filter(item -> item.getDueDate() != null).collect(Collectors.toList());
    }

    private static String getTipoMulta(ParametroCNAB240 parametrosCNAB240) {
        if (parametrosCNAB240 == null || parametrosCNAB240.getCodigoJuros() == null || TIPO_MULTA_ISENTO.equals(parametrosCNAB240.getCodigoMulta().getId())) {
            return "ISENTO";
        }
        Long codigoMulta = parametrosCNAB240.getCodigoDesconto().getId();
        if (TIPO_MULTA_FIXO.equals(codigoMulta)) {
            return TaxesTypeDelbank.FIXED_AMOUNT.getValue();
        }
        if (TIPO_MULTA_PERCENTUAL.equals(codigoMulta)) {
            return TaxesTypeDelbank.PERCENTAGE.getValue();
        }
        return "ISENTO";
    }

    private static String getTipoJuros(ParametroCNAB240 parametrosCNAB240) {
        if (parametrosCNAB240 == null || parametrosCNAB240.getCodigoJuros() == null || TIPO_JUROS_ISENTO.equals(parametrosCNAB240.getCodigoJuros().getId())) {
            return "ISENTO";
        }
        Long codigoJuros = parametrosCNAB240.getCodigoDesconto().getId();
        if (TIPO_JUROS_FIXO.equals(codigoJuros)) {
            return TaxesTypeDelbank.TIPO_JUROS_FIXO_QRCODE_DIA.getValue();
        }
        if (TIPO_JUROS_PERCENTUAL.equals(codigoJuros)) {
            return TaxesTypeDelbank.TIPO_JUROS_PERCENTAGEM_QRCODE_DIA.getValue();
        }
        return "ISENTO";
    }

    private static String getTipoDesconto(ParametroCNAB240 parametrosCNAB240) {
        if (parametrosCNAB240 == null || parametrosCNAB240.getCodigoDesconto() == null || TIPO_SEM_DESCONTO.equals(parametrosCNAB240.getCodigoDesconto().getId())) {
            return "ISENTO";
        }
        Long codigoDesconto = parametrosCNAB240.getCodigoDesconto().getId();
        if (TIPO_DESCONTO_FIXO.equals(codigoDesconto)) {
            return "FIXED_AMOUNT";
        }
        if (TIPO_DESCONTO_PERCENTUAL.equals(codigoDesconto)) {
            return "PERCENTAGE";
        }
        return "ISENTO";
    }

    @Generated
    GerarQrCodePixDelBankRequestDTO(String correlationId, BigDecimal amount, LocalDate dueDate, Long expiresIn, PayerDelBankDTO payer, TaxesQrCodeDelbankDTO taxes, String formatResponse, String description, String pixKey, String additionalInformation) {
        this.correlationId = correlationId;
        this.amount = amount;
        this.dueDate = dueDate;
        this.expiresIn = expiresIn;
        this.payer = payer;
        this.taxes = taxes;
        this.formatResponse = formatResponse;
        this.description = description;
        this.pixKey = pixKey;
        this.additionalInformation = additionalInformation;
    }

    @Generated
    public static GerarQrCodePixDelBankRequestDTOBuilder builder() {
        return new GerarQrCodePixDelBankRequestDTOBuilder();
    }

    @Generated
    public String getCorrelationId() {
        return this.correlationId;
    }

    @Generated
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Generated
    public LocalDate getDueDate() {
        return this.dueDate;
    }

    @Generated
    public Long getExpiresIn() {
        return this.expiresIn;
    }

    @Generated
    public PayerDelBankDTO getPayer() {
        return this.payer;
    }

    @Generated
    public TaxesQrCodeDelbankDTO getTaxes() {
        return this.taxes;
    }

    @Generated
    public String getFormatResponse() {
        return this.formatResponse;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getPixKey() {
        return this.pixKey;
    }

    @Generated
    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    @Generated
    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    @Generated
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    @Generated
    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
    }

    @Generated
    public void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }

    @Generated
    public void setPayer(PayerDelBankDTO payer) {
        this.payer = payer;
    }

    @Generated
    public void setTaxes(TaxesQrCodeDelbankDTO taxes) {
        this.taxes = taxes;
    }

    @Generated
    public void setFormatResponse(String formatResponse) {
        this.formatResponse = formatResponse;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setPixKey(String pixKey) {
        this.pixKey = pixKey;
    }

    @Generated
    public void setAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GerarQrCodePixDelBankRequestDTO)) {
            return false;
        }
        GerarQrCodePixDelBankRequestDTO other = (GerarQrCodePixDelBankRequestDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$expiresIn = this.getExpiresIn();
        Long other$expiresIn = other.getExpiresIn();
        if (this$expiresIn == null ? other$expiresIn != null : !((Object)this$expiresIn).equals(other$expiresIn)) {
            return false;
        }
        String this$correlationId = this.getCorrelationId();
        String other$correlationId = other.getCorrelationId();
        if (this$correlationId == null ? other$correlationId != null : !this$correlationId.equals(other$correlationId)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        LocalDate this$dueDate = this.getDueDate();
        LocalDate other$dueDate = other.getDueDate();
        if (this$dueDate == null ? other$dueDate != null : !((Object)this$dueDate).equals(other$dueDate)) {
            return false;
        }
        PayerDelBankDTO this$payer = this.getPayer();
        PayerDelBankDTO other$payer = other.getPayer();
        if (this$payer == null ? other$payer != null : !this$payer.equals(other$payer)) {
            return false;
        }
        TaxesQrCodeDelbankDTO this$taxes = this.getTaxes();
        TaxesQrCodeDelbankDTO other$taxes = other.getTaxes();
        if (this$taxes == null ? other$taxes != null : !this$taxes.equals(other$taxes)) {
            return false;
        }
        String this$formatResponse = this.getFormatResponse();
        String other$formatResponse = other.getFormatResponse();
        if (this$formatResponse == null ? other$formatResponse != null : !this$formatResponse.equals(other$formatResponse)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$pixKey = this.getPixKey();
        String other$pixKey = other.getPixKey();
        if (this$pixKey == null ? other$pixKey != null : !this$pixKey.equals(other$pixKey)) {
            return false;
        }
        String this$additionalInformation = this.getAdditionalInformation();
        String other$additionalInformation = other.getAdditionalInformation();
        return !(this$additionalInformation == null ? other$additionalInformation != null : !this$additionalInformation.equals(other$additionalInformation));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GerarQrCodePixDelBankRequestDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $expiresIn = this.getExpiresIn();
        result = result * 59 + ($expiresIn == null ? 43 : ((Object)$expiresIn).hashCode());
        String $correlationId = this.getCorrelationId();
        result = result * 59 + ($correlationId == null ? 43 : $correlationId.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        LocalDate $dueDate = this.getDueDate();
        result = result * 59 + ($dueDate == null ? 43 : ((Object)$dueDate).hashCode());
        PayerDelBankDTO $payer = this.getPayer();
        result = result * 59 + ($payer == null ? 43 : $payer.hashCode());
        TaxesQrCodeDelbankDTO $taxes = this.getTaxes();
        result = result * 59 + ($taxes == null ? 43 : $taxes.hashCode());
        String $formatResponse = this.getFormatResponse();
        result = result * 59 + ($formatResponse == null ? 43 : $formatResponse.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $pixKey = this.getPixKey();
        result = result * 59 + ($pixKey == null ? 43 : $pixKey.hashCode());
        String $additionalInformation = this.getAdditionalInformation();
        result = result * 59 + ($additionalInformation == null ? 43 : $additionalInformation.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GerarQrCodePixDelBankRequestDTO(correlationId=" + this.getCorrelationId() + ", amount=" + this.getAmount() + ", dueDate=" + this.getDueDate() + ", expiresIn=" + this.getExpiresIn() + ", payer=" + this.getPayer() + ", taxes=" + this.getTaxes() + ", formatResponse=" + this.getFormatResponse() + ", description=" + this.getDescription() + ", pixKey=" + this.getPixKey() + ", additionalInformation=" + this.getAdditionalInformation() + ")";
    }
}

