/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.documento.peticao;

import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtiva;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class ExecucaoPeticaoResponseDTO
implements Serializable {
    private Long id;
    private Long documento;
    private Long exercicio;
    private String tipoCadastro;
    private Long cadastroGeral;
    private String nomeContribuinte;
    private String cpfCnpj;
    private String numeroProcessoJudicial;
    private BigDecimal valorTotalPeticao;
    private String situacao;
    private Boolean cancelado;
    private LocalDate dataEmissao;
    private String statusDebito;

    public static ExecucaoPeticaoResponseDTO from(Documento documento) {
        ExecucaoPeticaoResponseDTO execucaoPeticaoResponseDTO = new ExecucaoPeticaoResponseDTO();
        Optional.ofNullable(documento).ifPresent(doc -> {
            execucaoPeticaoResponseDTO.setId(doc.getId());
            execucaoPeticaoResponseDTO.setDocumento(doc.getDocumento());
            execucaoPeticaoResponseDTO.setExercicio(doc.getExercicio());
            execucaoPeticaoResponseDTO.setTipoCadastro(doc.getTipoCadastro().getDescricao());
            execucaoPeticaoResponseDTO.setCadastroGeral(doc.getCodigoCadastroGeral());
            Optional.ofNullable(doc.getPessoa()).ifPresent(pessoa -> {
                execucaoPeticaoResponseDTO.setNomeContribuinte(pessoa.getNome());
                execucaoPeticaoResponseDTO.setCpfCnpj(pessoa.getCnpjCpf());
            });
            doc.getCertidoesDividaAtivaPeticao().stream().flatMap(certidao -> certidao.getDocumentoItemDividaAtivas().stream()).flatMap(ExecucaoPeticaoResponseDTO::getParcelaByDocumentoItemDividaAtiva).findFirst().ifPresent(parcela -> execucaoPeticaoResponseDTO.setNumeroProcessoJudicial(parcela.getProcessoJudicial()));
            execucaoPeticaoResponseDTO.setValorTotalPeticao(doc.getValorTotalDividaAtivasPeticao());
            execucaoPeticaoResponseDTO.setSituacao(doc.getSituacao().getDescricao());
            execucaoPeticaoResponseDTO.setCancelado(doc.getCancelado());
            execucaoPeticaoResponseDTO.setDataEmissao(doc.getDataEmissao());
        });
        return execucaoPeticaoResponseDTO;
    }

    public static Stream<DebitoParcela> getParcelaByDocumentoItemDividaAtiva(DocumentoItemDividaAtiva documentoItemDividaAtiva) {
        DebitoParcelaId parcelaEmDividaAtiva = DebitoParcelaId.from((DocumentoItemDividaAtiva)documentoItemDividaAtiva);
        return documentoItemDividaAtiva.getDebito().getParcelas().stream().filter(debitoParcela -> debitoParcela.getId().equals((Object)parcelaEmDividaAtiva) && debitoParcela.isEmProcessoJudicial()).collect(Collectors.toList()).stream();
    }

    public static Stream<DebitoParcela> getParcelaEmDocumentoItemDividaAtivaSemValidarProcessoJudicial(DocumentoItemDividaAtiva documentoItemDividaAtiva) {
        DebitoParcelaId parcelaEmDividaAtiva = DebitoParcelaId.from((DocumentoItemDividaAtiva)documentoItemDividaAtiva);
        return documentoItemDividaAtiva.getDebito().getParcelas().stream().filter(debitoParcela -> debitoParcela.getId().equals((Object)parcelaEmDividaAtiva)).collect(Collectors.toList()).stream();
    }

    @Generated
    public ExecucaoPeticaoResponseDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getDocumento() {
        return this.documento;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getNomeContribuinte() {
        return this.nomeContribuinte;
    }

    @Generated
    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    @Generated
    public String getNumeroProcessoJudicial() {
        return this.numeroProcessoJudicial;
    }

    @Generated
    public BigDecimal getValorTotalPeticao() {
        return this.valorTotalPeticao;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public Boolean getCancelado() {
        return this.cancelado;
    }

    @Generated
    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public String getStatusDebito() {
        return this.statusDebito;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDocumento(Long documento) {
        this.documento = documento;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(String tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setNomeContribuinte(String nomeContribuinte) {
        this.nomeContribuinte = nomeContribuinte;
    }

    @Generated
    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    @Generated
    public void setNumeroProcessoJudicial(String numeroProcessoJudicial) {
        this.numeroProcessoJudicial = numeroProcessoJudicial;
    }

    @Generated
    public void setValorTotalPeticao(BigDecimal valorTotalPeticao) {
        this.valorTotalPeticao = valorTotalPeticao;
    }

    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setCancelado(Boolean cancelado) {
        this.cancelado = cancelado;
    }

    @Generated
    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Generated
    public void setStatusDebito(String statusDebito) {
        this.statusDebito = statusDebito;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecucaoPeticaoResponseDTO)) {
            return false;
        }
        ExecucaoPeticaoResponseDTO other = (ExecucaoPeticaoResponseDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$documento = this.getDocumento();
        Long other$documento = other.getDocumento();
        if (this$documento == null ? other$documento != null : !((Object)this$documento).equals(other$documento)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Boolean this$cancelado = this.getCancelado();
        Boolean other$cancelado = other.getCancelado();
        if (this$cancelado == null ? other$cancelado != null : !((Object)this$cancelado).equals(other$cancelado)) {
            return false;
        }
        String this$tipoCadastro = this.getTipoCadastro();
        String other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$nomeContribuinte = this.getNomeContribuinte();
        String other$nomeContribuinte = other.getNomeContribuinte();
        if (this$nomeContribuinte == null ? other$nomeContribuinte != null : !this$nomeContribuinte.equals(other$nomeContribuinte)) {
            return false;
        }
        String this$cpfCnpj = this.getCpfCnpj();
        String other$cpfCnpj = other.getCpfCnpj();
        if (this$cpfCnpj == null ? other$cpfCnpj != null : !this$cpfCnpj.equals(other$cpfCnpj)) {
            return false;
        }
        String this$numeroProcessoJudicial = this.getNumeroProcessoJudicial();
        String other$numeroProcessoJudicial = other.getNumeroProcessoJudicial();
        if (this$numeroProcessoJudicial == null ? other$numeroProcessoJudicial != null : !this$numeroProcessoJudicial.equals(other$numeroProcessoJudicial)) {
            return false;
        }
        BigDecimal this$valorTotalPeticao = this.getValorTotalPeticao();
        BigDecimal other$valorTotalPeticao = other.getValorTotalPeticao();
        if (this$valorTotalPeticao == null ? other$valorTotalPeticao != null : !((Object)this$valorTotalPeticao).equals(other$valorTotalPeticao)) {
            return false;
        }
        String this$situacao = this.getSituacao();
        String other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        LocalDate this$dataEmissao = this.getDataEmissao();
        LocalDate other$dataEmissao = other.getDataEmissao();
        if (this$dataEmissao == null ? other$dataEmissao != null : !((Object)this$dataEmissao).equals(other$dataEmissao)) {
            return false;
        }
        String this$statusDebito = this.getStatusDebito();
        String other$statusDebito = other.getStatusDebito();
        return !(this$statusDebito == null ? other$statusDebito != null : !this$statusDebito.equals(other$statusDebito));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExecucaoPeticaoResponseDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $documento = this.getDocumento();
        result = result * 59 + ($documento == null ? 43 : ((Object)$documento).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Boolean $cancelado = this.getCancelado();
        result = result * 59 + ($cancelado == null ? 43 : ((Object)$cancelado).hashCode());
        String $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $nomeContribuinte = this.getNomeContribuinte();
        result = result * 59 + ($nomeContribuinte == null ? 43 : $nomeContribuinte.hashCode());
        String $cpfCnpj = this.getCpfCnpj();
        result = result * 59 + ($cpfCnpj == null ? 43 : $cpfCnpj.hashCode());
        String $numeroProcessoJudicial = this.getNumeroProcessoJudicial();
        result = result * 59 + ($numeroProcessoJudicial == null ? 43 : $numeroProcessoJudicial.hashCode());
        BigDecimal $valorTotalPeticao = this.getValorTotalPeticao();
        result = result * 59 + ($valorTotalPeticao == null ? 43 : ((Object)$valorTotalPeticao).hashCode());
        String $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        LocalDate $dataEmissao = this.getDataEmissao();
        result = result * 59 + ($dataEmissao == null ? 43 : ((Object)$dataEmissao).hashCode());
        String $statusDebito = this.getStatusDebito();
        result = result * 59 + ($statusDebito == null ? 43 : $statusDebito.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ExecucaoPeticaoResponseDTO(id=" + this.getId() + ", documento=" + this.getDocumento() + ", exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", nomeContribuinte=" + this.getNomeContribuinte() + ", cpfCnpj=" + this.getCpfCnpj() + ", numeroProcessoJudicial=" + this.getNumeroProcessoJudicial() + ", valorTotalPeticao=" + this.getValorTotalPeticao() + ", situacao=" + this.getSituacao() + ", cancelado=" + this.getCancelado() + ", dataEmissao=" + this.getDataEmissao() + ", statusDebito=" + this.getStatusDebito() + ")";
    }
}

