/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.dividaativa;

import br.com.elotech.tributos.domain.LivroParcelaTributo;
import br.com.elotech.tributos.domain.LivroRegistro;
import java.math.BigDecimal;
import lombok.Generated;

public class LivroRegistroDTO {
    private Long entidade;
    private Long exercicio;
    private Long livro;
    private Long sequencia;
    private Long numeroFolha;
    private Long sequenciaFolha;
    private Long numeroInscricao;
    private Long pessoaId;
    private String pessoaNome;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private BigDecimal valorTotal = BigDecimal.ZERO;
    private Boolean estornado = Boolean.FALSE;

    public static LivroRegistroDTO of(LivroRegistro livroRegistro) {
        LivroRegistroDTO livroRegistroDTO = new LivroRegistroDTO();
        livroRegistroDTO.setEntidade(livroRegistro.getId().getLivro().getId().getEntidade());
        livroRegistroDTO.setExercicio(livroRegistro.getId().getLivro().getId().getExercicio());
        livroRegistroDTO.setLivro(livroRegistro.getId().getLivro().getId().getLivro());
        livroRegistroDTO.setSequencia(livroRegistro.getId().getSequencia());
        livroRegistroDTO.setNumeroFolha(livroRegistro.getNumeroFolha());
        livroRegistroDTO.setSequenciaFolha(livroRegistro.getSequenciaFolha());
        livroRegistroDTO.setNumeroInscricao(livroRegistro.getNumeroInscricao());
        livroRegistroDTO.setPessoaId(livroRegistro.getPessoa().getId());
        livroRegistroDTO.setPessoaNome(livroRegistro.getPessoa().getNome());
        livroRegistroDTO.setTipoCadastro(livroRegistro.getCadastroGeral().getTipoCadastro().getValue());
        livroRegistroDTO.setCadastroGeral(livroRegistro.getCadastroGeral().getCadastroGeral());
        livroRegistroDTO.setValorTotal(livroRegistro.getValorTotal());
        livroRegistroDTO.setEstornado(Boolean.valueOf(livroRegistro.getParcelaTributos().stream().allMatch(LivroParcelaTributo::getEstornado)));
        return livroRegistroDTO;
    }

    @Generated
    public LivroRegistroDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getLivro() {
        return this.livro;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public Long getNumeroFolha() {
        return this.numeroFolha;
    }

    @Generated
    public Long getSequenciaFolha() {
        return this.sequenciaFolha;
    }

    @Generated
    public Long getNumeroInscricao() {
        return this.numeroInscricao;
    }

    @Generated
    public Long getPessoaId() {
        return this.pessoaId;
    }

    @Generated
    public String getPessoaNome() {
        return this.pessoaNome;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public Boolean getEstornado() {
        return this.estornado;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setLivro(Long livro) {
        this.livro = livro;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setNumeroFolha(Long numeroFolha) {
        this.numeroFolha = numeroFolha;
    }

    @Generated
    public void setSequenciaFolha(Long sequenciaFolha) {
        this.sequenciaFolha = sequenciaFolha;
    }

    @Generated
    public void setNumeroInscricao(Long numeroInscricao) {
        this.numeroInscricao = numeroInscricao;
    }

    @Generated
    public void setPessoaId(Long pessoaId) {
        this.pessoaId = pessoaId;
    }

    @Generated
    public void setPessoaNome(String pessoaNome) {
        this.pessoaNome = pessoaNome;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setEstornado(Boolean estornado) {
        this.estornado = estornado;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LivroRegistroDTO)) {
            return false;
        }
        LivroRegistroDTO other = (LivroRegistroDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$livro = this.getLivro();
        Long other$livro = other.getLivro();
        if (this$livro == null ? other$livro != null : !((Object)this$livro).equals(other$livro)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        Long this$numeroFolha = this.getNumeroFolha();
        Long other$numeroFolha = other.getNumeroFolha();
        if (this$numeroFolha == null ? other$numeroFolha != null : !((Object)this$numeroFolha).equals(other$numeroFolha)) {
            return false;
        }
        Long this$sequenciaFolha = this.getSequenciaFolha();
        Long other$sequenciaFolha = other.getSequenciaFolha();
        if (this$sequenciaFolha == null ? other$sequenciaFolha != null : !((Object)this$sequenciaFolha).equals(other$sequenciaFolha)) {
            return false;
        }
        Long this$numeroInscricao = this.getNumeroInscricao();
        Long other$numeroInscricao = other.getNumeroInscricao();
        if (this$numeroInscricao == null ? other$numeroInscricao != null : !((Object)this$numeroInscricao).equals(other$numeroInscricao)) {
            return false;
        }
        Long this$pessoaId = this.getPessoaId();
        Long other$pessoaId = other.getPessoaId();
        if (this$pessoaId == null ? other$pessoaId != null : !((Object)this$pessoaId).equals(other$pessoaId)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Boolean this$estornado = this.getEstornado();
        Boolean other$estornado = other.getEstornado();
        if (this$estornado == null ? other$estornado != null : !((Object)this$estornado).equals(other$estornado)) {
            return false;
        }
        String this$pessoaNome = this.getPessoaNome();
        String other$pessoaNome = other.getPessoaNome();
        if (this$pessoaNome == null ? other$pessoaNome != null : !this$pessoaNome.equals(other$pessoaNome)) {
            return false;
        }
        BigDecimal this$valorTotal = this.getValorTotal();
        BigDecimal other$valorTotal = other.getValorTotal();
        return !(this$valorTotal == null ? other$valorTotal != null : !((Object)this$valorTotal).equals(other$valorTotal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LivroRegistroDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $livro = this.getLivro();
        result = result * 59 + ($livro == null ? 43 : ((Object)$livro).hashCode());
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        Long $numeroFolha = this.getNumeroFolha();
        result = result * 59 + ($numeroFolha == null ? 43 : ((Object)$numeroFolha).hashCode());
        Long $sequenciaFolha = this.getSequenciaFolha();
        result = result * 59 + ($sequenciaFolha == null ? 43 : ((Object)$sequenciaFolha).hashCode());
        Long $numeroInscricao = this.getNumeroInscricao();
        result = result * 59 + ($numeroInscricao == null ? 43 : ((Object)$numeroInscricao).hashCode());
        Long $pessoaId = this.getPessoaId();
        result = result * 59 + ($pessoaId == null ? 43 : ((Object)$pessoaId).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Boolean $estornado = this.getEstornado();
        result = result * 59 + ($estornado == null ? 43 : ((Object)$estornado).hashCode());
        String $pessoaNome = this.getPessoaNome();
        result = result * 59 + ($pessoaNome == null ? 43 : $pessoaNome.hashCode());
        BigDecimal $valorTotal = this.getValorTotal();
        result = result * 59 + ($valorTotal == null ? 43 : ((Object)$valorTotal).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LivroRegistroDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", livro=" + this.getLivro() + ", sequencia=" + this.getSequencia() + ", numeroFolha=" + this.getNumeroFolha() + ", sequenciaFolha=" + this.getSequenciaFolha() + ", numeroInscricao=" + this.getNumeroInscricao() + ", pessoaId=" + this.getPessoaId() + ", pessoaNome=" + this.getPessoaNome() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", valorTotal=" + this.getValorTotal() + ", estornado=" + this.getEstornado() + ")";
    }
}

