/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.debitoautomatico;

import br.com.elotech.tributos.util.MultiValueFilter;
import java.util.Objects;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class RemessaDebitoAutomaticoFilterDTO {
    private Long convenio;
    private Long sequenciaArquivoEnvio;
    private Long formaPagamento;
    private String tipoCadastro;
    private String cadastroGeral;
    private String exercicio;
    private String divida;
    private String subDivida;
    private String dataAutorizacaoInicial;
    private String dataAutorizacaoFinal;
    private String dataVencimentoInicial;
    private String dataVencimentoFinal;

    private String addAND(String clausula) {
        return " AND " + clausula;
    }

    public String buildFiltro() {
        StringBuilder where = new StringBuilder();
        if (Objects.nonNull(this.convenio)) {
            where.append(this.addAND("tdao.convenio = :convenio"));
        }
        if (Objects.nonNull(this.formaPagamento)) {
            where.append(this.addAND("tdao.formaPagamento = :formaPagamento"));
        }
        if (Objects.nonNull(this.tipoCadastro) && !this.tipoCadastro.isEmpty()) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.tipoCadastro, (String)"tdao.tipoCadastro")));
        }
        if (Objects.nonNull(this.cadastroGeral) && !this.cadastroGeral.isEmpty()) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"tdao.cadastroGeral")));
        }
        if (Objects.nonNull(this.divida) && !this.divida.isEmpty()) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.divida, (String)"tdao.guiaRecolhimento")));
        }
        if (Objects.nonNull(this.subDivida) && !this.subDivida.isEmpty()) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.subDivida, (String)"tdao.subDivida")));
        }
        if (Objects.nonNull(this.dataVencimentoInicial)) {
            where.append(this.addAND("tdp.datavencimento >= :dataVencimentoInicial"));
        }
        if (Objects.nonNull(this.dataVencimentoFinal)) {
            where.append(this.addAND("tdp.datavencimento <= :dataVencimentoFinal"));
        }
        if (Objects.nonNull(this.dataAutorizacaoInicial)) {
            where.append(this.addAND("tdao.dataautorizacao >= :dataAutorizacaoInicial"));
        }
        if (Objects.nonNull(this.dataAutorizacaoFinal)) {
            where.append(this.addAND("tdao.dataautorizacao <= :dataAutorizacaoFinal"));
        }
        return where.toString();
    }

    public MapSqlParameterSource buildParameters() {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        if (Objects.nonNull(this.getConvenio())) {
            parameters.addValue("convenio", (Object)this.getConvenio(), 2);
        }
        if (Objects.nonNull(this.getFormaPagamento())) {
            parameters.addValue("formaPagamento", (Object)this.getFormaPagamento(), 2);
        }
        if (Objects.nonNull(this.getDataVencimentoInicial())) {
            parameters.addValue("dataVencimentoInicial", (Object)this.getDataVencimentoInicial(), 91);
        }
        if (Objects.nonNull(this.getDataVencimentoFinal())) {
            parameters.addValue("dataVencimentoFinal", (Object)this.getDataVencimentoFinal(), 91);
        }
        if (Objects.nonNull(this.getDataAutorizacaoInicial())) {
            parameters.addValue("dataAutorizacaoInicial", (Object)this.getDataAutorizacaoInicial(), 91);
        }
        if (Objects.nonNull(this.getDataAutorizacaoFinal())) {
            parameters.addValue("dataAutorizacaoFinal", (Object)this.getDataAutorizacaoFinal(), 91);
        }
        return parameters;
    }

    @Generated
    public RemessaDebitoAutomaticoFilterDTO() {
    }

    @Generated
    public Long getConvenio() {
        return this.convenio;
    }

    @Generated
    public Long getSequenciaArquivoEnvio() {
        return this.sequenciaArquivoEnvio;
    }

    @Generated
    public Long getFormaPagamento() {
        return this.formaPagamento;
    }

    @Generated
    public String getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public String getDataAutorizacaoInicial() {
        return this.dataAutorizacaoInicial;
    }

    @Generated
    public String getDataAutorizacaoFinal() {
        return this.dataAutorizacaoFinal;
    }

    @Generated
    public String getDataVencimentoInicial() {
        return this.dataVencimentoInicial;
    }

    @Generated
    public String getDataVencimentoFinal() {
        return this.dataVencimentoFinal;
    }

    @Generated
    public void setConvenio(Long convenio) {
        this.convenio = convenio;
    }

    @Generated
    public void setSequenciaArquivoEnvio(Long sequenciaArquivoEnvio) {
        this.sequenciaArquivoEnvio = sequenciaArquivoEnvio;
    }

    @Generated
    public void setFormaPagamento(Long formaPagamento) {
        this.formaPagamento = formaPagamento;
    }

    @Generated
    public void setTipoCadastro(String tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setExercicio(String exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setDataAutorizacaoInicial(String dataAutorizacaoInicial) {
        this.dataAutorizacaoInicial = dataAutorizacaoInicial;
    }

    @Generated
    public void setDataAutorizacaoFinal(String dataAutorizacaoFinal) {
        this.dataAutorizacaoFinal = dataAutorizacaoFinal;
    }

    @Generated
    public void setDataVencimentoInicial(String dataVencimentoInicial) {
        this.dataVencimentoInicial = dataVencimentoInicial;
    }

    @Generated
    public void setDataVencimentoFinal(String dataVencimentoFinal) {
        this.dataVencimentoFinal = dataVencimentoFinal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemessaDebitoAutomaticoFilterDTO)) {
            return false;
        }
        RemessaDebitoAutomaticoFilterDTO other = (RemessaDebitoAutomaticoFilterDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$convenio = this.getConvenio();
        Long other$convenio = other.getConvenio();
        if (this$convenio == null ? other$convenio != null : !((Object)this$convenio).equals(other$convenio)) {
            return false;
        }
        Long this$sequenciaArquivoEnvio = this.getSequenciaArquivoEnvio();
        Long other$sequenciaArquivoEnvio = other.getSequenciaArquivoEnvio();
        if (this$sequenciaArquivoEnvio == null ? other$sequenciaArquivoEnvio != null : !((Object)this$sequenciaArquivoEnvio).equals(other$sequenciaArquivoEnvio)) {
            return false;
        }
        Long this$formaPagamento = this.getFormaPagamento();
        Long other$formaPagamento = other.getFormaPagamento();
        if (this$formaPagamento == null ? other$formaPagamento != null : !((Object)this$formaPagamento).equals(other$formaPagamento)) {
            return false;
        }
        String this$tipoCadastro = this.getTipoCadastro();
        String other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$exercicio = this.getExercicio();
        String other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !this$exercicio.equals(other$exercicio)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        String this$dataAutorizacaoInicial = this.getDataAutorizacaoInicial();
        String other$dataAutorizacaoInicial = other.getDataAutorizacaoInicial();
        if (this$dataAutorizacaoInicial == null ? other$dataAutorizacaoInicial != null : !this$dataAutorizacaoInicial.equals(other$dataAutorizacaoInicial)) {
            return false;
        }
        String this$dataAutorizacaoFinal = this.getDataAutorizacaoFinal();
        String other$dataAutorizacaoFinal = other.getDataAutorizacaoFinal();
        if (this$dataAutorizacaoFinal == null ? other$dataAutorizacaoFinal != null : !this$dataAutorizacaoFinal.equals(other$dataAutorizacaoFinal)) {
            return false;
        }
        String this$dataVencimentoInicial = this.getDataVencimentoInicial();
        String other$dataVencimentoInicial = other.getDataVencimentoInicial();
        if (this$dataVencimentoInicial == null ? other$dataVencimentoInicial != null : !this$dataVencimentoInicial.equals(other$dataVencimentoInicial)) {
            return false;
        }
        String this$dataVencimentoFinal = this.getDataVencimentoFinal();
        String other$dataVencimentoFinal = other.getDataVencimentoFinal();
        return !(this$dataVencimentoFinal == null ? other$dataVencimentoFinal != null : !this$dataVencimentoFinal.equals(other$dataVencimentoFinal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemessaDebitoAutomaticoFilterDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $convenio = this.getConvenio();
        result = result * 59 + ($convenio == null ? 43 : ((Object)$convenio).hashCode());
        Long $sequenciaArquivoEnvio = this.getSequenciaArquivoEnvio();
        result = result * 59 + ($sequenciaArquivoEnvio == null ? 43 : ((Object)$sequenciaArquivoEnvio).hashCode());
        Long $formaPagamento = this.getFormaPagamento();
        result = result * 59 + ($formaPagamento == null ? 43 : ((Object)$formaPagamento).hashCode());
        String $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : $exercicio.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        String $dataAutorizacaoInicial = this.getDataAutorizacaoInicial();
        result = result * 59 + ($dataAutorizacaoInicial == null ? 43 : $dataAutorizacaoInicial.hashCode());
        String $dataAutorizacaoFinal = this.getDataAutorizacaoFinal();
        result = result * 59 + ($dataAutorizacaoFinal == null ? 43 : $dataAutorizacaoFinal.hashCode());
        String $dataVencimentoInicial = this.getDataVencimentoInicial();
        result = result * 59 + ($dataVencimentoInicial == null ? 43 : $dataVencimentoInicial.hashCode());
        String $dataVencimentoFinal = this.getDataVencimentoFinal();
        result = result * 59 + ($dataVencimentoFinal == null ? 43 : $dataVencimentoFinal.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RemessaDebitoAutomaticoFilterDTO(convenio=" + this.getConvenio() + ", sequenciaArquivoEnvio=" + this.getSequenciaArquivoEnvio() + ", formaPagamento=" + this.getFormaPagamento() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", exercicio=" + this.getExercicio() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", dataAutorizacaoInicial=" + this.getDataAutorizacaoInicial() + ", dataAutorizacaoFinal=" + this.getDataAutorizacaoFinal() + ", dataVencimentoInicial=" + this.getDataVencimentoInicial() + ", dataVencimentoFinal=" + this.getDataVencimentoFinal() + ")";
    }
}

