/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.contribuicaomelhoria;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.contribuicaomelhoria.MelhoriaEdital;
import br.com.elotech.tributos.domain.contribuicaomelhoria.MelhoriaImobiliario;
import br.com.elotech.tributos.domain.contribuicaomelhoria.id.MelhoriaEditalId;
import br.com.elotech.tributos.domain.contribuicaomelhoria.id.MelhoriaImobiliarioId;
import java.math.BigDecimal;
import lombok.Generated;

public class MelhoriaCadastroDTO {
    private Long entidade;
    private Long exercicio;
    private Long numeroEdital;
    private Long idCadastro;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private String nomeProprietario;
    private String inscricaoCadastral;
    private String enderecoCompleto;
    private BigDecimal valor;
    private BigDecimal valorizacao;
    private BigDecimal valorDebito;

    public static MelhoriaCadastroDTO from(MelhoriaImobiliario melhoriaImobiliario) {
        MelhoriaCadastroDTO dto = new MelhoriaCadastroDTO();
        dto.setIdCadastro(melhoriaImobiliario.getId().getCadastroGeral().getId());
        dto.setTipoCadastro(melhoriaImobiliario.getId().getCadastroGeral().getTipoCadastro().getValue());
        dto.setCadastroGeral(melhoriaImobiliario.getId().getCadastroGeral().getCadastroGeral());
        dto.setEntidade(melhoriaImobiliario.getId().getMelhoriaEdital().getId().getEntidade());
        dto.setExercicio(melhoriaImobiliario.getId().getMelhoriaEdital().getId().getExercicio());
        dto.setNumeroEdital(melhoriaImobiliario.getId().getMelhoriaEdital().getId().getNumeroEdital());
        dto.setValor(melhoriaImobiliario.getValor());
        dto.setValorizacao(melhoriaImobiliario.getValorizacao());
        dto.setValorDebito(melhoriaImobiliario.getValorDebito());
        dto.setNomeProprietario((String)melhoriaImobiliario.getId().getCadastroGeral().getProprietarioPrincipal().map(Proprietario::getPessoa).map(Pessoa::getNome).orElse(null));
        return dto;
    }

    public MelhoriaImobiliario toEntity() {
        MelhoriaEditalId melhoriaId = new MelhoriaEditalId();
        MelhoriaEdital melhoria = new MelhoriaEdital();
        CadastroGeral cadastroGeralObj = new CadastroGeral();
        MelhoriaImobiliarioId cadastroId = new MelhoriaImobiliarioId();
        MelhoriaImobiliario cadastro = new MelhoriaImobiliario();
        melhoriaId.setEntidade(this.entidade);
        melhoriaId.setExercicio(this.exercicio);
        melhoriaId.setNumeroEdital(this.numeroEdital);
        melhoria.setId(melhoriaId);
        cadastroGeralObj.setId(this.idCadastro);
        cadastroGeralObj.setTipoCadastro(TipoCadastro.fromValue((Long)this.tipoCadastro));
        cadastroGeralObj.setCadastroGeral(this.cadastroGeral);
        cadastroId.setMelhoriaEdital(melhoria);
        cadastroId.setCadastroGeral(cadastroGeralObj);
        cadastro.setId(cadastroId);
        cadastro.setValor(this.valor);
        cadastro.setValorizacao(this.valorizacao);
        cadastro.setValorDebito(this.valorDebito);
        return cadastro;
    }

    @Generated
    public MelhoriaCadastroDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getNumeroEdital() {
        return this.numeroEdital;
    }

    @Generated
    public Long getIdCadastro() {
        return this.idCadastro;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getNomeProprietario() {
        return this.nomeProprietario;
    }

    @Generated
    public String getInscricaoCadastral() {
        return this.inscricaoCadastral;
    }

    @Generated
    public String getEnderecoCompleto() {
        return this.enderecoCompleto;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorizacao() {
        return this.valorizacao;
    }

    @Generated
    public BigDecimal getValorDebito() {
        return this.valorDebito;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setNumeroEdital(Long numeroEdital) {
        this.numeroEdital = numeroEdital;
    }

    @Generated
    public void setIdCadastro(Long idCadastro) {
        this.idCadastro = idCadastro;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setNomeProprietario(String nomeProprietario) {
        this.nomeProprietario = nomeProprietario;
    }

    @Generated
    public void setInscricaoCadastral(String inscricaoCadastral) {
        this.inscricaoCadastral = inscricaoCadastral;
    }

    @Generated
    public void setEnderecoCompleto(String enderecoCompleto) {
        this.enderecoCompleto = enderecoCompleto;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorizacao(BigDecimal valorizacao) {
        this.valorizacao = valorizacao;
    }

    @Generated
    public void setValorDebito(BigDecimal valorDebito) {
        this.valorDebito = valorDebito;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MelhoriaCadastroDTO)) {
            return false;
        }
        MelhoriaCadastroDTO other = (MelhoriaCadastroDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$numeroEdital = this.getNumeroEdital();
        Long other$numeroEdital = other.getNumeroEdital();
        if (this$numeroEdital == null ? other$numeroEdital != null : !((Object)this$numeroEdital).equals(other$numeroEdital)) {
            return false;
        }
        Long this$idCadastro = this.getIdCadastro();
        Long other$idCadastro = other.getIdCadastro();
        if (this$idCadastro == null ? other$idCadastro != null : !((Object)this$idCadastro).equals(other$idCadastro)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        String this$nomeProprietario = this.getNomeProprietario();
        String other$nomeProprietario = other.getNomeProprietario();
        if (this$nomeProprietario == null ? other$nomeProprietario != null : !this$nomeProprietario.equals(other$nomeProprietario)) {
            return false;
        }
        String this$inscricaoCadastral = this.getInscricaoCadastral();
        String other$inscricaoCadastral = other.getInscricaoCadastral();
        if (this$inscricaoCadastral == null ? other$inscricaoCadastral != null : !this$inscricaoCadastral.equals(other$inscricaoCadastral)) {
            return false;
        }
        String this$enderecoCompleto = this.getEnderecoCompleto();
        String other$enderecoCompleto = other.getEnderecoCompleto();
        if (this$enderecoCompleto == null ? other$enderecoCompleto != null : !this$enderecoCompleto.equals(other$enderecoCompleto)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$valorizacao = this.getValorizacao();
        BigDecimal other$valorizacao = other.getValorizacao();
        if (this$valorizacao == null ? other$valorizacao != null : !((Object)this$valorizacao).equals(other$valorizacao)) {
            return false;
        }
        BigDecimal this$valorDebito = this.getValorDebito();
        BigDecimal other$valorDebito = other.getValorDebito();
        return !(this$valorDebito == null ? other$valorDebito != null : !((Object)this$valorDebito).equals(other$valorDebito));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MelhoriaCadastroDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $numeroEdital = this.getNumeroEdital();
        result = result * 59 + ($numeroEdital == null ? 43 : ((Object)$numeroEdital).hashCode());
        Long $idCadastro = this.getIdCadastro();
        result = result * 59 + ($idCadastro == null ? 43 : ((Object)$idCadastro).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        String $nomeProprietario = this.getNomeProprietario();
        result = result * 59 + ($nomeProprietario == null ? 43 : $nomeProprietario.hashCode());
        String $inscricaoCadastral = this.getInscricaoCadastral();
        result = result * 59 + ($inscricaoCadastral == null ? 43 : $inscricaoCadastral.hashCode());
        String $enderecoCompleto = this.getEnderecoCompleto();
        result = result * 59 + ($enderecoCompleto == null ? 43 : $enderecoCompleto.hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $valorizacao = this.getValorizacao();
        result = result * 59 + ($valorizacao == null ? 43 : ((Object)$valorizacao).hashCode());
        BigDecimal $valorDebito = this.getValorDebito();
        result = result * 59 + ($valorDebito == null ? 43 : ((Object)$valorDebito).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MelhoriaCadastroDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", numeroEdital=" + this.getNumeroEdital() + ", idCadastro=" + this.getIdCadastro() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", nomeProprietario=" + this.getNomeProprietario() + ", inscricaoCadastral=" + this.getInscricaoCadastral() + ", enderecoCompleto=" + this.getEnderecoCompleto() + ", valor=" + this.getValor() + ", valorizacao=" + this.getValorizacao() + ", valorDebito=" + this.getValorDebito() + ")";
    }
}

