/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.StatusPagamentoNegociado;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class FiltroSimulacaoPagamentoNegociadoDTO {
    @NotNull
    private BigDecimal valorNegociado;
    @NotNull
    private List<DebitoPagamentoNegociadoDTO> debitos;

    public void gerarRateioNegociacao() {
        BigDecimal valorRestanteNegociado = this.valorNegociado;
        for (DebitoPagamentoNegociadoDTO debito : this.debitos) {
            if (valorRestanteNegociado.compareTo(debito.getValorTotal()) >= 0) {
                valorRestanteNegociado = valorRestanteNegociado.subtract(debito.getValorTotal());
                debito.setValorAbatido(debito.getValorTotal());
                debito.setValorRestante(BigDecimal.ZERO);
                debito.setStatus(StatusPagamentoNegociado.TOTAL);
                continue;
            }
            if (valorRestanteNegociado.compareTo(debito.getValorTotal()) <= 0 && valorRestanteNegociado.compareTo(BigDecimal.ZERO) > 0) {
                debito.setValorAbatido(valorRestanteNegociado);
                BigDecimal valorRestante = debito.getValorTotal().subtract(valorRestanteNegociado).multiply(debito.getPercentualPrincipal()).setScale(2, RoundingMode.HALF_EVEN);
                debito.setValorRestante(valorRestante);
                valorRestanteNegociado = valorRestanteNegociado.subtract(debito.getValorTotal());
                debito.setStatus(StatusPagamentoNegociado.PARCIAL);
                continue;
            }
            debito.setValorAbatido(BigDecimal.ZERO);
            debito.setValorRestante(debito.getValorTotal());
            debito.setStatus(StatusPagamentoNegociado.IGNORADO);
        }
    }

    @Generated
    public FiltroSimulacaoPagamentoNegociadoDTO() {
    }

    @Generated
    public BigDecimal getValorNegociado() {
        return this.valorNegociado;
    }

    @Generated
    public List<DebitoPagamentoNegociadoDTO> getDebitos() {
        return this.debitos;
    }

    @Generated
    public void setValorNegociado(BigDecimal valorNegociado) {
        this.valorNegociado = valorNegociado;
    }

    @Generated
    public void setDebitos(List<DebitoPagamentoNegociadoDTO> debitos) {
        this.debitos = debitos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroSimulacaoPagamentoNegociadoDTO)) {
            return false;
        }
        FiltroSimulacaoPagamentoNegociadoDTO other = (FiltroSimulacaoPagamentoNegociadoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        BigDecimal this$valorNegociado = this.getValorNegociado();
        BigDecimal other$valorNegociado = other.getValorNegociado();
        if (this$valorNegociado == null ? other$valorNegociado != null : !((Object)this$valorNegociado).equals(other$valorNegociado)) {
            return false;
        }
        List this$debitos = this.getDebitos();
        List other$debitos = other.getDebitos();
        return !(this$debitos == null ? other$debitos != null : !((Object)this$debitos).equals(other$debitos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroSimulacaoPagamentoNegociadoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $valorNegociado = this.getValorNegociado();
        result = result * 59 + ($valorNegociado == null ? 43 : ((Object)$valorNegociado).hashCode());
        List $debitos = this.getDebitos();
        result = result * 59 + ($debitos == null ? 43 : ((Object)$debitos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroSimulacaoPagamentoNegociadoDTO(valorNegociado=" + this.getValorNegociado() + ", debitos=" + this.getDebitos() + ")";
    }
}

