/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import lombok.Generated;
import org.hibernate.search.query.facet.Facet;

public class FacetValorDTO {
    private String valorSelecionado;
    private Integer quantidade;
    private Boolean isRange = Boolean.FALSE;

    public FacetValorDTO(Facet facet, Boolean isRange) {
        this.valorSelecionado = facet.getValue();
        this.quantidade = facet.getCount();
        this.isRange = isRange;
    }

    public String getLabel() {
        if (Boolean.TRUE.equals(this.isRange)) {
            return this.converteValorSelecionadoToLabel();
        }
        if ("true".equalsIgnoreCase(this.valorSelecionado)) {
            return "Sim";
        }
        if ("false".equalsIgnoreCase(this.valorSelecionado)) {
            return "N\u00e3o";
        }
        return this.valorSelecionado;
    }

    private String converteValorSelecionadoToLabel() {
        String label = this.removeEspacoParentesesEColchetes(this.getValorSelecionado());
        String primeiroValor = label.substring(0, label.indexOf(44));
        String segundoValor = label.substring(label.indexOf(44) + 1);
        if (primeiroValor.isEmpty()) {
            return "Menor que " + segundoValor;
        }
        if (segundoValor.isEmpty()) {
            return "Maior que " + primeiroValor;
        }
        return label.replaceFirst(",", " - ");
    }

    private String removeEspacoParentesesEColchetes(String valor) {
        return valor.replaceAll("[\\[\\]() ]", "");
    }

    @Generated
    public String getValorSelecionado() {
        return this.valorSelecionado;
    }

    @Generated
    public Integer getQuantidade() {
        return this.quantidade;
    }

    @Generated
    public Boolean getIsRange() {
        return this.isRange;
    }

    @Generated
    public void setValorSelecionado(String valorSelecionado) {
        this.valorSelecionado = valorSelecionado;
    }

    @Generated
    public void setQuantidade(Integer quantidade) {
        this.quantidade = quantidade;
    }

    @Generated
    public void setIsRange(Boolean isRange) {
        this.isRange = isRange;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FacetValorDTO)) {
            return false;
        }
        FacetValorDTO other = (FacetValorDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$quantidade = this.getQuantidade();
        Integer other$quantidade = other.getQuantidade();
        if (this$quantidade == null ? other$quantidade != null : !((Object)this$quantidade).equals(other$quantidade)) {
            return false;
        }
        Boolean this$isRange = this.getIsRange();
        Boolean other$isRange = other.getIsRange();
        if (this$isRange == null ? other$isRange != null : !((Object)this$isRange).equals(other$isRange)) {
            return false;
        }
        String this$valorSelecionado = this.getValorSelecionado();
        String other$valorSelecionado = other.getValorSelecionado();
        return !(this$valorSelecionado == null ? other$valorSelecionado != null : !this$valorSelecionado.equals(other$valorSelecionado));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FacetValorDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $quantidade = this.getQuantidade();
        result = result * 59 + ($quantidade == null ? 43 : ((Object)$quantidade).hashCode());
        Boolean $isRange = this.getIsRange();
        result = result * 59 + ($isRange == null ? 43 : ((Object)$isRange).hashCode());
        String $valorSelecionado = this.getValorSelecionado();
        result = result * 59 + ($valorSelecionado == null ? 43 : $valorSelecionado.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FacetValorDTO(valorSelecionado=" + this.getValorSelecionado() + ", quantidade=" + this.getQuantidade() + ", isRange=" + this.getIsRange() + ")";
    }

    @Generated
    public FacetValorDTO() {
    }
}

