/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Carne;
import br.com.elotech.tributos.domain.CarneId;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.dto.DebitoAgrupadoPorFormaPagamentoDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class DebitoCarneDTO {
    private Long entidade;
    private Long exercicio;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long divida;
    private Long subDivida;
    private Long idDebito;
    private BigDecimal valorTotal;
    private String descricaoDivida;
    private Long codigoModeloBloquetoSemRegistro;
    private Boolean recalculo = Boolean.FALSE;
    List<DebitoAgrupadoPorFormaPagamentoDTO> formasPagamento = new ArrayList();

    public Carne toEntity() {
        CarneId id = new CarneId();
        id.setEntidade(this.getEntidade());
        id.setExercicio(this.getExercicio());
        Carne entity = new Carne();
        entity.setId(id);
        entity.setTipoCadastro(this.getTipoCadastro());
        entity.setCadastroGeral(this.getCadastroGeral());
        return entity;
    }

    public static DebitoCarneDTO from(Debito debito) {
        DebitoCarneDTO debitoCarneDTO = new DebitoCarneDTO();
        debitoCarneDTO.setEntidade(debito.getEntidade());
        debitoCarneDTO.setExercicio(debito.getExercicio());
        debitoCarneDTO.setTipoCadastro(debito.getTipoCadastro());
        debitoCarneDTO.setCadastroGeral(debito.getCadastroGeral().getCadastroGeral());
        debitoCarneDTO.setDivida(debito.getDivida().getDivida());
        debitoCarneDTO.setSubDivida(debito.getSubDivida());
        debitoCarneDTO.setIdDebito(debito.getId());
        debitoCarneDTO.setValorTotal(debito.getValorTotalDebito());
        debitoCarneDTO.setDescricaoDivida(debito.getDivida().getDescricao());
        return debitoCarneDTO;
    }

    public void addFormaPagamento(DebitoAgrupadoPorFormaPagamentoDTO debitoAgrupadoPorFormaPagamentoDTO) {
        this.formasPagamento.add(debitoAgrupadoPorFormaPagamentoDTO);
    }

    @Generated
    public DebitoCarneDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public String getDescricaoDivida() {
        return this.descricaoDivida;
    }

    @Generated
    public Long getCodigoModeloBloquetoSemRegistro() {
        return this.codigoModeloBloquetoSemRegistro;
    }

    @Generated
    public Boolean getRecalculo() {
        return this.recalculo;
    }

    @Generated
    public List<DebitoAgrupadoPorFormaPagamentoDTO> getFormasPagamento() {
        return this.formasPagamento;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setDescricaoDivida(String descricaoDivida) {
        this.descricaoDivida = descricaoDivida;
    }

    @Generated
    public void setCodigoModeloBloquetoSemRegistro(Long codigoModeloBloquetoSemRegistro) {
        this.codigoModeloBloquetoSemRegistro = codigoModeloBloquetoSemRegistro;
    }

    @Generated
    public void setRecalculo(Boolean recalculo) {
        this.recalculo = recalculo;
    }

    @Generated
    public void setFormasPagamento(List<DebitoAgrupadoPorFormaPagamentoDTO> formasPagamento) {
        this.formasPagamento = formasPagamento;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoCarneDTO)) {
            return false;
        }
        DebitoCarneDTO other = (DebitoCarneDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$divida = this.getDivida();
        Long other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !((Object)this$divida).equals(other$divida)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        Long this$codigoModeloBloquetoSemRegistro = this.getCodigoModeloBloquetoSemRegistro();
        Long other$codigoModeloBloquetoSemRegistro = other.getCodigoModeloBloquetoSemRegistro();
        if (this$codigoModeloBloquetoSemRegistro == null ? other$codigoModeloBloquetoSemRegistro != null : !((Object)this$codigoModeloBloquetoSemRegistro).equals(other$codigoModeloBloquetoSemRegistro)) {
            return false;
        }
        Boolean this$recalculo = this.getRecalculo();
        Boolean other$recalculo = other.getRecalculo();
        if (this$recalculo == null ? other$recalculo != null : !((Object)this$recalculo).equals(other$recalculo)) {
            return false;
        }
        BigDecimal this$valorTotal = this.getValorTotal();
        BigDecimal other$valorTotal = other.getValorTotal();
        if (this$valorTotal == null ? other$valorTotal != null : !((Object)this$valorTotal).equals(other$valorTotal)) {
            return false;
        }
        String this$descricaoDivida = this.getDescricaoDivida();
        String other$descricaoDivida = other.getDescricaoDivida();
        if (this$descricaoDivida == null ? other$descricaoDivida != null : !this$descricaoDivida.equals(other$descricaoDivida)) {
            return false;
        }
        List this$formasPagamento = this.getFormasPagamento();
        List other$formasPagamento = other.getFormasPagamento();
        return !(this$formasPagamento == null ? other$formasPagamento != null : !((Object)this$formasPagamento).equals(other$formasPagamento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoCarneDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : ((Object)$divida).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        Long $codigoModeloBloquetoSemRegistro = this.getCodigoModeloBloquetoSemRegistro();
        result = result * 59 + ($codigoModeloBloquetoSemRegistro == null ? 43 : ((Object)$codigoModeloBloquetoSemRegistro).hashCode());
        Boolean $recalculo = this.getRecalculo();
        result = result * 59 + ($recalculo == null ? 43 : ((Object)$recalculo).hashCode());
        BigDecimal $valorTotal = this.getValorTotal();
        result = result * 59 + ($valorTotal == null ? 43 : ((Object)$valorTotal).hashCode());
        String $descricaoDivida = this.getDescricaoDivida();
        result = result * 59 + ($descricaoDivida == null ? 43 : $descricaoDivida.hashCode());
        List $formasPagamento = this.getFormasPagamento();
        result = result * 59 + ($formasPagamento == null ? 43 : ((Object)$formasPagamento).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DebitoCarneDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", idDebito=" + this.getIdDebito() + ", valorTotal=" + this.getValorTotal() + ", descricaoDivida=" + this.getDescricaoDivida() + ", codigoModeloBloquetoSemRegistro=" + this.getCodigoModeloBloquetoSemRegistro() + ", recalculo=" + this.getRecalculo() + ", formasPagamento=" + this.getFormasPagamento() + ")";
    }
}

