/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.DebitoTributo;
import br.com.elotech.tributos.domain.DebitoTributoId;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebito;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoItem;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoItemPk;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.Assert;

public class CancelamentoDebitoTributoDTO {
    private Long id;
    private Long idDebito;
    private Long entidade;
    private Long exercicio;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long divida;
    private Long subDivida;
    private Long parcela;
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private SituacaoLegal situacaoLegal;
    private String tributo;
    private BigDecimal porcentagem;
    private BigDecimal valorCancelamento;
    private BigDecimal valorFinal;
    private Boolean estornado = Boolean.FALSE;
    private LocalDate dataEstorno;
    private String usuarioEstorno;
    private String programaEstorno;
    private Long exercicioProcesso;
    private Long idProcesso;
    private String observacao;
    private Long motivoEstorno;
    private String motivoEstornoDescricao;
    private Boolean selecionado = Boolean.FALSE;
    private List<Long> iddebitoparcelareceitas;

    public CancelamentoDebitoItem toEntity(CancelamentoDebito cancelamentoDebito, DebitoParcelaTributo debitoParcelaTributo) {
        CancelamentoDebitoItemPk pk = new CancelamentoDebitoItemPk();
        pk.setCancelamentoDebito(cancelamentoDebito);
        pk.setDebitoParcelaTributo(debitoParcelaTributo);
        CancelamentoDebitoItem item = new CancelamentoDebitoItem();
        item.setId(pk);
        item.setSituacaoLegal(this.getSituacaoLegal());
        item.setIdProcesso(cancelamentoDebito.getIdProcesso());
        item.setExercicioProcesso(cancelamentoDebito.getExercicioProcesso());
        item.setMotivoDesconto(cancelamentoDebito.getMotivoCancelamento());
        return item;
    }

    public static CancelamentoDebitoTributoDTO from(DebitoParcelaTributo debitoParcelaTributo) {
        Assert.notNull((Object)debitoParcelaTributo, (String)"Erro ao fazer conver\u00e7\u00e3o de dados: entity null");
        Assert.notNull((Object)debitoParcelaTributo.getDebitoParcela(), (String)"Erro ao fazer conver\u00e7\u00e3o de dados: entity sem d\u00e9bito parcela");
        Assert.notNull((Object)debitoParcelaTributo.getDebitoParcela().getId(), (String)"Erro ao fazer conver\u00e7\u00e3o de dados: d\u00e9bito parcela da entity null");
        Assert.notNull((Object)debitoParcelaTributo.getDebitoParcela().getDebito(), (String)"Erro ao fazer conver\u00e7\u00e3o de dados: d\u00e9bito da entity d\u00e9bito parcela null");
        CancelamentoDebitoTributoDTO dto = new CancelamentoDebitoTributoDTO();
        dto.setId(debitoParcelaTributo.getId());
        dto.setIdDebito(debitoParcelaTributo.getDebitoParcela().getDebito().getId());
        dto.setEntidade(debitoParcelaTributo.getDebitoParcela().getId().getEntidade());
        dto.setExercicio(debitoParcelaTributo.getDebitoParcela().getId().getExercicio());
        dto.setTipoCadastro(debitoParcelaTributo.getDebitoParcela().getId().getTipoCadastro());
        dto.setCadastroGeral(debitoParcelaTributo.getDebitoParcela().getId().getCadastroGeral());
        dto.setDivida(debitoParcelaTributo.getDebitoParcela().getId().getDivida());
        dto.setSubDivida(debitoParcelaTributo.getDebitoParcela().getId().getSubDivida());
        dto.setParcela(debitoParcelaTributo.getDebitoParcela().getId().getParcela());
        dto.setValor(debitoParcelaTributo.getValor());
        dto.setSituacaoLegal(debitoParcelaTributo.getDebitoParcela().getSituacaoLegal());
        dto.setTributo(debitoParcelaTributo.getTributo());
        dto.setPorcentagem(new BigDecimal("100"));
        dto.setValorCancelamento(debitoParcelaTributo.getValor());
        dto.setValorFinal(new BigDecimal("0"));
        return dto;
    }

    public DebitoTributo toEntityDebitoTributo() {
        DebitoTributoId debitoTributoId = new DebitoTributoId();
        debitoTributoId.setEntidade(this.getEntidade());
        debitoTributoId.setExercicio(this.getExercicio());
        debitoTributoId.setTipoCadastro(this.getTipoCadastro());
        debitoTributoId.setCadastroGeral(this.getCadastroGeral());
        debitoTributoId.setDivida(this.getDivida());
        debitoTributoId.setSubDivida(this.getSubDivida());
        debitoTributoId.setTributo(this.getTributo());
        DebitoTributo debitoTributo = new DebitoTributo();
        debitoTributo.setId(debitoTributoId);
        debitoTributo.setValorRenuncia(this.valorCancelamento);
        debitoTributo.setValorTributo(this.valorFinal);
        return debitoTributo;
    }

    public static CancelamentoDebitoTributoDTO from(CancelamentoDebitoItem cancelamentoDebitoItem) {
        Assert.notNull((Object)cancelamentoDebitoItem, (String)"Erro ao fazer a convers\u00e3o de dados: Itens do cancelamento est\u00e1 nulo");
        Assert.notNull((Object)cancelamentoDebitoItem.getId(), (String)"Erro ao fazer a convers\u00e3o de dados: Entidade PK no item est\u00e1 nula");
        Assert.notNull((Object)cancelamentoDebitoItem.getId().getCancelamentoDebito(), (String)"Erro ao fazer a convers\u00e3o de dados: Entidade do cancelamento no item est\u00e1 nulo");
        Assert.notNull((Object)cancelamentoDebitoItem.getId().getCancelamentoDebito().getId(), (String)"Erro ao fazer a convers\u00e3o de dados: Entidade PK da Entidade do cancelamento est\u00e1 nulo");
        Assert.notNull((Object)cancelamentoDebitoItem.getId().getDebitoParcelaTributo(), (String)"Erro ao fazer a convers\u00e3o de dados: Dados do d\u00e9bito est\u00e3o nulos no item do cancelamento");
        CancelamentoDebitoTributoDTO dto = new CancelamentoDebitoTributoDTO();
        dto.setEntidade(cancelamentoDebitoItem.getId().getCancelamentoDebito().getId().getEntidade());
        dto.setExercicio(cancelamentoDebitoItem.getId().getDebitoParcelaTributo().getExercicio());
        dto.setIdDebito(cancelamentoDebitoItem.getId().getDebitoParcelaTributo().getIdDebito());
        dto.setTipoCadastro(cancelamentoDebitoItem.getId().getDebitoParcelaTributo().getTipoCadastro());
        dto.setCadastroGeral(cancelamentoDebitoItem.getId().getDebitoParcelaTributo().getCadastroGeral());
        dto.setDivida(cancelamentoDebitoItem.getId().getDebitoParcelaTributo().getDivida());
        dto.setSubDivida(cancelamentoDebitoItem.getId().getDebitoParcelaTributo().getSubDivida());
        dto.setParcela(cancelamentoDebitoItem.getId().getDebitoParcelaTributo().getParcela());
        dto.setValor(cancelamentoDebitoItem.getValor());
        dto.setValorJuros(cancelamentoDebitoItem.getValorJuros());
        dto.setValorMulta(cancelamentoDebitoItem.getValorMulta());
        dto.setValorCorrecao(cancelamentoDebitoItem.getValorCorrecao());
        dto.setSituacaoLegal(cancelamentoDebitoItem.getSituacaoLegal());
        dto.setTributo(cancelamentoDebitoItem.getId().getDebitoParcelaTributo().getTributo());
        dto.setEstornado(cancelamentoDebitoItem.getEstornado());
        dto.setDataEstorno(cancelamentoDebitoItem.getDataEstorno());
        dto.setUsuarioEstorno(cancelamentoDebitoItem.getUsuarioEstorno());
        dto.setProgramaEstorno(cancelamentoDebitoItem.getProgramaEstorno());
        dto.setExercicioProcesso(cancelamentoDebitoItem.getExercicioProcesso());
        dto.setIdProcesso(cancelamentoDebitoItem.getIdProcesso());
        dto.setObservacao(cancelamentoDebitoItem.getObservacao());
        dto.setMotivoEstorno(Objects.nonNull(cancelamentoDebitoItem.getMotivoDesconto()) ? cancelamentoDebitoItem.getMotivoDesconto().getId() : null);
        dto.setMotivoEstornoDescricao(Objects.nonNull(cancelamentoDebitoItem.getMotivoDesconto()) ? cancelamentoDebitoItem.getMotivoDesconto().getDescricao() : null);
        return dto;
    }

    @JsonIgnore
    public static Map<DebitoIdDTO, List<CancelamentoDebitoTributoDTO>> getItensCanceladosByDebitos(List<CancelamentoDebitoTributoDTO> parcelas) {
        return parcelas.stream().collect(Collectors.groupingBy(cancelamentoDebitoTributoDTO -> DebitoIdDTO.of((Long)cancelamentoDebitoTributoDTO.getIdDebito(), (Long)cancelamentoDebitoTributoDTO.getEntidade(), (Long)cancelamentoDebitoTributoDTO.getExercicio(), (Long)cancelamentoDebitoTributoDTO.getTipoCadastro(), (Long)cancelamentoDebitoTributoDTO.getCadastroGeral(), (Long)cancelamentoDebitoTributoDTO.getDivida(), (Long)cancelamentoDebitoTributoDTO.getSubDivida()), Collectors.toList()));
    }

    public Boolean equalsCancelamentoDebitoItem(CancelamentoDebitoItem item) {
        DebitoParcelaTributo debitoParcelaTributo = item.getId().getDebitoParcelaTributo();
        return debitoParcelaTributo.getEntidade().equals(this.entidade) && debitoParcelaTributo.getExercicio().equals(this.exercicio) && debitoParcelaTributo.getTipoCadastro().equals(this.tipoCadastro) && debitoParcelaTributo.getCadastroGeral().equals(this.cadastroGeral) && debitoParcelaTributo.getDivida().equals(this.divida) && debitoParcelaTributo.getSubDivida().equals(this.subDivida) && debitoParcelaTributo.getParcela().equals(this.parcela) && debitoParcelaTributo.getTributo().equals(this.tributo);
    }

    public Boolean isSelected() {
        return this.selecionado;
    }

    @Generated
    public CancelamentoDebitoTributoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Long getParcela() {
        return this.parcela;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public SituacaoLegal getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public String getTributo() {
        return this.tributo;
    }

    @Generated
    public BigDecimal getPorcentagem() {
        return this.porcentagem;
    }

    @Generated
    public BigDecimal getValorCancelamento() {
        return this.valorCancelamento;
    }

    @Generated
    public BigDecimal getValorFinal() {
        return this.valorFinal;
    }

    @Generated
    public Boolean getEstornado() {
        return this.estornado;
    }

    @Generated
    public LocalDate getDataEstorno() {
        return this.dataEstorno;
    }

    @Generated
    public String getUsuarioEstorno() {
        return this.usuarioEstorno;
    }

    @Generated
    public String getProgramaEstorno() {
        return this.programaEstorno;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public Long getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public Long getMotivoEstorno() {
        return this.motivoEstorno;
    }

    @Generated
    public String getMotivoEstornoDescricao() {
        return this.motivoEstornoDescricao;
    }

    @Generated
    public Boolean getSelecionado() {
        return this.selecionado;
    }

    @Generated
    public List<Long> getIddebitoparcelareceitas() {
        return this.iddebitoparcelareceitas;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setSituacaoLegal(SituacaoLegal situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setTributo(String tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setPorcentagem(BigDecimal porcentagem) {
        this.porcentagem = porcentagem;
    }

    @Generated
    public void setValorCancelamento(BigDecimal valorCancelamento) {
        this.valorCancelamento = valorCancelamento;
    }

    @Generated
    public void setValorFinal(BigDecimal valorFinal) {
        this.valorFinal = valorFinal;
    }

    @Generated
    public void setEstornado(Boolean estornado) {
        this.estornado = estornado;
    }

    @Generated
    public void setDataEstorno(LocalDate dataEstorno) {
        this.dataEstorno = dataEstorno;
    }

    @Generated
    public void setUsuarioEstorno(String usuarioEstorno) {
        this.usuarioEstorno = usuarioEstorno;
    }

    @Generated
    public void setProgramaEstorno(String programaEstorno) {
        this.programaEstorno = programaEstorno;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setIdProcesso(Long idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setMotivoEstorno(Long motivoEstorno) {
        this.motivoEstorno = motivoEstorno;
    }

    @Generated
    public void setMotivoEstornoDescricao(String motivoEstornoDescricao) {
        this.motivoEstornoDescricao = motivoEstornoDescricao;
    }

    @Generated
    public void setSelecionado(Boolean selecionado) {
        this.selecionado = selecionado;
    }

    @Generated
    public void setIddebitoparcelareceitas(List<Long> iddebitoparcelareceitas) {
        this.iddebitoparcelareceitas = iddebitoparcelareceitas;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CancelamentoDebitoTributoDTO)) {
            return false;
        }
        CancelamentoDebitoTributoDTO other = (CancelamentoDebitoTributoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$divida = this.getDivida();
        Long other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !((Object)this$divida).equals(other$divida)) {
            return false;
        }
        Long this$subDivida = this.getSubDivida();
        Long other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !((Object)this$subDivida).equals(other$subDivida)) {
            return false;
        }
        Long this$parcela = this.getParcela();
        Long other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !((Object)this$parcela).equals(other$parcela)) {
            return false;
        }
        Boolean this$estornado = this.getEstornado();
        Boolean other$estornado = other.getEstornado();
        if (this$estornado == null ? other$estornado != null : !((Object)this$estornado).equals(other$estornado)) {
            return false;
        }
        Long this$exercicioProcesso = this.getExercicioProcesso();
        Long other$exercicioProcesso = other.getExercicioProcesso();
        if (this$exercicioProcesso == null ? other$exercicioProcesso != null : !((Object)this$exercicioProcesso).equals(other$exercicioProcesso)) {
            return false;
        }
        Long this$idProcesso = this.getIdProcesso();
        Long other$idProcesso = other.getIdProcesso();
        if (this$idProcesso == null ? other$idProcesso != null : !((Object)this$idProcesso).equals(other$idProcesso)) {
            return false;
        }
        Long this$motivoEstorno = this.getMotivoEstorno();
        Long other$motivoEstorno = other.getMotivoEstorno();
        if (this$motivoEstorno == null ? other$motivoEstorno != null : !((Object)this$motivoEstorno).equals(other$motivoEstorno)) {
            return false;
        }
        Boolean this$selecionado = this.getSelecionado();
        Boolean other$selecionado = other.getSelecionado();
        if (this$selecionado == null ? other$selecionado != null : !((Object)this$selecionado).equals(other$selecionado)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$valorJuros = this.getValorJuros();
        BigDecimal other$valorJuros = other.getValorJuros();
        if (this$valorJuros == null ? other$valorJuros != null : !((Object)this$valorJuros).equals(other$valorJuros)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta)) {
            return false;
        }
        BigDecimal this$valorCorrecao = this.getValorCorrecao();
        BigDecimal other$valorCorrecao = other.getValorCorrecao();
        if (this$valorCorrecao == null ? other$valorCorrecao != null : !((Object)this$valorCorrecao).equals(other$valorCorrecao)) {
            return false;
        }
        SituacaoLegal this$situacaoLegal = this.getSituacaoLegal();
        SituacaoLegal other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !this$situacaoLegal.equals(other$situacaoLegal)) {
            return false;
        }
        String this$tributo = this.getTributo();
        String other$tributo = other.getTributo();
        if (this$tributo == null ? other$tributo != null : !this$tributo.equals(other$tributo)) {
            return false;
        }
        BigDecimal this$porcentagem = this.getPorcentagem();
        BigDecimal other$porcentagem = other.getPorcentagem();
        if (this$porcentagem == null ? other$porcentagem != null : !((Object)this$porcentagem).equals(other$porcentagem)) {
            return false;
        }
        BigDecimal this$valorCancelamento = this.getValorCancelamento();
        BigDecimal other$valorCancelamento = other.getValorCancelamento();
        if (this$valorCancelamento == null ? other$valorCancelamento != null : !((Object)this$valorCancelamento).equals(other$valorCancelamento)) {
            return false;
        }
        BigDecimal this$valorFinal = this.getValorFinal();
        BigDecimal other$valorFinal = other.getValorFinal();
        if (this$valorFinal == null ? other$valorFinal != null : !((Object)this$valorFinal).equals(other$valorFinal)) {
            return false;
        }
        LocalDate this$dataEstorno = this.getDataEstorno();
        LocalDate other$dataEstorno = other.getDataEstorno();
        if (this$dataEstorno == null ? other$dataEstorno != null : !((Object)this$dataEstorno).equals(other$dataEstorno)) {
            return false;
        }
        String this$usuarioEstorno = this.getUsuarioEstorno();
        String other$usuarioEstorno = other.getUsuarioEstorno();
        if (this$usuarioEstorno == null ? other$usuarioEstorno != null : !this$usuarioEstorno.equals(other$usuarioEstorno)) {
            return false;
        }
        String this$programaEstorno = this.getProgramaEstorno();
        String other$programaEstorno = other.getProgramaEstorno();
        if (this$programaEstorno == null ? other$programaEstorno != null : !this$programaEstorno.equals(other$programaEstorno)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        String this$motivoEstornoDescricao = this.getMotivoEstornoDescricao();
        String other$motivoEstornoDescricao = other.getMotivoEstornoDescricao();
        if (this$motivoEstornoDescricao == null ? other$motivoEstornoDescricao != null : !this$motivoEstornoDescricao.equals(other$motivoEstornoDescricao)) {
            return false;
        }
        List this$iddebitoparcelareceitas = this.getIddebitoparcelareceitas();
        List other$iddebitoparcelareceitas = other.getIddebitoparcelareceitas();
        return !(this$iddebitoparcelareceitas == null ? other$iddebitoparcelareceitas != null : !((Object)this$iddebitoparcelareceitas).equals(other$iddebitoparcelareceitas));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CancelamentoDebitoTributoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : ((Object)$divida).hashCode());
        Long $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : ((Object)$subDivida).hashCode());
        Long $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : ((Object)$parcela).hashCode());
        Boolean $estornado = this.getEstornado();
        result = result * 59 + ($estornado == null ? 43 : ((Object)$estornado).hashCode());
        Long $exercicioProcesso = this.getExercicioProcesso();
        result = result * 59 + ($exercicioProcesso == null ? 43 : ((Object)$exercicioProcesso).hashCode());
        Long $idProcesso = this.getIdProcesso();
        result = result * 59 + ($idProcesso == null ? 43 : ((Object)$idProcesso).hashCode());
        Long $motivoEstorno = this.getMotivoEstorno();
        result = result * 59 + ($motivoEstorno == null ? 43 : ((Object)$motivoEstorno).hashCode());
        Boolean $selecionado = this.getSelecionado();
        result = result * 59 + ($selecionado == null ? 43 : ((Object)$selecionado).hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $valorJuros = this.getValorJuros();
        result = result * 59 + ($valorJuros == null ? 43 : ((Object)$valorJuros).hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        BigDecimal $valorCorrecao = this.getValorCorrecao();
        result = result * 59 + ($valorCorrecao == null ? 43 : ((Object)$valorCorrecao).hashCode());
        SituacaoLegal $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : $situacaoLegal.hashCode());
        String $tributo = this.getTributo();
        result = result * 59 + ($tributo == null ? 43 : $tributo.hashCode());
        BigDecimal $porcentagem = this.getPorcentagem();
        result = result * 59 + ($porcentagem == null ? 43 : ((Object)$porcentagem).hashCode());
        BigDecimal $valorCancelamento = this.getValorCancelamento();
        result = result * 59 + ($valorCancelamento == null ? 43 : ((Object)$valorCancelamento).hashCode());
        BigDecimal $valorFinal = this.getValorFinal();
        result = result * 59 + ($valorFinal == null ? 43 : ((Object)$valorFinal).hashCode());
        LocalDate $dataEstorno = this.getDataEstorno();
        result = result * 59 + ($dataEstorno == null ? 43 : ((Object)$dataEstorno).hashCode());
        String $usuarioEstorno = this.getUsuarioEstorno();
        result = result * 59 + ($usuarioEstorno == null ? 43 : $usuarioEstorno.hashCode());
        String $programaEstorno = this.getProgramaEstorno();
        result = result * 59 + ($programaEstorno == null ? 43 : $programaEstorno.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        String $motivoEstornoDescricao = this.getMotivoEstornoDescricao();
        result = result * 59 + ($motivoEstornoDescricao == null ? 43 : $motivoEstornoDescricao.hashCode());
        List $iddebitoparcelareceitas = this.getIddebitoparcelareceitas();
        result = result * 59 + ($iddebitoparcelareceitas == null ? 43 : ((Object)$iddebitoparcelareceitas).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CancelamentoDebitoTributoDTO(id=" + this.getId() + ", idDebito=" + this.getIdDebito() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", parcela=" + this.getParcela() + ", valor=" + this.getValor() + ", valorJuros=" + this.getValorJuros() + ", valorMulta=" + this.getValorMulta() + ", valorCorrecao=" + this.getValorCorrecao() + ", situacaoLegal=" + this.getSituacaoLegal() + ", tributo=" + this.getTributo() + ", porcentagem=" + this.getPorcentagem() + ", valorCancelamento=" + this.getValorCancelamento() + ", valorFinal=" + this.getValorFinal() + ", estornado=" + this.getEstornado() + ", dataEstorno=" + this.getDataEstorno() + ", usuarioEstorno=" + this.getUsuarioEstorno() + ", programaEstorno=" + this.getProgramaEstorno() + ", exercicioProcesso=" + this.getExercicioProcesso() + ", idProcesso=" + this.getIdProcesso() + ", observacao=" + this.getObservacao() + ", motivoEstorno=" + this.getMotivoEstorno() + ", motivoEstornoDescricao=" + this.getMotivoEstornoDescricao() + ", selecionado=" + this.getSelecionado() + ", iddebitoparcelareceitas=" + this.getIddebitoparcelareceitas() + ")";
    }
}

