/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.caelum.stella.tinytype.CEP;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaAvulso;
import br.com.elotech.tributos.dto.BairroDTO;
import br.com.elotech.tributos.dto.LogradouroDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.ObservacaoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.ProprietarioDTO;
import br.com.elotech.tributos.dto.camposdinamicos.GrupoRespostasDTO;
import br.com.elotech.tributos.dto.sanepar.SaneparMatriculaDTO;
import br.com.elotech.tributos.util.UsuarioUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class CadastroAvulsoDTO {
    private Long id;
    private Long codigo;
    private Pessoa proprietarioPrincipal;
    private String cnpjCpf;
    private LogradouroDTO logradouro;
    private String numero;
    private String complemento;
    private Cidade cidade;
    private String uf;
    private String cep;
    private BairroDTO bairro;
    private String usuario;
    private LocalDate dataInclusao;
    private LocalDate dataAlteracao;
    private Boolean visivelNfse = Boolean.FALSE;
    private Boolean orgaoPublico = Boolean.FALSE;
    private Boolean substituicaoTributaria = Boolean.FALSE;
    private Boolean descontoCondicionado = Boolean.FALSE;
    private List<ProprietarioDTO> responsaveis = new ArrayList();
    private List<ObservacaoDTO> observacoes = new ArrayList();
    private List<GrupoRespostasDTO> respostasAvulso = new ArrayList();
    private List<SaneparMatriculaDTO> convenioSaneparMatriculas = new ArrayList();
    private Long cadastroGeralAnterior;

    public CadastroGeral toEntity() {
        CadastroGeral cadastroGeral = new CadastroGeral();
        if (Objects.nonNull(this.id)) {
            cadastroGeral.setId(this.id);
        }
        cadastroGeral.setTipoCadastro(TipoCadastro.AVULSO);
        cadastroGeral.setCadastroGeral(this.codigo);
        if (Objects.nonNull(this.logradouro)) {
            cadastroGeral.setLogradouro(this.logradouro.toEntity());
        }
        cadastroGeral.setNumero(this.numero);
        cadastroGeral.setComplemento(this.complemento);
        cadastroGeral.setCep((Long)Optional.ofNullable(this.cep).map(v -> v.replaceAll("[^\\d]", "")).map(Long::valueOf).orElse(null));
        if (Objects.nonNull(this.bairro)) {
            cadastroGeral.setBairro(this.bairro.toEntity());
        }
        if (Objects.nonNull(this.cidade)) {
            cadastroGeral.setCidade(this.cidade);
        }
        cadastroGeral.setOrgaoPublico(this.orgaoPublico);
        cadastroGeral.setVisivelNfse(this.visivelNfse);
        cadastroGeral.setSubstituicaoTributariaCadastroGeral(this.substituicaoTributaria);
        cadastroGeral.setDescontoCondicionado(this.descontoCondicionado);
        cadastroGeral.setUsuario(UsuarioUtils.getUsuarioAise());
        cadastroGeral.setPessoa(this.proprietarioPrincipal);
        cadastroGeral.getProprietarios().addAll(this.responsaveis.stream().map(ProprietarioDTO::toEntity).collect(Collectors.toList()));
        cadastroGeral.getObservacoes().addAll(this.observacoes.stream().map(observacaoDTO -> observacaoDTO.toEntity(cadastroGeral)).collect(Collectors.toList()));
        this.respostasAvulso.forEach(grupoRespostasDTO -> grupoRespostasDTO.getRespostasPreenchidas().forEach(resposta -> cadastroGeral.addRespostaAvulso((RespostaAvulso)resposta.copyTo((Resposta)new RespostaAvulso()))));
        cadastroGeral.getSaneparMatriculas().addAll(this.convenioSaneparMatriculas.stream().map(saneparMatricula -> saneparMatricula.toEntity(cadastroGeral)).collect(Collectors.toList()));
        cadastroGeral.setCadastroGeralAnterior(this.cadastroGeralAnterior);
        return cadastroGeral;
    }

    public static CadastroAvulsoDTO from(CadastroGeral cadastroGeral) {
        CadastroAvulsoDTO cadastroAvulsoDTO = new CadastroAvulsoDTO();
        cadastroAvulsoDTO.setId(cadastroGeral.getId());
        cadastroAvulsoDTO.setCodigo(cadastroGeral.getCadastroGeral());
        cadastroAvulsoDTO.setProprietarioPrincipal(cadastroGeral.getPessoa());
        cadastroAvulsoDTO.setCnpjCpf(cadastroGeral.getPessoa().getCnpjCpf());
        cadastroAvulsoDTO.setOrgaoPublico(cadastroGeral.getOrgaoPublico());
        cadastroAvulsoDTO.setVisivelNfse(cadastroGeral.getVisivelNfse());
        cadastroAvulsoDTO.setDescontoCondicionado(cadastroGeral.getDescontoCondicionado());
        cadastroAvulsoDTO.setSubstituicaoTributaria(cadastroGeral.getSubstituicaoTributariaCadastroGeral());
        if (Objects.nonNull(cadastroGeral.getLogradouro())) {
            cadastroAvulsoDTO.setLogradouro(LogradouroDTO.from((Logradouro)cadastroGeral.getLogradouro()));
        }
        cadastroAvulsoDTO.setNumero(cadastroGeral.getNumero());
        cadastroAvulsoDTO.setComplemento(cadastroGeral.getComplemento());
        cadastroAvulsoDTO.setCidade(cadastroGeral.getCidade());
        cadastroAvulsoDTO.setCep((String)Optional.ofNullable(cadastroGeral.getCep()).map(String::valueOf).map(v -> new CEP(v).getNumeroFormatado()).orElse(null));
        if (Objects.nonNull(cadastroGeral.getCidade())) {
            cadastroAvulsoDTO.setUf(cadastroGeral.getCidade().getUnidadeFederacao());
        }
        if (Objects.nonNull(cadastroGeral.getBairro())) {
            cadastroAvulsoDTO.setBairro(BairroDTO.from((Bairro)cadastroGeral.getBairro()));
        }
        cadastroAvulsoDTO.setUsuario(cadastroGeral.getUsuario());
        cadastroAvulsoDTO.setDataInclusao(cadastroGeral.getDataInclusao());
        cadastroAvulsoDTO.setDataAlteracao(cadastroGeral.getDataAlteracao());
        cadastroAvulsoDTO.getResponsaveis().addAll(cadastroGeral.getProprietarios().stream().filter(proprietario -> Boolean.FALSE.equals(proprietario.getPrincipal())).map(ProprietarioDTO::from).collect(Collectors.toList()));
        cadastroAvulsoDTO.getObservacoes().addAll(cadastroGeral.getObservacoes().stream().map(ObservacaoDTO::from).sorted(Comparator.comparing(ObservacaoDTO::getSequencia).reversed()).collect(Collectors.toList()));
        cadastroAvulsoDTO.setConvenioSaneparMatriculas(cadastroGeral.getSaneparMatriculas().stream().map(SaneparMatriculaDTO::from).collect(Collectors.toList()));
        cadastroAvulsoDTO.setCadastroGeralAnterior(cadastroGeral.getCadastroGeralAnterior());
        return cadastroAvulsoDTO;
    }

    public static CadastroAvulsoDTO fromComRespostaAgrupada(CadastroGeral entity) {
        CadastroAvulsoDTO dto = CadastroAvulsoDTO.from((CadastroGeral)entity);
        List respostasTerrenoAgrupadas = GrupoRespostasDTO.agruparRespostasPorGrupoCampo((List)entity.getRespostasAvulso());
        dto.setRespostasAvulso(respostasTerrenoAgrupadas);
        return dto;
    }

    @Generated
    public CadastroAvulsoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getCodigo() {
        return this.codigo;
    }

    @Generated
    public Pessoa getProprietarioPrincipal() {
        return this.proprietarioPrincipal;
    }

    @Generated
    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    @Generated
    public LogradouroDTO getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public Cidade getCidade() {
        return this.cidade;
    }

    @Generated
    public String getUf() {
        return this.uf;
    }

    @Generated
    public String getCep() {
        return this.cep;
    }

    @Generated
    public BairroDTO getBairro() {
        return this.bairro;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    @Generated
    public Boolean getVisivelNfse() {
        return this.visivelNfse;
    }

    @Generated
    public Boolean getOrgaoPublico() {
        return this.orgaoPublico;
    }

    @Generated
    public Boolean getSubstituicaoTributaria() {
        return this.substituicaoTributaria;
    }

    @Generated
    public Boolean getDescontoCondicionado() {
        return this.descontoCondicionado;
    }

    @Generated
    public List<ProprietarioDTO> getResponsaveis() {
        return this.responsaveis;
    }

    @Generated
    public List<ObservacaoDTO> getObservacoes() {
        return this.observacoes;
    }

    @Generated
    public List<GrupoRespostasDTO> getRespostasAvulso() {
        return this.respostasAvulso;
    }

    @Generated
    public List<SaneparMatriculaDTO> getConvenioSaneparMatriculas() {
        return this.convenioSaneparMatriculas;
    }

    @Generated
    public Long getCadastroGeralAnterior() {
        return this.cadastroGeralAnterior;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setProprietarioPrincipal(Pessoa proprietarioPrincipal) {
        this.proprietarioPrincipal = proprietarioPrincipal;
    }

    @Generated
    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    @Generated
    public void setLogradouro(LogradouroDTO logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setUf(String uf) {
        this.uf = uf;
    }

    @Generated
    public void setCep(String cep) {
        this.cep = cep;
    }

    @Generated
    public void setBairro(BairroDTO bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @Generated
    public void setVisivelNfse(Boolean visivelNfse) {
        this.visivelNfse = visivelNfse;
    }

    @Generated
    public void setOrgaoPublico(Boolean orgaoPublico) {
        this.orgaoPublico = orgaoPublico;
    }

    @Generated
    public void setSubstituicaoTributaria(Boolean substituicaoTributaria) {
        this.substituicaoTributaria = substituicaoTributaria;
    }

    @Generated
    public void setDescontoCondicionado(Boolean descontoCondicionado) {
        this.descontoCondicionado = descontoCondicionado;
    }

    @Generated
    public void setResponsaveis(List<ProprietarioDTO> responsaveis) {
        this.responsaveis = responsaveis;
    }

    @Generated
    public void setObservacoes(List<ObservacaoDTO> observacoes) {
        this.observacoes = observacoes;
    }

    @Generated
    public void setRespostasAvulso(List<GrupoRespostasDTO> respostasAvulso) {
        this.respostasAvulso = respostasAvulso;
    }

    @Generated
    public void setConvenioSaneparMatriculas(List<SaneparMatriculaDTO> convenioSaneparMatriculas) {
        this.convenioSaneparMatriculas = convenioSaneparMatriculas;
    }

    @Generated
    public void setCadastroGeralAnterior(Long cadastroGeralAnterior) {
        this.cadastroGeralAnterior = cadastroGeralAnterior;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroAvulsoDTO)) {
            return false;
        }
        CadastroAvulsoDTO other = (CadastroAvulsoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo)) {
            return false;
        }
        Boolean this$visivelNfse = this.getVisivelNfse();
        Boolean other$visivelNfse = other.getVisivelNfse();
        if (this$visivelNfse == null ? other$visivelNfse != null : !((Object)this$visivelNfse).equals(other$visivelNfse)) {
            return false;
        }
        Boolean this$orgaoPublico = this.getOrgaoPublico();
        Boolean other$orgaoPublico = other.getOrgaoPublico();
        if (this$orgaoPublico == null ? other$orgaoPublico != null : !((Object)this$orgaoPublico).equals(other$orgaoPublico)) {
            return false;
        }
        Boolean this$substituicaoTributaria = this.getSubstituicaoTributaria();
        Boolean other$substituicaoTributaria = other.getSubstituicaoTributaria();
        if (this$substituicaoTributaria == null ? other$substituicaoTributaria != null : !((Object)this$substituicaoTributaria).equals(other$substituicaoTributaria)) {
            return false;
        }
        Boolean this$descontoCondicionado = this.getDescontoCondicionado();
        Boolean other$descontoCondicionado = other.getDescontoCondicionado();
        if (this$descontoCondicionado == null ? other$descontoCondicionado != null : !((Object)this$descontoCondicionado).equals(other$descontoCondicionado)) {
            return false;
        }
        Long this$cadastroGeralAnterior = this.getCadastroGeralAnterior();
        Long other$cadastroGeralAnterior = other.getCadastroGeralAnterior();
        if (this$cadastroGeralAnterior == null ? other$cadastroGeralAnterior != null : !((Object)this$cadastroGeralAnterior).equals(other$cadastroGeralAnterior)) {
            return false;
        }
        Pessoa this$proprietarioPrincipal = this.getProprietarioPrincipal();
        Pessoa other$proprietarioPrincipal = other.getProprietarioPrincipal();
        if (this$proprietarioPrincipal == null ? other$proprietarioPrincipal != null : !this$proprietarioPrincipal.equals(other$proprietarioPrincipal)) {
            return false;
        }
        String this$cnpjCpf = this.getCnpjCpf();
        String other$cnpjCpf = other.getCnpjCpf();
        if (this$cnpjCpf == null ? other$cnpjCpf != null : !this$cnpjCpf.equals(other$cnpjCpf)) {
            return false;
        }
        LogradouroDTO this$logradouro = this.getLogradouro();
        LogradouroDTO other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        if (this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento)) {
            return false;
        }
        Cidade this$cidade = this.getCidade();
        Cidade other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !this$cidade.equals(other$cidade)) {
            return false;
        }
        String this$uf = this.getUf();
        String other$uf = other.getUf();
        if (this$uf == null ? other$uf != null : !this$uf.equals(other$uf)) {
            return false;
        }
        String this$cep = this.getCep();
        String other$cep = other.getCep();
        if (this$cep == null ? other$cep != null : !this$cep.equals(other$cep)) {
            return false;
        }
        BairroDTO this$bairro = this.getBairro();
        BairroDTO other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        LocalDate this$dataInclusao = this.getDataInclusao();
        LocalDate other$dataInclusao = other.getDataInclusao();
        if (this$dataInclusao == null ? other$dataInclusao != null : !((Object)this$dataInclusao).equals(other$dataInclusao)) {
            return false;
        }
        LocalDate this$dataAlteracao = this.getDataAlteracao();
        LocalDate other$dataAlteracao = other.getDataAlteracao();
        if (this$dataAlteracao == null ? other$dataAlteracao != null : !((Object)this$dataAlteracao).equals(other$dataAlteracao)) {
            return false;
        }
        List this$responsaveis = this.getResponsaveis();
        List other$responsaveis = other.getResponsaveis();
        if (this$responsaveis == null ? other$responsaveis != null : !((Object)this$responsaveis).equals(other$responsaveis)) {
            return false;
        }
        List this$observacoes = this.getObservacoes();
        List other$observacoes = other.getObservacoes();
        if (this$observacoes == null ? other$observacoes != null : !((Object)this$observacoes).equals(other$observacoes)) {
            return false;
        }
        List this$respostasAvulso = this.getRespostasAvulso();
        List other$respostasAvulso = other.getRespostasAvulso();
        if (this$respostasAvulso == null ? other$respostasAvulso != null : !((Object)this$respostasAvulso).equals(other$respostasAvulso)) {
            return false;
        }
        List this$convenioSaneparMatriculas = this.getConvenioSaneparMatriculas();
        List other$convenioSaneparMatriculas = other.getConvenioSaneparMatriculas();
        return !(this$convenioSaneparMatriculas == null ? other$convenioSaneparMatriculas != null : !((Object)this$convenioSaneparMatriculas).equals(other$convenioSaneparMatriculas));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroAvulsoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        Boolean $visivelNfse = this.getVisivelNfse();
        result = result * 59 + ($visivelNfse == null ? 43 : ((Object)$visivelNfse).hashCode());
        Boolean $orgaoPublico = this.getOrgaoPublico();
        result = result * 59 + ($orgaoPublico == null ? 43 : ((Object)$orgaoPublico).hashCode());
        Boolean $substituicaoTributaria = this.getSubstituicaoTributaria();
        result = result * 59 + ($substituicaoTributaria == null ? 43 : ((Object)$substituicaoTributaria).hashCode());
        Boolean $descontoCondicionado = this.getDescontoCondicionado();
        result = result * 59 + ($descontoCondicionado == null ? 43 : ((Object)$descontoCondicionado).hashCode());
        Long $cadastroGeralAnterior = this.getCadastroGeralAnterior();
        result = result * 59 + ($cadastroGeralAnterior == null ? 43 : ((Object)$cadastroGeralAnterior).hashCode());
        Pessoa $proprietarioPrincipal = this.getProprietarioPrincipal();
        result = result * 59 + ($proprietarioPrincipal == null ? 43 : $proprietarioPrincipal.hashCode());
        String $cnpjCpf = this.getCnpjCpf();
        result = result * 59 + ($cnpjCpf == null ? 43 : $cnpjCpf.hashCode());
        LogradouroDTO $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        Cidade $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : $cidade.hashCode());
        String $uf = this.getUf();
        result = result * 59 + ($uf == null ? 43 : $uf.hashCode());
        String $cep = this.getCep();
        result = result * 59 + ($cep == null ? 43 : $cep.hashCode());
        BairroDTO $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        LocalDate $dataInclusao = this.getDataInclusao();
        result = result * 59 + ($dataInclusao == null ? 43 : ((Object)$dataInclusao).hashCode());
        LocalDate $dataAlteracao = this.getDataAlteracao();
        result = result * 59 + ($dataAlteracao == null ? 43 : ((Object)$dataAlteracao).hashCode());
        List $responsaveis = this.getResponsaveis();
        result = result * 59 + ($responsaveis == null ? 43 : ((Object)$responsaveis).hashCode());
        List $observacoes = this.getObservacoes();
        result = result * 59 + ($observacoes == null ? 43 : ((Object)$observacoes).hashCode());
        List $respostasAvulso = this.getRespostasAvulso();
        result = result * 59 + ($respostasAvulso == null ? 43 : ((Object)$respostasAvulso).hashCode());
        List $convenioSaneparMatriculas = this.getConvenioSaneparMatriculas();
        result = result * 59 + ($convenioSaneparMatriculas == null ? 43 : ((Object)$convenioSaneparMatriculas).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CadastroAvulsoDTO(id=" + this.getId() + ", codigo=" + this.getCodigo() + ", proprietarioPrincipal=" + this.getProprietarioPrincipal() + ", cnpjCpf=" + this.getCnpjCpf() + ", logradouro=" + this.getLogradouro() + ", numero=" + this.getNumero() + ", complemento=" + this.getComplemento() + ", cidade=" + this.getCidade() + ", uf=" + this.getUf() + ", cep=" + this.getCep() + ", bairro=" + this.getBairro() + ", usuario=" + this.getUsuario() + ", dataInclusao=" + this.getDataInclusao() + ", dataAlteracao=" + this.getDataAlteracao() + ", visivelNfse=" + this.getVisivelNfse() + ", orgaoPublico=" + this.getOrgaoPublico() + ", substituicaoTributaria=" + this.getSubstituicaoTributaria() + ", descontoCondicionado=" + this.getDescontoCondicionado() + ", responsaveis=" + this.getResponsaveis() + ", observacoes=" + this.getObservacoes() + ", respostasAvulso=" + this.getRespostasAvulso() + ", convenioSaneparMatriculas=" + this.getConvenioSaneparMatriculas() + ", cadastroGeralAnterior=" + this.getCadastroGeralAnterior() + ")";
    }
}

