/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.TipoBloqueto;
import java.time.LocalDate;
import java.util.Objects;
import lombok.Generated;

public class BoletoResumoDTO {
    private Long id;
    private Long entidade;
    private Long exercicioBoleto;
    private Long boleto;
    private TipoBloqueto tipoBoleto;
    private OrigemEmissao origemEmissao;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long idPessoa;
    private String nome;
    private String codigoBarras;
    private String codigoBarrasExterno;
    private String nossoNumero;
    private LocalDate dataEmissao;
    private LocalDate dataVencimento;
    private LocalDate dataLimitePagamento;
    private Boolean pago = Boolean.FALSE;
    private Boolean boletoGeradoBaixaAutomatica = Boolean.FALSE;
    private String linhaDigitavel;
    private String observacao;
    private Long motivoDeducaoId;
    private String motivoDeducaoDescricao;
    private String usuario;

    public static BoletoResumoDTO from(Bloqueto bloqueto) {
        BoletoResumoDTO dto = new BoletoResumoDTO();
        dto.setId(bloqueto.getId());
        dto.setEntidade(bloqueto.getEntidade());
        dto.setExercicioBoleto(bloqueto.getExercicioBloqueto());
        dto.setBoleto(bloqueto.getBloqueto());
        dto.setTipoBoleto(bloqueto.getTipoBloqueto());
        dto.setOrigemEmissao(bloqueto.getOrigemEmissao());
        dto.setBoletoGeradoBaixaAutomatica(bloqueto.getBloquetoGeradoBaixaAutomatica());
        if (Objects.nonNull(bloqueto.getCadastroGeral())) {
            dto.setTipoCadastro(bloqueto.getCadastroGeral().getTipoCadastro().getValue());
            dto.setCadastroGeral(bloqueto.getCadastroGeral().getCadastroGeral());
        }
        if (Objects.nonNull(bloqueto.getPessoa())) {
            dto.setIdPessoa(bloqueto.getPessoa().getId());
            dto.setNome(bloqueto.getPessoa().getNome());
        }
        dto.setCodigoBarras(bloqueto.getCodigoBarras());
        dto.setCodigoBarrasExterno(bloqueto.getCodigoBarrasExterno());
        dto.setNossoNumero(bloqueto.getNossoNumero());
        dto.setDataEmissao(bloqueto.getDataEmissao());
        dto.setDataVencimento(bloqueto.getDataVencimento());
        dto.setDataLimitePagamento(bloqueto.getDataLimitePagamento());
        dto.setPago(bloqueto.getPago());
        dto.setLinhaDigitavel(bloqueto.getLinhaDigitavel());
        dto.setObservacao(bloqueto.getObservacao());
        dto.setUsuario(bloqueto.getUsuario());
        if (Objects.nonNull(bloqueto.getMotivoDeducao())) {
            dto.setMotivoDeducaoId(bloqueto.getMotivoDeducao().getId());
            dto.setMotivoDeducaoDescricao(bloqueto.getMotivoDeducao().getDescricao());
        }
        return dto;
    }

    public Boolean getVencido() {
        if (Objects.isNull(this.dataVencimento)) {
            return Boolean.TRUE;
        }
        return LocalDate.now().isAfter(this.dataVencimento);
    }

    @Generated
    public BoletoResumoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicioBoleto() {
        return this.exercicioBoleto;
    }

    @Generated
    public Long getBoleto() {
        return this.boleto;
    }

    @Generated
    public TipoBloqueto getTipoBoleto() {
        return this.tipoBoleto;
    }

    @Generated
    public OrigemEmissao getOrigemEmissao() {
        return this.origemEmissao;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getIdPessoa() {
        return this.idPessoa;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    @Generated
    public String getCodigoBarrasExterno() {
        return this.codigoBarrasExterno;
    }

    @Generated
    public String getNossoNumero() {
        return this.nossoNumero;
    }

    @Generated
    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public LocalDate getDataLimitePagamento() {
        return this.dataLimitePagamento;
    }

    @Generated
    public Boolean getPago() {
        return this.pago;
    }

    @Generated
    public Boolean getBoletoGeradoBaixaAutomatica() {
        return this.boletoGeradoBaixaAutomatica;
    }

    @Generated
    public String getLinhaDigitavel() {
        return this.linhaDigitavel;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public Long getMotivoDeducaoId() {
        return this.motivoDeducaoId;
    }

    @Generated
    public String getMotivoDeducaoDescricao() {
        return this.motivoDeducaoDescricao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicioBoleto(Long exercicioBoleto) {
        this.exercicioBoleto = exercicioBoleto;
    }

    @Generated
    public void setBoleto(Long boleto) {
        this.boleto = boleto;
    }

    @Generated
    public void setTipoBoleto(TipoBloqueto tipoBoleto) {
        this.tipoBoleto = tipoBoleto;
    }

    @Generated
    public void setOrigemEmissao(OrigemEmissao origemEmissao) {
        this.origemEmissao = origemEmissao;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setIdPessoa(Long idPessoa) {
        this.idPessoa = idPessoa;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @Generated
    public void setCodigoBarrasExterno(String codigoBarrasExterno) {
        this.codigoBarrasExterno = codigoBarrasExterno;
    }

    @Generated
    public void setNossoNumero(String nossoNumero) {
        this.nossoNumero = nossoNumero;
    }

    @Generated
    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setDataLimitePagamento(LocalDate dataLimitePagamento) {
        this.dataLimitePagamento = dataLimitePagamento;
    }

    @Generated
    public void setPago(Boolean pago) {
        this.pago = pago;
    }

    @Generated
    public void setBoletoGeradoBaixaAutomatica(Boolean boletoGeradoBaixaAutomatica) {
        this.boletoGeradoBaixaAutomatica = boletoGeradoBaixaAutomatica;
    }

    @Generated
    public void setLinhaDigitavel(String linhaDigitavel) {
        this.linhaDigitavel = linhaDigitavel;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setMotivoDeducaoId(Long motivoDeducaoId) {
        this.motivoDeducaoId = motivoDeducaoId;
    }

    @Generated
    public void setMotivoDeducaoDescricao(String motivoDeducaoDescricao) {
        this.motivoDeducaoDescricao = motivoDeducaoDescricao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoletoResumoDTO)) {
            return false;
        }
        BoletoResumoDTO other = (BoletoResumoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicioBoleto = this.getExercicioBoleto();
        Long other$exercicioBoleto = other.getExercicioBoleto();
        if (this$exercicioBoleto == null ? other$exercicioBoleto != null : !((Object)this$exercicioBoleto).equals(other$exercicioBoleto)) {
            return false;
        }
        Long this$boleto = this.getBoleto();
        Long other$boleto = other.getBoleto();
        if (this$boleto == null ? other$boleto != null : !((Object)this$boleto).equals(other$boleto)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$idPessoa = this.getIdPessoa();
        Long other$idPessoa = other.getIdPessoa();
        if (this$idPessoa == null ? other$idPessoa != null : !((Object)this$idPessoa).equals(other$idPessoa)) {
            return false;
        }
        Boolean this$pago = this.getPago();
        Boolean other$pago = other.getPago();
        if (this$pago == null ? other$pago != null : !((Object)this$pago).equals(other$pago)) {
            return false;
        }
        Boolean this$boletoGeradoBaixaAutomatica = this.getBoletoGeradoBaixaAutomatica();
        Boolean other$boletoGeradoBaixaAutomatica = other.getBoletoGeradoBaixaAutomatica();
        if (this$boletoGeradoBaixaAutomatica == null ? other$boletoGeradoBaixaAutomatica != null : !((Object)this$boletoGeradoBaixaAutomatica).equals(other$boletoGeradoBaixaAutomatica)) {
            return false;
        }
        Long this$motivoDeducaoId = this.getMotivoDeducaoId();
        Long other$motivoDeducaoId = other.getMotivoDeducaoId();
        if (this$motivoDeducaoId == null ? other$motivoDeducaoId != null : !((Object)this$motivoDeducaoId).equals(other$motivoDeducaoId)) {
            return false;
        }
        TipoBloqueto this$tipoBoleto = this.getTipoBoleto();
        TipoBloqueto other$tipoBoleto = other.getTipoBoleto();
        if (this$tipoBoleto == null ? other$tipoBoleto != null : !this$tipoBoleto.equals(other$tipoBoleto)) {
            return false;
        }
        OrigemEmissao this$origemEmissao = this.getOrigemEmissao();
        OrigemEmissao other$origemEmissao = other.getOrigemEmissao();
        if (this$origemEmissao == null ? other$origemEmissao != null : !this$origemEmissao.equals(other$origemEmissao)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$codigoBarras = this.getCodigoBarras();
        String other$codigoBarras = other.getCodigoBarras();
        if (this$codigoBarras == null ? other$codigoBarras != null : !this$codigoBarras.equals(other$codigoBarras)) {
            return false;
        }
        String this$codigoBarrasExterno = this.getCodigoBarrasExterno();
        String other$codigoBarrasExterno = other.getCodigoBarrasExterno();
        if (this$codigoBarrasExterno == null ? other$codigoBarrasExterno != null : !this$codigoBarrasExterno.equals(other$codigoBarrasExterno)) {
            return false;
        }
        String this$nossoNumero = this.getNossoNumero();
        String other$nossoNumero = other.getNossoNumero();
        if (this$nossoNumero == null ? other$nossoNumero != null : !this$nossoNumero.equals(other$nossoNumero)) {
            return false;
        }
        LocalDate this$dataEmissao = this.getDataEmissao();
        LocalDate other$dataEmissao = other.getDataEmissao();
        if (this$dataEmissao == null ? other$dataEmissao != null : !((Object)this$dataEmissao).equals(other$dataEmissao)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        LocalDate this$dataLimitePagamento = this.getDataLimitePagamento();
        LocalDate other$dataLimitePagamento = other.getDataLimitePagamento();
        if (this$dataLimitePagamento == null ? other$dataLimitePagamento != null : !((Object)this$dataLimitePagamento).equals(other$dataLimitePagamento)) {
            return false;
        }
        String this$linhaDigitavel = this.getLinhaDigitavel();
        String other$linhaDigitavel = other.getLinhaDigitavel();
        if (this$linhaDigitavel == null ? other$linhaDigitavel != null : !this$linhaDigitavel.equals(other$linhaDigitavel)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        String this$motivoDeducaoDescricao = this.getMotivoDeducaoDescricao();
        String other$motivoDeducaoDescricao = other.getMotivoDeducaoDescricao();
        if (this$motivoDeducaoDescricao == null ? other$motivoDeducaoDescricao != null : !this$motivoDeducaoDescricao.equals(other$motivoDeducaoDescricao)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        return !(this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BoletoResumoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicioBoleto = this.getExercicioBoleto();
        result = result * 59 + ($exercicioBoleto == null ? 43 : ((Object)$exercicioBoleto).hashCode());
        Long $boleto = this.getBoleto();
        result = result * 59 + ($boleto == null ? 43 : ((Object)$boleto).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $idPessoa = this.getIdPessoa();
        result = result * 59 + ($idPessoa == null ? 43 : ((Object)$idPessoa).hashCode());
        Boolean $pago = this.getPago();
        result = result * 59 + ($pago == null ? 43 : ((Object)$pago).hashCode());
        Boolean $boletoGeradoBaixaAutomatica = this.getBoletoGeradoBaixaAutomatica();
        result = result * 59 + ($boletoGeradoBaixaAutomatica == null ? 43 : ((Object)$boletoGeradoBaixaAutomatica).hashCode());
        Long $motivoDeducaoId = this.getMotivoDeducaoId();
        result = result * 59 + ($motivoDeducaoId == null ? 43 : ((Object)$motivoDeducaoId).hashCode());
        TipoBloqueto $tipoBoleto = this.getTipoBoleto();
        result = result * 59 + ($tipoBoleto == null ? 43 : $tipoBoleto.hashCode());
        OrigemEmissao $origemEmissao = this.getOrigemEmissao();
        result = result * 59 + ($origemEmissao == null ? 43 : $origemEmissao.hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $codigoBarras = this.getCodigoBarras();
        result = result * 59 + ($codigoBarras == null ? 43 : $codigoBarras.hashCode());
        String $codigoBarrasExterno = this.getCodigoBarrasExterno();
        result = result * 59 + ($codigoBarrasExterno == null ? 43 : $codigoBarrasExterno.hashCode());
        String $nossoNumero = this.getNossoNumero();
        result = result * 59 + ($nossoNumero == null ? 43 : $nossoNumero.hashCode());
        LocalDate $dataEmissao = this.getDataEmissao();
        result = result * 59 + ($dataEmissao == null ? 43 : ((Object)$dataEmissao).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        LocalDate $dataLimitePagamento = this.getDataLimitePagamento();
        result = result * 59 + ($dataLimitePagamento == null ? 43 : ((Object)$dataLimitePagamento).hashCode());
        String $linhaDigitavel = this.getLinhaDigitavel();
        result = result * 59 + ($linhaDigitavel == null ? 43 : $linhaDigitavel.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        String $motivoDeducaoDescricao = this.getMotivoDeducaoDescricao();
        result = result * 59 + ($motivoDeducaoDescricao == null ? 43 : $motivoDeducaoDescricao.hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BoletoResumoDTO(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicioBoleto=" + this.getExercicioBoleto() + ", boleto=" + this.getBoleto() + ", tipoBoleto=" + this.getTipoBoleto() + ", origemEmissao=" + this.getOrigemEmissao() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", idPessoa=" + this.getIdPessoa() + ", nome=" + this.getNome() + ", codigoBarras=" + this.getCodigoBarras() + ", codigoBarrasExterno=" + this.getCodigoBarrasExterno() + ", nossoNumero=" + this.getNossoNumero() + ", dataEmissao=" + this.getDataEmissao() + ", dataVencimento=" + this.getDataVencimento() + ", dataLimitePagamento=" + this.getDataLimitePagamento() + ", pago=" + this.getPago() + ", boletoGeradoBaixaAutomatica=" + this.getBoletoGeradoBaixaAutomatica() + ", linhaDigitavel=" + this.getLinhaDigitavel() + ", observacao=" + this.getObservacao() + ", motivoDeducaoId=" + this.getMotivoDeducaoId() + ", motivoDeducaoDescricao=" + this.getMotivoDeducaoDescricao() + ", usuario=" + this.getUsuario() + ")";
    }
}

