/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.solicitacaoaprovacao;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.dto.solicitacaoaprovacao.SolicitacaoAprovacaoDTO;
import br.com.elotech.tributos.enums.SituacaoSolicitacaoAprovacaoEnum;
import br.com.elotech.tributos.enums.TipoAprovacaoEnum;
import br.com.elotech.tributos.security.SecurityUtils;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="tribsolicitacaoaprovacao")
public class SolicitacaoAprovacao
implements EloEntity<Long> {
    @Id
    @Column(name="id")
    @EloSequence(sequenceName="seq_solicitacao_aprovacao")
    private Long id;
    private String usuarioCriacao;
    private LocalDateTime dataCriacao;
    private String usuarioAprovacao;
    private LocalDateTime dataAprovacao;
    private String observacao;
    private String motivo;
    @Enumerated(value=EnumType.STRING)
    private SituacaoSolicitacaoAprovacaoEnum situacao;
    @Enumerated(value=EnumType.STRING)
    private TipoAprovacaoEnum tipoAprovacao;
    private String dados;
    private String identificador;

    public static SolicitacaoAprovacao from(SolicitacaoAprovacaoDTO dto) {
        SolicitacaoAprovacao solicitacaoAprovacao = new SolicitacaoAprovacao();
        solicitacaoAprovacao.setId(dto.getId());
        solicitacaoAprovacao.setUsuarioCriacao(SecurityUtils.getUserAise());
        solicitacaoAprovacao.setDataCriacao(LocalDateTime.now());
        solicitacaoAprovacao.setObservacao(dto.getObservacao());
        solicitacaoAprovacao.setSituacao(SituacaoSolicitacaoAprovacaoEnum.PENDENTE);
        solicitacaoAprovacao.setTipoAprovacao(TipoAprovacaoEnum.valueOf((String)dto.getTipoAprovacao()));
        solicitacaoAprovacao.setDados(dto.getDados());
        solicitacaoAprovacao.setIdentificador(dto.getIdentificador());
        return solicitacaoAprovacao;
    }

    @Generated
    public SolicitacaoAprovacao() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getUsuarioCriacao() {
        return this.usuarioCriacao;
    }

    @Generated
    public LocalDateTime getDataCriacao() {
        return this.dataCriacao;
    }

    @Generated
    public String getUsuarioAprovacao() {
        return this.usuarioAprovacao;
    }

    @Generated
    public LocalDateTime getDataAprovacao() {
        return this.dataAprovacao;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getMotivo() {
        return this.motivo;
    }

    @Generated
    public SituacaoSolicitacaoAprovacaoEnum getSituacao() {
        return this.situacao;
    }

    @Generated
    public TipoAprovacaoEnum getTipoAprovacao() {
        return this.tipoAprovacao;
    }

    @Generated
    public String getDados() {
        return this.dados;
    }

    @Generated
    public String getIdentificador() {
        return this.identificador;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setUsuarioCriacao(String usuarioCriacao) {
        this.usuarioCriacao = usuarioCriacao;
    }

    @Generated
    public void setDataCriacao(LocalDateTime dataCriacao) {
        this.dataCriacao = dataCriacao;
    }

    @Generated
    public void setUsuarioAprovacao(String usuarioAprovacao) {
        this.usuarioAprovacao = usuarioAprovacao;
    }

    @Generated
    public void setDataAprovacao(LocalDateTime dataAprovacao) {
        this.dataAprovacao = dataAprovacao;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @Generated
    public void setSituacao(SituacaoSolicitacaoAprovacaoEnum situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setTipoAprovacao(TipoAprovacaoEnum tipoAprovacao) {
        this.tipoAprovacao = tipoAprovacao;
    }

    @Generated
    public void setDados(String dados) {
        this.dados = dados;
    }

    @Generated
    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolicitacaoAprovacao)) {
            return false;
        }
        SolicitacaoAprovacao other = (SolicitacaoAprovacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SolicitacaoAprovacao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SolicitacaoAprovacao(id=" + this.getId() + ")";
    }
}

