/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.simam.validacoes;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.simam.validacoes.ErrosImportacaoSIMAM;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.ArrecadacaoCreditoValidacao;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.EstornoArrecadacaoCreditoValidacao;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.EstornoInscricaoDividaAtivaValidacao;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.InscricaoDividaAtivaValidacao;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import java.time.LocalDate;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="triberrosimportacaosimam")
public class ErrosImportacaoSIMAM
implements EloEntity<Long> {
    @Id
    @EloSequence(applyOnMerge=true, sequenceName="s_triberrosimportacaosimam_id")
    private Long id;
    @Enumerated(value=EnumType.STRING)
    private TipoRegistroSimAm identificadorArquivo;
    private Long idRegistro;
    private Long codigoErro;
    private LocalDate dataValidacao;
    private String mensagemErro;

    public static ErrosImportacaoSIMAM from(Long idRegistro, String mensagemErro, Long codigoErro, TipoRegistroSimAm tipoRegistroSimAm) {
        ErrosImportacaoSIMAM errosImportacaoSIMAM = new ErrosImportacaoSIMAM();
        errosImportacaoSIMAM.setIdentificadorArquivo(tipoRegistroSimAm);
        errosImportacaoSIMAM.setIdRegistro(idRegistro);
        errosImportacaoSIMAM.setCodigoErro(codigoErro);
        errosImportacaoSIMAM.setDataValidacao(LocalDate.now());
        errosImportacaoSIMAM.setMensagemErro(mensagemErro);
        return errosImportacaoSIMAM;
    }

    public static ErrosImportacaoSIMAM inscricaoDividaAtiva(InscricaoDividaAtivaValidacao inscricao, String message, Long codigoErro) {
        return ErrosImportacaoSIMAM.from((Long)inscricao.getIdTceInscCreditoDa(), (String)message, (Long)codigoErro, (TipoRegistroSimAm)TipoRegistroSimAm.INSCRICAO_CREDITO_DIVIDA_ATIVA);
    }

    public static ErrosImportacaoSIMAM estornoInscricaoDividaAtiva(EstornoInscricaoDividaAtivaValidacao inscricao, String message, Long codigoErro) {
        return ErrosImportacaoSIMAM.from((Long)inscricao.getIdTceInscCreditoDaEst(), (String)message, (Long)codigoErro, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_INSCRICAO_CREDITO_DIVIDA_ATIVA);
    }

    public static ErrosImportacaoSIMAM arrecadacao(ArrecadacaoCreditoValidacao arrecadacao, String message, Long codigoErro) {
        return ErrosImportacaoSIMAM.from((Long)arrecadacao.getIdTceArrTipoCredito(), (String)message, (Long)codigoErro, (TipoRegistroSimAm)TipoRegistroSimAm.ARRECADACAO_TIPO_CREDITO);
    }

    public static ErrosImportacaoSIMAM estornoArrecadacao(EstornoArrecadacaoCreditoValidacao arrecadacao, String message, Long codigoErro) {
        return ErrosImportacaoSIMAM.from((Long)arrecadacao.getIdTceArrTipoCreditoEst(), (String)message, (Long)codigoErro, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_ARRECADACAO_TIPO_CREDITO);
    }

    @Generated
    public static ErrosImportacaoSIMAMBuilder builder() {
        return new ErrosImportacaoSIMAMBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public TipoRegistroSimAm getIdentificadorArquivo() {
        return this.identificadorArquivo;
    }

    @Generated
    public Long getIdRegistro() {
        return this.idRegistro;
    }

    @Generated
    public Long getCodigoErro() {
        return this.codigoErro;
    }

    @Generated
    public LocalDate getDataValidacao() {
        return this.dataValidacao;
    }

    @Generated
    public String getMensagemErro() {
        return this.mensagemErro;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setIdentificadorArquivo(TipoRegistroSimAm identificadorArquivo) {
        this.identificadorArquivo = identificadorArquivo;
    }

    @Generated
    public void setIdRegistro(Long idRegistro) {
        this.idRegistro = idRegistro;
    }

    @Generated
    public void setCodigoErro(Long codigoErro) {
        this.codigoErro = codigoErro;
    }

    @Generated
    public void setDataValidacao(LocalDate dataValidacao) {
        this.dataValidacao = dataValidacao;
    }

    @Generated
    public void setMensagemErro(String mensagemErro) {
        this.mensagemErro = mensagemErro;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrosImportacaoSIMAM)) {
            return false;
        }
        ErrosImportacaoSIMAM other = (ErrosImportacaoSIMAM)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$idRegistro = this.getIdRegistro();
        Long other$idRegistro = other.getIdRegistro();
        if (this$idRegistro == null ? other$idRegistro != null : !((Object)this$idRegistro).equals(other$idRegistro)) {
            return false;
        }
        Long this$codigoErro = this.getCodigoErro();
        Long other$codigoErro = other.getCodigoErro();
        if (this$codigoErro == null ? other$codigoErro != null : !((Object)this$codigoErro).equals(other$codigoErro)) {
            return false;
        }
        TipoRegistroSimAm this$identificadorArquivo = this.getIdentificadorArquivo();
        TipoRegistroSimAm other$identificadorArquivo = other.getIdentificadorArquivo();
        if (this$identificadorArquivo == null ? other$identificadorArquivo != null : !this$identificadorArquivo.equals(other$identificadorArquivo)) {
            return false;
        }
        LocalDate this$dataValidacao = this.getDataValidacao();
        LocalDate other$dataValidacao = other.getDataValidacao();
        if (this$dataValidacao == null ? other$dataValidacao != null : !((Object)this$dataValidacao).equals(other$dataValidacao)) {
            return false;
        }
        String this$mensagemErro = this.getMensagemErro();
        String other$mensagemErro = other.getMensagemErro();
        return !(this$mensagemErro == null ? other$mensagemErro != null : !this$mensagemErro.equals(other$mensagemErro));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ErrosImportacaoSIMAM;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $idRegistro = this.getIdRegistro();
        result = result * 59 + ($idRegistro == null ? 43 : ((Object)$idRegistro).hashCode());
        Long $codigoErro = this.getCodigoErro();
        result = result * 59 + ($codigoErro == null ? 43 : ((Object)$codigoErro).hashCode());
        TipoRegistroSimAm $identificadorArquivo = this.getIdentificadorArquivo();
        result = result * 59 + ($identificadorArquivo == null ? 43 : $identificadorArquivo.hashCode());
        LocalDate $dataValidacao = this.getDataValidacao();
        result = result * 59 + ($dataValidacao == null ? 43 : ((Object)$dataValidacao).hashCode());
        String $mensagemErro = this.getMensagemErro();
        result = result * 59 + ($mensagemErro == null ? 43 : $mensagemErro.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ErrosImportacaoSIMAM(id=" + this.getId() + ", identificadorArquivo=" + this.getIdentificadorArquivo() + ", idRegistro=" + this.getIdRegistro() + ", codigoErro=" + this.getCodigoErro() + ", dataValidacao=" + this.getDataValidacao() + ", mensagemErro=" + this.getMensagemErro() + ")";
    }

    @Generated
    public ErrosImportacaoSIMAM() {
    }

    @Generated
    public ErrosImportacaoSIMAM(Long id, TipoRegistroSimAm identificadorArquivo, Long idRegistro, Long codigoErro, LocalDate dataValidacao, String mensagemErro) {
        this.id = id;
        this.identificadorArquivo = identificadorArquivo;
        this.idRegistro = idRegistro;
        this.codigoErro = codigoErro;
        this.dataValidacao = dataValidacao;
        this.mensagemErro = mensagemErro;
    }
}

