/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.simam;

import br.com.elotech.contabilidade.client.dto.RealizacaoReceitaTributoDTO;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="tceretencaocontabil")
public class RetencaoContabil
implements EloEntity<Long> {
    @Id
    @Column(name="idretencaocontabil")
    @EloSequence(sequenceName="s05idretencaocontabil")
    private Long id;
    private Long idTipoCredito;
    private LocalDate dtLancamento;
    private BigDecimal valor;
    private LocalDate dtEstorno;
    private String dsMotivoEstorno;
    private Boolean devolucao;

    public static RetencaoContabil from(RealizacaoReceitaTributoDTO dto, Long exercicio) {
        LocalDate dataLancamento = LocalDate.of(exercicio.intValue(), dto.getCompetencia(), 1).with(TemporalAdjusters.lastDayOfMonth());
        RetencaoContabil retencaoContabil = new RetencaoContabil();
        retencaoContabil.setIdTipoCredito(dto.getCodigoTributo());
        retencaoContabil.setDtLancamento(dataLancamento);
        retencaoContabil.setValor(dto.getValor());
        retencaoContabil.setDevolucao(dto.getDevolucao());
        return retencaoContabil;
    }

    public String getChave() {
        return String.format("%d-%d-%b", this.idTipoCredito, this.dtLancamento.getMonth().getValue(), this.devolucao);
    }

    @Generated
    public RetencaoContabil() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getIdTipoCredito() {
        return this.idTipoCredito;
    }

    @Generated
    public LocalDate getDtLancamento() {
        return this.dtLancamento;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public LocalDate getDtEstorno() {
        return this.dtEstorno;
    }

    @Generated
    public String getDsMotivoEstorno() {
        return this.dsMotivoEstorno;
    }

    @Generated
    public Boolean getDevolucao() {
        return this.devolucao;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setIdTipoCredito(Long idTipoCredito) {
        this.idTipoCredito = idTipoCredito;
    }

    @Generated
    public void setDtLancamento(LocalDate dtLancamento) {
        this.dtLancamento = dtLancamento;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setDtEstorno(LocalDate dtEstorno) {
        this.dtEstorno = dtEstorno;
    }

    @Generated
    public void setDsMotivoEstorno(String dsMotivoEstorno) {
        this.dsMotivoEstorno = dsMotivoEstorno;
    }

    @Generated
    public void setDevolucao(Boolean devolucao) {
        this.devolucao = devolucao;
    }

    @Generated
    public String toString() {
        return "RetencaoContabil(id=" + this.getId() + ", idTipoCredito=" + this.getIdTipoCredito() + ", dtLancamento=" + this.getDtLancamento() + ", valor=" + this.getValor() + ", dtEstorno=" + this.getDtEstorno() + ", dsMotivoEstorno=" + this.getDsMotivoEstorno() + ", devolucao=" + this.getDevolucao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RetencaoContabil)) {
            return false;
        }
        RetencaoContabil other = (RetencaoContabil)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RetencaoContabil;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

