/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.simam;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.converter.ClassificacaoTipoTributoConverter;
import br.com.elotech.tributos.converter.TipoNaturezaCreditoConverter;
import br.com.elotech.tributos.converter.TipoOperacaoCreditoConverter;
import br.com.elotech.tributos.dto.ClassificacaoTipoTributo;
import br.com.elotech.tributos.dto.TipoNaturezaCredito;
import br.com.elotech.tributos.dto.TipoOperacaoCredito;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Formula;

@Entity
@Table(name="tceinsccreditoda")
@DynamicUpdate
public class InscricaoCreditoDividaAtiva
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="s05idtceinsccreditoda")
    @Column(name="idtceinsccreditoda")
    private Long id;
    private Long nrDivida;
    private Long nrAnoDivida;
    @Column(name="idtiponaturezacredito")
    @Convert(converter=TipoNaturezaCreditoConverter.class)
    private TipoNaturezaCredito tipoNaturezaCredito;
    @Column(name="idtipocredito")
    @Convert(converter=ClassificacaoTipoTributoConverter.class)
    private ClassificacaoTipoTributo tipoCredito;
    @Column(name="idtipooperacaocredito")
    @Convert(converter=TipoOperacaoCreditoConverter.class)
    private TipoOperacaoCredito tipoOperacaoCredito;
    @Column(name="dtinscricao")
    private LocalDate dataInscricao = LocalDate.now();
    @Column(name="vlinscricao")
    private BigDecimal valorInscricao = BigDecimal.ZERO;
    private Long nrCredito;
    private Long nrAnoCredito;
    private Long nrAnoBase;
    private Long cdControleLeiAto;
    private Long nrAnoInscricao;
    @Formula(value="(select case when sum(1) > 0 then 1 else 2 end from triberrosimportacaosimam te  where te.identificadorarquivo = 'INSCRICAO_CREDITO_DIVIDA_ATIVA'  and te.idregistro = idtceinsccreditoda )")
    private Long hasErros;

    public Boolean getHasErros() {
        return Objects.nonNull(this.hasErros) && this.hasErros.equals(1L);
    }

    @Generated
    public InscricaoCreditoDividaAtiva() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getNrDivida() {
        return this.nrDivida;
    }

    @Generated
    public Long getNrAnoDivida() {
        return this.nrAnoDivida;
    }

    @Generated
    public TipoNaturezaCredito getTipoNaturezaCredito() {
        return this.tipoNaturezaCredito;
    }

    @Generated
    public ClassificacaoTipoTributo getTipoCredito() {
        return this.tipoCredito;
    }

    @Generated
    public TipoOperacaoCredito getTipoOperacaoCredito() {
        return this.tipoOperacaoCredito;
    }

    @Generated
    public LocalDate getDataInscricao() {
        return this.dataInscricao;
    }

    @Generated
    public BigDecimal getValorInscricao() {
        return this.valorInscricao;
    }

    @Generated
    public Long getNrCredito() {
        return this.nrCredito;
    }

    @Generated
    public Long getNrAnoCredito() {
        return this.nrAnoCredito;
    }

    @Generated
    public Long getNrAnoBase() {
        return this.nrAnoBase;
    }

    @Generated
    public Long getCdControleLeiAto() {
        return this.cdControleLeiAto;
    }

    @Generated
    public Long getNrAnoInscricao() {
        return this.nrAnoInscricao;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setNrDivida(Long nrDivida) {
        this.nrDivida = nrDivida;
    }

    @Generated
    public void setNrAnoDivida(Long nrAnoDivida) {
        this.nrAnoDivida = nrAnoDivida;
    }

    @Generated
    public void setTipoNaturezaCredito(TipoNaturezaCredito tipoNaturezaCredito) {
        this.tipoNaturezaCredito = tipoNaturezaCredito;
    }

    @Generated
    public void setTipoCredito(ClassificacaoTipoTributo tipoCredito) {
        this.tipoCredito = tipoCredito;
    }

    @Generated
    public void setTipoOperacaoCredito(TipoOperacaoCredito tipoOperacaoCredito) {
        this.tipoOperacaoCredito = tipoOperacaoCredito;
    }

    @Generated
    public void setDataInscricao(LocalDate dataInscricao) {
        this.dataInscricao = dataInscricao;
    }

    @Generated
    public void setValorInscricao(BigDecimal valorInscricao) {
        this.valorInscricao = valorInscricao;
    }

    @Generated
    public void setNrCredito(Long nrCredito) {
        this.nrCredito = nrCredito;
    }

    @Generated
    public void setNrAnoCredito(Long nrAnoCredito) {
        this.nrAnoCredito = nrAnoCredito;
    }

    @Generated
    public void setNrAnoBase(Long nrAnoBase) {
        this.nrAnoBase = nrAnoBase;
    }

    @Generated
    public void setCdControleLeiAto(Long cdControleLeiAto) {
        this.cdControleLeiAto = cdControleLeiAto;
    }

    @Generated
    public void setNrAnoInscricao(Long nrAnoInscricao) {
        this.nrAnoInscricao = nrAnoInscricao;
    }

    @Generated
    public void setHasErros(Long hasErros) {
        this.hasErros = hasErros;
    }

    @Generated
    public String toString() {
        return "InscricaoCreditoDividaAtiva(id=" + this.getId() + ", nrDivida=" + this.getNrDivida() + ", nrAnoDivida=" + this.getNrAnoDivida() + ", tipoNaturezaCredito=" + this.getTipoNaturezaCredito() + ", tipoCredito=" + this.getTipoCredito() + ", tipoOperacaoCredito=" + this.getTipoOperacaoCredito() + ", dataInscricao=" + this.getDataInscricao() + ", valorInscricao=" + this.getValorInscricao() + ", nrCredito=" + this.getNrCredito() + ", nrAnoCredito=" + this.getNrAnoCredito() + ", nrAnoBase=" + this.getNrAnoBase() + ", cdControleLeiAto=" + this.getCdControleLeiAto() + ", nrAnoInscricao=" + this.getNrAnoInscricao() + ", hasErros=" + this.getHasErros() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InscricaoCreditoDividaAtiva)) {
            return false;
        }
        InscricaoCreditoDividaAtiva other = (InscricaoCreditoDividaAtiva)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$nrDivida = this.getNrDivida();
        Long other$nrDivida = other.getNrDivida();
        if (this$nrDivida == null ? other$nrDivida != null : !((Object)this$nrDivida).equals(other$nrDivida)) {
            return false;
        }
        Long this$nrAnoDivida = this.getNrAnoDivida();
        Long other$nrAnoDivida = other.getNrAnoDivida();
        if (this$nrAnoDivida == null ? other$nrAnoDivida != null : !((Object)this$nrAnoDivida).equals(other$nrAnoDivida)) {
            return false;
        }
        Long this$nrCredito = this.getNrCredito();
        Long other$nrCredito = other.getNrCredito();
        if (this$nrCredito == null ? other$nrCredito != null : !((Object)this$nrCredito).equals(other$nrCredito)) {
            return false;
        }
        Long this$nrAnoCredito = this.getNrAnoCredito();
        Long other$nrAnoCredito = other.getNrAnoCredito();
        if (this$nrAnoCredito == null ? other$nrAnoCredito != null : !((Object)this$nrAnoCredito).equals(other$nrAnoCredito)) {
            return false;
        }
        Long this$nrAnoBase = this.getNrAnoBase();
        Long other$nrAnoBase = other.getNrAnoBase();
        if (this$nrAnoBase == null ? other$nrAnoBase != null : !((Object)this$nrAnoBase).equals(other$nrAnoBase)) {
            return false;
        }
        Long this$cdControleLeiAto = this.getCdControleLeiAto();
        Long other$cdControleLeiAto = other.getCdControleLeiAto();
        if (this$cdControleLeiAto == null ? other$cdControleLeiAto != null : !((Object)this$cdControleLeiAto).equals(other$cdControleLeiAto)) {
            return false;
        }
        Long this$nrAnoInscricao = this.getNrAnoInscricao();
        Long other$nrAnoInscricao = other.getNrAnoInscricao();
        if (this$nrAnoInscricao == null ? other$nrAnoInscricao != null : !((Object)this$nrAnoInscricao).equals(other$nrAnoInscricao)) {
            return false;
        }
        Boolean this$hasErros = this.getHasErros();
        Boolean other$hasErros = other.getHasErros();
        if (this$hasErros == null ? other$hasErros != null : !((Object)this$hasErros).equals(other$hasErros)) {
            return false;
        }
        TipoNaturezaCredito this$tipoNaturezaCredito = this.getTipoNaturezaCredito();
        TipoNaturezaCredito other$tipoNaturezaCredito = other.getTipoNaturezaCredito();
        if (this$tipoNaturezaCredito == null ? other$tipoNaturezaCredito != null : !this$tipoNaturezaCredito.equals(other$tipoNaturezaCredito)) {
            return false;
        }
        ClassificacaoTipoTributo this$tipoCredito = this.getTipoCredito();
        ClassificacaoTipoTributo other$tipoCredito = other.getTipoCredito();
        if (this$tipoCredito == null ? other$tipoCredito != null : !this$tipoCredito.equals(other$tipoCredito)) {
            return false;
        }
        TipoOperacaoCredito this$tipoOperacaoCredito = this.getTipoOperacaoCredito();
        TipoOperacaoCredito other$tipoOperacaoCredito = other.getTipoOperacaoCredito();
        if (this$tipoOperacaoCredito == null ? other$tipoOperacaoCredito != null : !this$tipoOperacaoCredito.equals(other$tipoOperacaoCredito)) {
            return false;
        }
        LocalDate this$dataInscricao = this.getDataInscricao();
        LocalDate other$dataInscricao = other.getDataInscricao();
        if (this$dataInscricao == null ? other$dataInscricao != null : !((Object)this$dataInscricao).equals(other$dataInscricao)) {
            return false;
        }
        BigDecimal this$valorInscricao = this.getValorInscricao();
        BigDecimal other$valorInscricao = other.getValorInscricao();
        return !(this$valorInscricao == null ? other$valorInscricao != null : !((Object)this$valorInscricao).equals(other$valorInscricao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InscricaoCreditoDividaAtiva;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $nrDivida = this.getNrDivida();
        result = result * 59 + ($nrDivida == null ? 43 : ((Object)$nrDivida).hashCode());
        Long $nrAnoDivida = this.getNrAnoDivida();
        result = result * 59 + ($nrAnoDivida == null ? 43 : ((Object)$nrAnoDivida).hashCode());
        Long $nrCredito = this.getNrCredito();
        result = result * 59 + ($nrCredito == null ? 43 : ((Object)$nrCredito).hashCode());
        Long $nrAnoCredito = this.getNrAnoCredito();
        result = result * 59 + ($nrAnoCredito == null ? 43 : ((Object)$nrAnoCredito).hashCode());
        Long $nrAnoBase = this.getNrAnoBase();
        result = result * 59 + ($nrAnoBase == null ? 43 : ((Object)$nrAnoBase).hashCode());
        Long $cdControleLeiAto = this.getCdControleLeiAto();
        result = result * 59 + ($cdControleLeiAto == null ? 43 : ((Object)$cdControleLeiAto).hashCode());
        Long $nrAnoInscricao = this.getNrAnoInscricao();
        result = result * 59 + ($nrAnoInscricao == null ? 43 : ((Object)$nrAnoInscricao).hashCode());
        Boolean $hasErros = this.getHasErros();
        result = result * 59 + ($hasErros == null ? 43 : ((Object)$hasErros).hashCode());
        TipoNaturezaCredito $tipoNaturezaCredito = this.getTipoNaturezaCredito();
        result = result * 59 + ($tipoNaturezaCredito == null ? 43 : $tipoNaturezaCredito.hashCode());
        ClassificacaoTipoTributo $tipoCredito = this.getTipoCredito();
        result = result * 59 + ($tipoCredito == null ? 43 : $tipoCredito.hashCode());
        TipoOperacaoCredito $tipoOperacaoCredito = this.getTipoOperacaoCredito();
        result = result * 59 + ($tipoOperacaoCredito == null ? 43 : $tipoOperacaoCredito.hashCode());
        LocalDate $dataInscricao = this.getDataInscricao();
        result = result * 59 + ($dataInscricao == null ? 43 : ((Object)$dataInscricao).hashCode());
        BigDecimal $valorInscricao = this.getValorInscricao();
        result = result * 59 + ($valorInscricao == null ? 43 : ((Object)$valorInscricao).hashCode());
        return result;
    }
}

