/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.rol;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.converter.parcelamento.SituacaoLegalConverter;
import br.com.elotech.tributos.domain.SituacaoParcela;
import br.com.elotech.tributos.domain.rol.RolDebitoParcelaId;
import br.com.elotech.tributos.domain.rol.RolDebitoParcelaTributo;
import br.com.elotech.tributos.dto.SituacaoLegal;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="tribroldebitoparcela")
public class RolDebitoParcela
implements EloEntity<RolDebitoParcelaId> {
    @EmbeddedId
    private RolDebitoParcelaId id;
    private LocalDate dataLancamento;
    private LocalDate dataVencimento;
    @Convert(converter=SituacaoLegalConverter.class)
    private SituacaoLegal situacaoLegal;
    @ManyToOne
    @JoinColumn(name="situacaodebito", referencedColumnName="situacaoparcela", insertable=false, updatable=false)
    private SituacaoParcela situacaoDebito;
    private BigDecimal valor;
    @OneToMany
    @JoinColumns(value={@JoinColumn(name="idrol", referencedColumnName="idrol", insertable=false, updatable=false), @JoinColumn(name="iddebito", referencedColumnName="iddebito", insertable=false, updatable=false), @JoinColumn(name="parcela", referencedColumnName="parcela", insertable=false, updatable=false)})
    private List<RolDebitoParcelaTributo> tributos;

    public String getSituacaoSigla() {
        return String.format("%s.%s", this.situacaoDebito.getSigla(), this.situacaoLegal.getSigla());
    }

    public String getSituacaoDescricao() {
        return String.format("%s %s", this.situacaoDebito.getDescricao(), this.situacaoLegal.getDescricao());
    }

    @Generated
    public RolDebitoParcela() {
    }

    @Generated
    public RolDebitoParcelaId getId() {
        return this.id;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public SituacaoLegal getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public SituacaoParcela getSituacaoDebito() {
        return this.situacaoDebito;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public List<RolDebitoParcelaTributo> getTributos() {
        return this.tributos;
    }

    @Generated
    public void setId(RolDebitoParcelaId id) {
        this.id = id;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setSituacaoLegal(SituacaoLegal situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setSituacaoDebito(SituacaoParcela situacaoDebito) {
        this.situacaoDebito = situacaoDebito;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setTributos(List<RolDebitoParcelaTributo> tributos) {
        this.tributos = tributos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RolDebitoParcela)) {
            return false;
        }
        RolDebitoParcela other = (RolDebitoParcela)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        RolDebitoParcelaId this$id = this.getId();
        RolDebitoParcelaId other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LocalDate this$dataLancamento = this.getDataLancamento();
        LocalDate other$dataLancamento = other.getDataLancamento();
        if (this$dataLancamento == null ? other$dataLancamento != null : !((Object)this$dataLancamento).equals(other$dataLancamento)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        SituacaoLegal this$situacaoLegal = this.getSituacaoLegal();
        SituacaoLegal other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !this$situacaoLegal.equals(other$situacaoLegal)) {
            return false;
        }
        SituacaoParcela this$situacaoDebito = this.getSituacaoDebito();
        SituacaoParcela other$situacaoDebito = other.getSituacaoDebito();
        if (this$situacaoDebito == null ? other$situacaoDebito != null : !this$situacaoDebito.equals(other$situacaoDebito)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        List this$tributos = this.getTributos();
        List other$tributos = other.getTributos();
        return !(this$tributos == null ? other$tributos != null : !((Object)this$tributos).equals(other$tributos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RolDebitoParcela;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RolDebitoParcelaId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LocalDate $dataLancamento = this.getDataLancamento();
        result = result * 59 + ($dataLancamento == null ? 43 : ((Object)$dataLancamento).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        SituacaoLegal $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : $situacaoLegal.hashCode());
        SituacaoParcela $situacaoDebito = this.getSituacaoDebito();
        result = result * 59 + ($situacaoDebito == null ? 43 : $situacaoDebito.hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        List $tributos = this.getTributos();
        result = result * 59 + ($tributos == null ? 43 : ((Object)$tributos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RolDebitoParcela(id=" + this.getId() + ", dataLancamento=" + this.getDataLancamento() + ", dataVencimento=" + this.getDataVencimento() + ", situacaoLegal=" + this.getSituacaoLegal() + ", situacaoDebito=" + this.getSituacaoDebito() + ", valor=" + this.getValor() + ", tributos=" + this.getTributos() + ")";
    }
}

