/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.protesto;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoVinculo;
import br.com.elotech.tributos.domain.protesto.CartorioProtesto;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessa;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessaIrregular;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessaOcorrencia;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="TRIBPROTESTOREMESSAITEM")
public class ProtestoRemessaItem
implements EloEntity<Long> {
    @Id
    @Column(nullable=false, updatable=false, name="idProtestoRemessaitem")
    @EloSequence(sequenceName="s05idprotestoremessaitem")
    private Long id;
    @Column(nullable=false)
    private Long sequencia;
    @Column(nullable=false)
    private Long exercicioDocumento;
    @Column(nullable=false)
    private Long tipoDocumento;
    @Column(nullable=false)
    private Long documento;
    @Column(nullable=false)
    private Long exercicioProtesto;
    @Column(nullable=false, name="protesto")
    private Long codigoProtesto;
    @ManyToOne
    @JoinColumn(name="cartorio", referencedColumnName="codigo")
    private CartorioProtesto cartorio;
    @Column
    private Long protocolo;
    @Column
    private LocalDate dataProtocolo;
    @Column
    private LocalDate dataOcorrencia;
    @Column(precision=17, scale=2)
    private BigDecimal valorCustasCartorio;
    @Column(precision=17, scale=2)
    private BigDecimal valorCustasDistribuidor;
    @Column(precision=17, scale=2)
    private BigDecimal valorDemaisDespesas;
    @Column
    private Long tipoCadastro;
    @Column
    private Long cadastroGeral;
    @ManyToOne
    private Pessoa pessoa;
    @Column
    private Long vinculo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="irregularidade0")
    private ProtestoRemessaIrregular irregularidade0;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="irregularidade1")
    private ProtestoRemessaIrregular irregularidade1;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="irregularidade2")
    private ProtestoRemessaIrregular irregularidade2;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="irregularidade3")
    private ProtestoRemessaIrregular irregularidade3;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="irregularidade4")
    private ProtestoRemessaIrregular irregularidade4;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idprotesto")
    private Protesto protesto;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade", nullable=false), @JoinColumn(name="exercicio", referencedColumnName="exercicio", nullable=false), @JoinColumn(name="remessa", referencedColumnName="remessa", nullable=false)})
    private ProtestoRemessa protestoRemessa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ocorrencia")
    @MetaModelIgnore
    @JsonIgnore
    private ProtestoRemessaOcorrencia ocorrencia;

    public boolean isSemVinculoOrPrincipal() {
        return Objects.equals(this.vinculo, 0L) || Objects.equals(this.vinculo, TipoVinculo.SEM_VINCULO.getValue()) || Objects.equals(this.vinculo, TipoVinculo.PRINCIPAL.getValue());
    }

    @Generated
    public ProtestoRemessaItem() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public Long getExercicioDocumento() {
        return this.exercicioDocumento;
    }

    @Generated
    public Long getTipoDocumento() {
        return this.tipoDocumento;
    }

    @Generated
    public Long getDocumento() {
        return this.documento;
    }

    @Generated
    public Long getExercicioProtesto() {
        return this.exercicioProtesto;
    }

    @Generated
    public Long getCodigoProtesto() {
        return this.codigoProtesto;
    }

    @Generated
    public CartorioProtesto getCartorio() {
        return this.cartorio;
    }

    @Generated
    public Long getProtocolo() {
        return this.protocolo;
    }

    @Generated
    public LocalDate getDataProtocolo() {
        return this.dataProtocolo;
    }

    @Generated
    public LocalDate getDataOcorrencia() {
        return this.dataOcorrencia;
    }

    @Generated
    public BigDecimal getValorCustasCartorio() {
        return this.valorCustasCartorio;
    }

    @Generated
    public BigDecimal getValorCustasDistribuidor() {
        return this.valorCustasDistribuidor;
    }

    @Generated
    public BigDecimal getValorDemaisDespesas() {
        return this.valorDemaisDespesas;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public Long getVinculo() {
        return this.vinculo;
    }

    @Generated
    public ProtestoRemessaIrregular getIrregularidade0() {
        return this.irregularidade0;
    }

    @Generated
    public ProtestoRemessaIrregular getIrregularidade1() {
        return this.irregularidade1;
    }

    @Generated
    public ProtestoRemessaIrregular getIrregularidade2() {
        return this.irregularidade2;
    }

    @Generated
    public ProtestoRemessaIrregular getIrregularidade3() {
        return this.irregularidade3;
    }

    @Generated
    public ProtestoRemessaIrregular getIrregularidade4() {
        return this.irregularidade4;
    }

    @Generated
    public Protesto getProtesto() {
        return this.protesto;
    }

    @Generated
    public ProtestoRemessa getProtestoRemessa() {
        return this.protestoRemessa;
    }

    @Generated
    public ProtestoRemessaOcorrencia getOcorrencia() {
        return this.ocorrencia;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setExercicioDocumento(Long exercicioDocumento) {
        this.exercicioDocumento = exercicioDocumento;
    }

    @Generated
    public void setTipoDocumento(Long tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    @Generated
    public void setDocumento(Long documento) {
        this.documento = documento;
    }

    @Generated
    public void setExercicioProtesto(Long exercicioProtesto) {
        this.exercicioProtesto = exercicioProtesto;
    }

    @Generated
    public void setCodigoProtesto(Long codigoProtesto) {
        this.codigoProtesto = codigoProtesto;
    }

    @Generated
    public void setCartorio(CartorioProtesto cartorio) {
        this.cartorio = cartorio;
    }

    @Generated
    public void setProtocolo(Long protocolo) {
        this.protocolo = protocolo;
    }

    @Generated
    public void setDataProtocolo(LocalDate dataProtocolo) {
        this.dataProtocolo = dataProtocolo;
    }

    @Generated
    public void setDataOcorrencia(LocalDate dataOcorrencia) {
        this.dataOcorrencia = dataOcorrencia;
    }

    @Generated
    public void setValorCustasCartorio(BigDecimal valorCustasCartorio) {
        this.valorCustasCartorio = valorCustasCartorio;
    }

    @Generated
    public void setValorCustasDistribuidor(BigDecimal valorCustasDistribuidor) {
        this.valorCustasDistribuidor = valorCustasDistribuidor;
    }

    @Generated
    public void setValorDemaisDespesas(BigDecimal valorDemaisDespesas) {
        this.valorDemaisDespesas = valorDemaisDespesas;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setVinculo(Long vinculo) {
        this.vinculo = vinculo;
    }

    @Generated
    public void setIrregularidade0(ProtestoRemessaIrregular irregularidade0) {
        this.irregularidade0 = irregularidade0;
    }

    @Generated
    public void setIrregularidade1(ProtestoRemessaIrregular irregularidade1) {
        this.irregularidade1 = irregularidade1;
    }

    @Generated
    public void setIrregularidade2(ProtestoRemessaIrregular irregularidade2) {
        this.irregularidade2 = irregularidade2;
    }

    @Generated
    public void setIrregularidade3(ProtestoRemessaIrregular irregularidade3) {
        this.irregularidade3 = irregularidade3;
    }

    @Generated
    public void setIrregularidade4(ProtestoRemessaIrregular irregularidade4) {
        this.irregularidade4 = irregularidade4;
    }

    @Generated
    public void setProtesto(Protesto protesto) {
        this.protesto = protesto;
    }

    @Generated
    public void setProtestoRemessa(ProtestoRemessa protestoRemessa) {
        this.protestoRemessa = protestoRemessa;
    }

    @JsonIgnore
    @Generated
    public void setOcorrencia(ProtestoRemessaOcorrencia ocorrencia) {
        this.ocorrencia = ocorrencia;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtestoRemessaItem)) {
            return false;
        }
        ProtestoRemessaItem other = (ProtestoRemessaItem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        Long this$exercicioDocumento = this.getExercicioDocumento();
        Long other$exercicioDocumento = other.getExercicioDocumento();
        if (this$exercicioDocumento == null ? other$exercicioDocumento != null : !((Object)this$exercicioDocumento).equals(other$exercicioDocumento)) {
            return false;
        }
        Long this$tipoDocumento = this.getTipoDocumento();
        Long other$tipoDocumento = other.getTipoDocumento();
        if (this$tipoDocumento == null ? other$tipoDocumento != null : !((Object)this$tipoDocumento).equals(other$tipoDocumento)) {
            return false;
        }
        Long this$documento = this.getDocumento();
        Long other$documento = other.getDocumento();
        if (this$documento == null ? other$documento != null : !((Object)this$documento).equals(other$documento)) {
            return false;
        }
        Long this$exercicioProtesto = this.getExercicioProtesto();
        Long other$exercicioProtesto = other.getExercicioProtesto();
        if (this$exercicioProtesto == null ? other$exercicioProtesto != null : !((Object)this$exercicioProtesto).equals(other$exercicioProtesto)) {
            return false;
        }
        Long this$codigoProtesto = this.getCodigoProtesto();
        Long other$codigoProtesto = other.getCodigoProtesto();
        if (this$codigoProtesto == null ? other$codigoProtesto != null : !((Object)this$codigoProtesto).equals(other$codigoProtesto)) {
            return false;
        }
        Long this$protocolo = this.getProtocolo();
        Long other$protocolo = other.getProtocolo();
        if (this$protocolo == null ? other$protocolo != null : !((Object)this$protocolo).equals(other$protocolo)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$vinculo = this.getVinculo();
        Long other$vinculo = other.getVinculo();
        if (this$vinculo == null ? other$vinculo != null : !((Object)this$vinculo).equals(other$vinculo)) {
            return false;
        }
        CartorioProtesto this$cartorio = this.getCartorio();
        CartorioProtesto other$cartorio = other.getCartorio();
        if (this$cartorio == null ? other$cartorio != null : !this$cartorio.equals(other$cartorio)) {
            return false;
        }
        LocalDate this$dataProtocolo = this.getDataProtocolo();
        LocalDate other$dataProtocolo = other.getDataProtocolo();
        if (this$dataProtocolo == null ? other$dataProtocolo != null : !((Object)this$dataProtocolo).equals(other$dataProtocolo)) {
            return false;
        }
        LocalDate this$dataOcorrencia = this.getDataOcorrencia();
        LocalDate other$dataOcorrencia = other.getDataOcorrencia();
        if (this$dataOcorrencia == null ? other$dataOcorrencia != null : !((Object)this$dataOcorrencia).equals(other$dataOcorrencia)) {
            return false;
        }
        BigDecimal this$valorCustasCartorio = this.getValorCustasCartorio();
        BigDecimal other$valorCustasCartorio = other.getValorCustasCartorio();
        if (this$valorCustasCartorio == null ? other$valorCustasCartorio != null : !((Object)this$valorCustasCartorio).equals(other$valorCustasCartorio)) {
            return false;
        }
        BigDecimal this$valorCustasDistribuidor = this.getValorCustasDistribuidor();
        BigDecimal other$valorCustasDistribuidor = other.getValorCustasDistribuidor();
        if (this$valorCustasDistribuidor == null ? other$valorCustasDistribuidor != null : !((Object)this$valorCustasDistribuidor).equals(other$valorCustasDistribuidor)) {
            return false;
        }
        BigDecimal this$valorDemaisDespesas = this.getValorDemaisDespesas();
        BigDecimal other$valorDemaisDespesas = other.getValorDemaisDespesas();
        if (this$valorDemaisDespesas == null ? other$valorDemaisDespesas != null : !((Object)this$valorDemaisDespesas).equals(other$valorDemaisDespesas)) {
            return false;
        }
        Pessoa this$pessoa = this.getPessoa();
        Pessoa other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !this$pessoa.equals(other$pessoa)) {
            return false;
        }
        ProtestoRemessaIrregular this$irregularidade0 = this.getIrregularidade0();
        ProtestoRemessaIrregular other$irregularidade0 = other.getIrregularidade0();
        if (this$irregularidade0 == null ? other$irregularidade0 != null : !this$irregularidade0.equals(other$irregularidade0)) {
            return false;
        }
        ProtestoRemessaIrregular this$irregularidade1 = this.getIrregularidade1();
        ProtestoRemessaIrregular other$irregularidade1 = other.getIrregularidade1();
        if (this$irregularidade1 == null ? other$irregularidade1 != null : !this$irregularidade1.equals(other$irregularidade1)) {
            return false;
        }
        ProtestoRemessaIrregular this$irregularidade2 = this.getIrregularidade2();
        ProtestoRemessaIrregular other$irregularidade2 = other.getIrregularidade2();
        if (this$irregularidade2 == null ? other$irregularidade2 != null : !this$irregularidade2.equals(other$irregularidade2)) {
            return false;
        }
        ProtestoRemessaIrregular this$irregularidade3 = this.getIrregularidade3();
        ProtestoRemessaIrregular other$irregularidade3 = other.getIrregularidade3();
        if (this$irregularidade3 == null ? other$irregularidade3 != null : !this$irregularidade3.equals(other$irregularidade3)) {
            return false;
        }
        ProtestoRemessaIrregular this$irregularidade4 = this.getIrregularidade4();
        ProtestoRemessaIrregular other$irregularidade4 = other.getIrregularidade4();
        if (this$irregularidade4 == null ? other$irregularidade4 != null : !this$irregularidade4.equals(other$irregularidade4)) {
            return false;
        }
        Protesto this$protesto = this.getProtesto();
        Protesto other$protesto = other.getProtesto();
        if (this$protesto == null ? other$protesto != null : !this$protesto.equals(other$protesto)) {
            return false;
        }
        ProtestoRemessa this$protestoRemessa = this.getProtestoRemessa();
        ProtestoRemessa other$protestoRemessa = other.getProtestoRemessa();
        if (this$protestoRemessa == null ? other$protestoRemessa != null : !this$protestoRemessa.equals(other$protestoRemessa)) {
            return false;
        }
        ProtestoRemessaOcorrencia this$ocorrencia = this.getOcorrencia();
        ProtestoRemessaOcorrencia other$ocorrencia = other.getOcorrencia();
        return !(this$ocorrencia == null ? other$ocorrencia != null : !this$ocorrencia.equals(other$ocorrencia));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProtestoRemessaItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        Long $exercicioDocumento = this.getExercicioDocumento();
        result = result * 59 + ($exercicioDocumento == null ? 43 : ((Object)$exercicioDocumento).hashCode());
        Long $tipoDocumento = this.getTipoDocumento();
        result = result * 59 + ($tipoDocumento == null ? 43 : ((Object)$tipoDocumento).hashCode());
        Long $documento = this.getDocumento();
        result = result * 59 + ($documento == null ? 43 : ((Object)$documento).hashCode());
        Long $exercicioProtesto = this.getExercicioProtesto();
        result = result * 59 + ($exercicioProtesto == null ? 43 : ((Object)$exercicioProtesto).hashCode());
        Long $codigoProtesto = this.getCodigoProtesto();
        result = result * 59 + ($codigoProtesto == null ? 43 : ((Object)$codigoProtesto).hashCode());
        Long $protocolo = this.getProtocolo();
        result = result * 59 + ($protocolo == null ? 43 : ((Object)$protocolo).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $vinculo = this.getVinculo();
        result = result * 59 + ($vinculo == null ? 43 : ((Object)$vinculo).hashCode());
        CartorioProtesto $cartorio = this.getCartorio();
        result = result * 59 + ($cartorio == null ? 43 : $cartorio.hashCode());
        LocalDate $dataProtocolo = this.getDataProtocolo();
        result = result * 59 + ($dataProtocolo == null ? 43 : ((Object)$dataProtocolo).hashCode());
        LocalDate $dataOcorrencia = this.getDataOcorrencia();
        result = result * 59 + ($dataOcorrencia == null ? 43 : ((Object)$dataOcorrencia).hashCode());
        BigDecimal $valorCustasCartorio = this.getValorCustasCartorio();
        result = result * 59 + ($valorCustasCartorio == null ? 43 : ((Object)$valorCustasCartorio).hashCode());
        BigDecimal $valorCustasDistribuidor = this.getValorCustasDistribuidor();
        result = result * 59 + ($valorCustasDistribuidor == null ? 43 : ((Object)$valorCustasDistribuidor).hashCode());
        BigDecimal $valorDemaisDespesas = this.getValorDemaisDespesas();
        result = result * 59 + ($valorDemaisDespesas == null ? 43 : ((Object)$valorDemaisDespesas).hashCode());
        Pessoa $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : $pessoa.hashCode());
        ProtestoRemessaIrregular $irregularidade0 = this.getIrregularidade0();
        result = result * 59 + ($irregularidade0 == null ? 43 : $irregularidade0.hashCode());
        ProtestoRemessaIrregular $irregularidade1 = this.getIrregularidade1();
        result = result * 59 + ($irregularidade1 == null ? 43 : $irregularidade1.hashCode());
        ProtestoRemessaIrregular $irregularidade2 = this.getIrregularidade2();
        result = result * 59 + ($irregularidade2 == null ? 43 : $irregularidade2.hashCode());
        ProtestoRemessaIrregular $irregularidade3 = this.getIrregularidade3();
        result = result * 59 + ($irregularidade3 == null ? 43 : $irregularidade3.hashCode());
        ProtestoRemessaIrregular $irregularidade4 = this.getIrregularidade4();
        result = result * 59 + ($irregularidade4 == null ? 43 : $irregularidade4.hashCode());
        Protesto $protesto = this.getProtesto();
        result = result * 59 + ($protesto == null ? 43 : $protesto.hashCode());
        ProtestoRemessa $protestoRemessa = this.getProtestoRemessa();
        result = result * 59 + ($protestoRemessa == null ? 43 : $protestoRemessa.hashCode());
        ProtestoRemessaOcorrencia $ocorrencia = this.getOcorrencia();
        result = result * 59 + ($ocorrencia == null ? 43 : $ocorrencia.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProtestoRemessaItem(id=" + this.getId() + ", sequencia=" + this.getSequencia() + ", exercicioDocumento=" + this.getExercicioDocumento() + ", tipoDocumento=" + this.getTipoDocumento() + ", documento=" + this.getDocumento() + ", exercicioProtesto=" + this.getExercicioProtesto() + ", codigoProtesto=" + this.getCodigoProtesto() + ", cartorio=" + this.getCartorio() + ", protocolo=" + this.getProtocolo() + ", dataProtocolo=" + this.getDataProtocolo() + ", dataOcorrencia=" + this.getDataOcorrencia() + ", valorCustasCartorio=" + this.getValorCustasCartorio() + ", valorCustasDistribuidor=" + this.getValorCustasDistribuidor() + ", valorDemaisDespesas=" + this.getValorDemaisDespesas() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", pessoa=" + this.getPessoa() + ", vinculo=" + this.getVinculo() + ", irregularidade0=" + this.getIrregularidade0() + ", irregularidade1=" + this.getIrregularidade1() + ", irregularidade2=" + this.getIrregularidade2() + ", irregularidade3=" + this.getIrregularidade3() + ", irregularidade4=" + this.getIrregularidade4() + ", protesto=" + this.getProtesto() + ", protestoRemessa=" + this.getProtestoRemessa() + ", ocorrencia=" + this.getOcorrencia() + ")";
    }
}

