/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.mobiliario;

import br.com.elotech.audit.reader.DiffRevisionIgnore;
import br.com.elotech.audit.reader.DiffRevisionIgnoreProperties;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.mobiliario.RegimeFiscal;
import br.com.elotech.tributos.dto.RegimeFiscalDTO;
import br.com.elotech.tributos.dto.RegimeFiscalPeriodoAlteracaoDTO;
import br.com.elotech.tributos.dto.RegimeFiscalPeriodoDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.envers.Audited;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="TRIBREGIMEFISCALPERIODO")
@Audited
public class RegimeFiscalPeriodo
implements EloEntity<Long> {
    @Id
    @Column(name="idRegimeFiscalPeriodo")
    @EloSequence(sequenceName="S05IDREGIMEFISCALPERIODO", applyOnMerge=true)
    private Long id;
    @ManyToOne
    @JoinColumn(name="idRegimeFiscal", referencedColumnName="idRegimeFiscal")
    @Caption(value="Regime Fiscal")
    @DiffRevisionIgnoreProperties(value={"id", "issGeraDebito", "simplesNacional", "mei", "aliqZero"})
    private RegimeFiscal regimeFiscal;
    @Column(name="inicio")
    @Caption(value="Data Inicial")
    private LocalDate dataInicial;
    @Column(name="final")
    @Caption(value="Data Final")
    private LocalDate dataFinal;
    @Column(length=20)
    @Caption(value="Processo")
    private String processo;
    @Caption(value="Status")
    private Long status;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idcadastro", referencedColumnName="idcadastrogeraliss")
    @JsonIgnore
    @MetaModelIgnore
    private CadastroGeral cadastroGeral;
    @Caption(value="N\u00famero Op\u00e7\u00e3o")
    @Column(name="numero_opcao")
    private Long numeroOpcao;

    @DiffRevisionIgnore
    public Boolean isActual() {
        return this.dataFinal == null || this.dataFinal.isAfter(LocalDate.now());
    }

    public static RegimeFiscalPeriodo of(RegimeFiscalPeriodoDTO dto) {
        RegimeFiscalPeriodo regime = RegimeFiscalPeriodo.getRegimeFiscalPeriodo((LocalDate)dto.getDataInicial(), (LocalDate)dto.getDataFinal(), (Long)dto.getNumeroOpcao(), (String)dto.getProcesso(), (Long)dto.getStatus());
        Optional.ofNullable(dto.getRegimeFiscal()).ifPresent(regimeFiscalDTO -> regime.setRegimeFiscal(RegimeFiscal.from((RegimeFiscalDTO)regimeFiscalDTO)));
        return regime;
    }

    public static RegimeFiscalPeriodo ofAlteracaoCadastral(RegimeFiscalPeriodoAlteracaoDTO dto) {
        return RegimeFiscalPeriodo.getRegimeFiscalPeriodo((LocalDate)dto.getDataInicial(), (LocalDate)dto.getDataFinal(), (Long)dto.getNumeroOpcao(), (String)dto.getProcesso(), (Long)dto.getStatus());
    }

    public void merge(RegimeFiscalPeriodo regimeFiscalPeriodo) {
        this.setDataInicial(regimeFiscalPeriodo.getDataInicial());
        this.setDataFinal(regimeFiscalPeriodo.getDataFinal());
        this.setProcesso(regimeFiscalPeriodo.getProcesso());
        this.setStatus(regimeFiscalPeriodo.getStatus());
        this.setNumeroOpcao(regimeFiscalPeriodo.getNumeroOpcao());
    }

    private static RegimeFiscalPeriodo getRegimeFiscalPeriodo(LocalDate dataInicial, LocalDate dataFinal, Long numeroOpcao, String processo, Long status) {
        RegimeFiscalPeriodo regime = new RegimeFiscalPeriodo();
        Optional.ofNullable(dataInicial).ifPresent(arg_0 -> regime.setDataInicial(arg_0));
        Optional.ofNullable(dataFinal).ifPresent(arg_0 -> regime.setDataFinal(arg_0));
        Optional.ofNullable(numeroOpcao).ifPresent(arg_0 -> regime.setNumeroOpcao(arg_0));
        Optional.ofNullable(processo).ifPresent(arg_0 -> regime.setProcesso(arg_0));
        Optional.ofNullable(status).ifPresent(arg_0 -> regime.setStatus(arg_0));
        return regime;
    }

    @Generated
    public RegimeFiscalPeriodo() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public RegimeFiscal getRegimeFiscal() {
        return this.regimeFiscal;
    }

    @Generated
    public LocalDate getDataInicial() {
        return this.dataInicial;
    }

    @Generated
    public LocalDate getDataFinal() {
        return this.dataFinal;
    }

    @Generated
    public String getProcesso() {
        return this.processo;
    }

    @Generated
    public Long getStatus() {
        return this.status;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getNumeroOpcao() {
        return this.numeroOpcao;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setRegimeFiscal(RegimeFiscal regimeFiscal) {
        this.regimeFiscal = regimeFiscal;
    }

    @Generated
    public void setDataInicial(LocalDate dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Generated
    public void setDataFinal(LocalDate dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Generated
    public void setProcesso(String processo) {
        this.processo = processo;
    }

    @Generated
    public void setStatus(Long status) {
        this.status = status;
    }

    @JsonIgnore
    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setNumeroOpcao(Long numeroOpcao) {
        this.numeroOpcao = numeroOpcao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegimeFiscalPeriodo)) {
            return false;
        }
        RegimeFiscalPeriodo other = (RegimeFiscalPeriodo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegimeFiscalPeriodo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RegimeFiscalPeriodo(id=" + this.getId() + ")";
    }
}

