/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.mobiliario;

import br.com.elotech.audit.reader.DiffRevisionIgnoreProperties;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Cnae;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.dto.CadastroMobiliarioCnaeDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;

@Entity
@Table(name="TRIBMOBILIARIOCNAE")
@Audited
public class CadastroMobiliarioCnae
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(sequenceName="S_TRIBMOBILIARIOCNAE_ID", applyOnMerge=true)
    private Long id;
    @ManyToOne
    @JoinColumn(name="cnae", referencedColumnName="cnae")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @DiffRevisionIgnoreProperties(value={"id", "cnaeAtividade", "inicioValidade", "secao", "admiteMovimento", "situacaoMEI", "situacaoSNA", "classificacaoAtividade", "grauRisco", "permiteAlvaraSemAcessibilidade", "verificarArea", "valorBaseCalculo", "inativo", "configuracaoAtividade", "idUnico", "permiteServico", "vedadaMicroEmpreendedor", "vedadaSimplesNacional"})
    @Caption(value="CNAE")
    private Cnae cnae;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="tribcadastromobiliario_idkey", referencedColumnName="tribcadastrogeral_idkey")
    @JsonIgnore
    @MetaModelIgnore
    private CadastroMobiliario cadastroMobiliario;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Principal")
    private Boolean cnaePrincipal = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Gerar Lan\u00e7amento")
    private Boolean gerarLancamento = Boolean.TRUE;
    @Caption(value="Data In\u00edcio")
    private LocalDate dataInicio;
    @Caption(value="Data Fim")
    private LocalDate dataFim;

    public static CadastroMobiliarioCnae set(CadastroMobiliarioCnaeDTO dto) {
        CadastroMobiliarioCnae cnae = new CadastroMobiliarioCnae();
        Optional.ofNullable(dto.getCnaePrincipal()).ifPresent(arg_0 -> cnae.setCnaePrincipal(arg_0));
        Optional.ofNullable(dto.getDataInicio()).ifPresent(arg_0 -> cnae.setDataInicio(arg_0));
        Optional.ofNullable(dto.getDataFim()).ifPresent(arg_0 -> cnae.setDataFim(arg_0));
        Optional.ofNullable(dto.getGeraLancamento()).ifPresent(arg_0 -> cnae.setGerarLancamento(arg_0));
        return cnae;
    }

    public void merge(CadastroMobiliarioCnae cadastroMobiliarioCnae) {
        this.setCnaePrincipal(cadastroMobiliarioCnae.getCnaePrincipal());
        this.setGerarLancamento(cadastroMobiliarioCnae.getGerarLancamento());
        this.setDataInicio(cadastroMobiliarioCnae.getDataInicio());
        this.setDataFim(cadastroMobiliarioCnae.getDataFim());
    }

    @Generated
    public String toString() {
        return "CadastroMobiliarioCnae(id=" + this.getId() + ", cnae=" + this.getCnae() + ", cadastroMobiliario=" + this.getCadastroMobiliario() + ", cnaePrincipal=" + this.getCnaePrincipal() + ", gerarLancamento=" + this.getGerarLancamento() + ", dataInicio=" + this.getDataInicio() + ", dataFim=" + this.getDataFim() + ")";
    }

    @Generated
    public CadastroMobiliarioCnae() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Cnae getCnae() {
        return this.cnae;
    }

    @Generated
    public CadastroMobiliario getCadastroMobiliario() {
        return this.cadastroMobiliario;
    }

    @Generated
    public Boolean getCnaePrincipal() {
        return this.cnaePrincipal;
    }

    @Generated
    public Boolean getGerarLancamento() {
        return this.gerarLancamento;
    }

    @Generated
    public LocalDate getDataInicio() {
        return this.dataInicio;
    }

    @Generated
    public LocalDate getDataFim() {
        return this.dataFim;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCnae(Cnae cnae) {
        this.cnae = cnae;
    }

    @JsonIgnore
    @Generated
    public void setCadastroMobiliario(CadastroMobiliario cadastroMobiliario) {
        this.cadastroMobiliario = cadastroMobiliario;
    }

    @Generated
    public void setCnaePrincipal(Boolean cnaePrincipal) {
        this.cnaePrincipal = cnaePrincipal;
    }

    @Generated
    public void setGerarLancamento(Boolean gerarLancamento) {
        this.gerarLancamento = gerarLancamento;
    }

    @Generated
    public void setDataInicio(LocalDate dataInicio) {
        this.dataInicio = dataInicio;
    }

    @Generated
    public void setDataFim(LocalDate dataFim) {
        this.dataFim = dataFim;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroMobiliarioCnae)) {
            return false;
        }
        CadastroMobiliarioCnae other = (CadastroMobiliarioCnae)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroMobiliarioCnae;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

