/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.memoria;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.SituacaoSegmentoImob;
import br.com.elotech.tributos.domain.TipoSegmento;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.memoria.ImobiliarioSegmentoMemoriaId;
import br.com.elotech.tributos.domain.memoria.RespostaSegmentoMemoria;
import br.com.elotech.tributos.util.ListUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import lombok.Generated;

@Entity
@Table(name="tribimobiliariosegmentomemoria")
public class ImobiliarioSegmentoMemoria
implements EloEntity<ImobiliarioSegmentoMemoriaId>,
Serializable {
    @EmbeddedId
    private ImobiliarioSegmentoMemoriaId id;
    @Column(name="tipocadastro")
    private Long tipoCadastro;
    @Column(name="cadastrogeral")
    private Long cadastroGeral;
    @Column(name="sequencia")
    private Long sequencia;
    @ManyToOne
    @JoinColumn(name="TIPOSEGMENTO", referencedColumnName="TIPOSEGMENTO")
    @Caption(value="Tipo de Segmento")
    private TipoSegmento tipoSegmento;
    @Min(value=0L)
    @Column(scale=15, precision=4)
    private @Min(value=0L) BigDecimal areaConstruida = BigDecimal.ZERO;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Principal")
    private Boolean principal = Boolean.FALSE;
    @ManyToOne
    @JoinColumn(name="idsituacaosegmento", referencedColumnName="idsituacaosegmento")
    @Caption(value="Situa\u00e7\u00e3o")
    private SituacaoSegmentoImob situacaoSegmento;
    @Caption(value="\u00c1rea Coberta")
    private BigDecimal areaCoberta = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Descoberta")
    private BigDecimal areaDescoberta = BigDecimal.ZERO;
    @EloSequence(sequenceName="S05IDSEGMENTOIMOBILIARIO")
    private Long idSegmentoImobiliario;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="segmento", fetch=FetchType.EAGER)
    @OrderBy(value="id")
    private final List<RespostaSegmentoMemoria> respostasSegmento = new ArrayList();

    @JsonIgnore
    public Boolean lancaImposto() {
        return Optional.ofNullable(this.getSituacaoSegmento()).map(SituacaoSegmentoImob::getLancaImposto).orElse(Boolean.FALSE);
    }

    public void merge(ImobiliarioSegmentoMemoria segmento) {
        this.tipoSegmento = segmento.getTipoSegmento();
        this.areaConstruida = segmento.getAreaConstruida();
        this.situacaoSegmento = segmento.getSituacaoSegmento();
        this.mergeRespostasSegmento(segmento.getRespostasSegmento());
    }

    public void mergeRespostasSegmento(List<RespostaSegmentoMemoria> respostas) {
        List merged = ListUtils.merge((List)this.getRespostasSegmento(), respostas, Resposta::getId, RespostaSegmentoMemoria::merge);
        merged.forEach(resposta -> resposta.setSegmento(this));
        this.getRespostasSegmento().clear();
        this.getRespostasSegmento().addAll(merged);
    }

    @Generated
    public ImobiliarioSegmentoMemoria() {
    }

    @Generated
    public ImobiliarioSegmentoMemoriaId getId() {
        return this.id;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public TipoSegmento getTipoSegmento() {
        return this.tipoSegmento;
    }

    @Generated
    public BigDecimal getAreaConstruida() {
        return this.areaConstruida;
    }

    @Generated
    public Boolean getPrincipal() {
        return this.principal;
    }

    @Generated
    public SituacaoSegmentoImob getSituacaoSegmento() {
        return this.situacaoSegmento;
    }

    @Generated
    public BigDecimal getAreaCoberta() {
        return this.areaCoberta;
    }

    @Generated
    public BigDecimal getAreaDescoberta() {
        return this.areaDescoberta;
    }

    @Generated
    public Long getIdSegmentoImobiliario() {
        return this.idSegmentoImobiliario;
    }

    @Generated
    public List<RespostaSegmentoMemoria> getRespostasSegmento() {
        return this.respostasSegmento;
    }

    @Generated
    public void setId(ImobiliarioSegmentoMemoriaId id) {
        this.id = id;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setTipoSegmento(TipoSegmento tipoSegmento) {
        this.tipoSegmento = tipoSegmento;
    }

    @Generated
    public void setAreaConstruida(BigDecimal areaConstruida) {
        this.areaConstruida = areaConstruida;
    }

    @Generated
    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    @Generated
    public void setSituacaoSegmento(SituacaoSegmentoImob situacaoSegmento) {
        this.situacaoSegmento = situacaoSegmento;
    }

    @Generated
    public void setAreaCoberta(BigDecimal areaCoberta) {
        this.areaCoberta = areaCoberta;
    }

    @Generated
    public void setAreaDescoberta(BigDecimal areaDescoberta) {
        this.areaDescoberta = areaDescoberta;
    }

    @Generated
    public void setIdSegmentoImobiliario(Long idSegmentoImobiliario) {
        this.idSegmentoImobiliario = idSegmentoImobiliario;
    }

    @Generated
    public String toString() {
        return "ImobiliarioSegmentoMemoria(id=" + this.getId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImobiliarioSegmentoMemoria)) {
            return false;
        }
        ImobiliarioSegmentoMemoria other = (ImobiliarioSegmentoMemoria)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ImobiliarioSegmentoMemoriaId this$id = this.getId();
        ImobiliarioSegmentoMemoriaId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImobiliarioSegmentoMemoria;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImobiliarioSegmentoMemoriaId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

