/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.memoria;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.MotivoExclusaoLogica;
import br.com.elotech.tributos.domain.memoria.CadastroGeralIsencaoMemoria;
import br.com.elotech.tributos.domain.memoria.CadastroGeralMemoriaId;
import br.com.elotech.tributos.domain.memoria.MemoriaCadastro;
import br.com.elotech.tributos.domain.memoria.RespostaTerrenoMemoria;
import br.com.elotech.tributos.domain.sanepar.SaneparMatricula;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="tribcadastrogeralmemoria")
public class CadastroGeralMemoria
implements EloEntity<CadastroGeralMemoriaId>,
Serializable {
    @EmbeddedId
    private CadastroGeralMemoriaId id;
    @EloSequence(sequenceName="S_TRIBCADGERALMEM_IDKEY")
    private Long idKey;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idmemoriacadastro", insertable=false, updatable=false)
    private MemoriaCadastro memoriaCadastro;
    private Long pessoa;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Exclus\u00e3o L\u00f3gica")
    private Boolean exclusaoLogica = Boolean.FALSE;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="cidade", referencedColumnName="cidade", insertable=false, updatable=false), @JoinColumn(name="logradouro", referencedColumnName="logradouro", insertable=false, updatable=false)})
    @Caption(value="Logradouro")
    private Logradouro logradouro;
    @Length(max=10)
    @Caption(value="N\u00famero")
    private @Length(max=10) String numero;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Englobado")
    private Boolean englobado = Boolean.FALSE;
    @Length(max=100)
    @Caption(value="Complemento")
    private @Length(max=100) String complemento;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Suspenso Emiss\u00e3o")
    private Boolean suspensoEmissao = Boolean.FALSE;
    @ManyToOne
    @JoinColumn(name="cidade", insertable=false, updatable=false)
    @Caption(value="Cidade")
    private Cidade cidade;
    @ManyToOne
    @JoinColumn(name="bairro")
    @Caption(value="Bairro")
    private Bairro bairro;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Correspond\u00eancia Local")
    private Boolean correspondenciaLocal = Boolean.FALSE;
    @Caption(value="Data da Inclus\u00e3o")
    private LocalDate dataInclusao = LocalDate.now();
    @Caption(value="Data de Altera\u00e7\u00e3o")
    private LocalDate dataAlteracao = LocalDate.now();
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="D\u00e9bito Autom\u00e1tico")
    private Boolean debitoAutomatico;
    @Length(max=25)
    @Caption(value="Identifica\u00e7\u00e3o")
    private @Length(max=25) String identificacao;
    @Length(max=250)
    @Caption(value="Usu\u00e1rio da \u00daltima altera\u00e7\u00e3o")
    private @Length(max=250) String usuario;
    @Caption(value="CEP")
    private Long cep;
    @ManyToOne
    @Caption(value="Motivo Exclusao Logica")
    private MotivoExclusaoLogica motivoExclusaoLogica;
    @Caption(value="Data Restauracao Logica")
    private LocalDate dataRestauracaoLogica;
    @Caption(value="Data Exclusao Logica")
    private LocalDate dataExclusaoLogica;
    @Length(max=100)
    @Caption(value="Endere\u00e7o Correspond\u00eancia")
    private @Length(max=100) String enderecoCorrespondencia;
    @Length(max=20)
    @Caption(value="N\u00famero Correspond\u00eancia")
    private @Length(max=20) String numeroCorrespondencia;
    @Length(max=100)
    @Caption(value="Complemento Correspond\u00eancia")
    private @Length(max=100) String complementoCorrespondencia;
    @Length(max=100)
    @Caption(value="Cidade/UF Correspond\u00eancia")
    private @Length(max=100) String cidadeUfCorrespondencia;
    @Length(max=20)
    @Caption(value="CEP Correspond\u00eancia")
    private @Length(max=20) String cepCorrespondencia;
    @Length(max=100)
    @Caption(value="Bairro Correspondencia")
    private @Length(max=100) String bairroCorrespondencia;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Endere\u00e7o Entrega Carne Anual")
    private Boolean enderecoEntregaCarneAnual;
    @Length(max=2)
    @Caption(value="UF Correspond\u00eancia")
    private @Length(max=2) String ufCorrespondencia;
    @NotNull
    @Caption(value="Tipo de Cadastro")
    @Column(name="tipocadastro", insertable=false, updatable=false)
    private Long tipoCadastro;
    @Caption(value="C\u00f3digo do Cadastro")
    @Column(name="cadastrogeral", insertable=false, updatable=false)
    private Long cadastroGeral;
    @OneToMany(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="tipoCadastro", referencedColumnName="tipoCadastro", insertable=false, updatable=false), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastroGeral", insertable=false, updatable=false)})
    @Caption(value="Conv\u00eanio Sanepar")
    private final List<SaneparMatricula> saneparMatriculas = new ArrayList();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="cadastroGeralMemoria")
    private List<CadastroGeralIsencaoMemoria> isencoesMemoria = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="cadastroGeral")
    @Caption(value="Boletim Terreno")
    private final List<RespostaTerrenoMemoria> respostasTerrenoMemoria = new ArrayList();

    @Generated
    public CadastroGeralMemoria() {
    }

    @Generated
    public CadastroGeralMemoriaId getId() {
        return this.id;
    }

    @Generated
    public Long getIdKey() {
        return this.idKey;
    }

    @Generated
    public MemoriaCadastro getMemoriaCadastro() {
        return this.memoriaCadastro;
    }

    @Generated
    public Long getPessoa() {
        return this.pessoa;
    }

    @Generated
    public Boolean getExclusaoLogica() {
        return this.exclusaoLogica;
    }

    @Generated
    public Logradouro getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public Boolean getEnglobado() {
        return this.englobado;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public Boolean getSuspensoEmissao() {
        return this.suspensoEmissao;
    }

    @Generated
    public Cidade getCidade() {
        return this.cidade;
    }

    @Generated
    public Bairro getBairro() {
        return this.bairro;
    }

    @Generated
    public Boolean getCorrespondenciaLocal() {
        return this.correspondenciaLocal;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    @Generated
    public Boolean getDebitoAutomatico() {
        return this.debitoAutomatico;
    }

    @Generated
    public String getIdentificacao() {
        return this.identificacao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Long getCep() {
        return this.cep;
    }

    @Generated
    public MotivoExclusaoLogica getMotivoExclusaoLogica() {
        return this.motivoExclusaoLogica;
    }

    @Generated
    public LocalDate getDataRestauracaoLogica() {
        return this.dataRestauracaoLogica;
    }

    @Generated
    public LocalDate getDataExclusaoLogica() {
        return this.dataExclusaoLogica;
    }

    @Generated
    public String getEnderecoCorrespondencia() {
        return this.enderecoCorrespondencia;
    }

    @Generated
    public String getNumeroCorrespondencia() {
        return this.numeroCorrespondencia;
    }

    @Generated
    public String getComplementoCorrespondencia() {
        return this.complementoCorrespondencia;
    }

    @Generated
    public String getCidadeUfCorrespondencia() {
        return this.cidadeUfCorrespondencia;
    }

    @Generated
    public String getCepCorrespondencia() {
        return this.cepCorrespondencia;
    }

    @Generated
    public String getBairroCorrespondencia() {
        return this.bairroCorrespondencia;
    }

    @Generated
    public Boolean getEnderecoEntregaCarneAnual() {
        return this.enderecoEntregaCarneAnual;
    }

    @Generated
    public String getUfCorrespondencia() {
        return this.ufCorrespondencia;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public List<SaneparMatricula> getSaneparMatriculas() {
        return this.saneparMatriculas;
    }

    @Generated
    public List<CadastroGeralIsencaoMemoria> getIsencoesMemoria() {
        return this.isencoesMemoria;
    }

    @Generated
    public List<RespostaTerrenoMemoria> getRespostasTerrenoMemoria() {
        return this.respostasTerrenoMemoria;
    }

    @Generated
    public void setId(CadastroGeralMemoriaId id) {
        this.id = id;
    }

    @Generated
    public void setIdKey(Long idKey) {
        this.idKey = idKey;
    }

    @Generated
    public void setMemoriaCadastro(MemoriaCadastro memoriaCadastro) {
        this.memoriaCadastro = memoriaCadastro;
    }

    @Generated
    public void setPessoa(Long pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setExclusaoLogica(Boolean exclusaoLogica) {
        this.exclusaoLogica = exclusaoLogica;
    }

    @Generated
    public void setLogradouro(Logradouro logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setEnglobado(Boolean englobado) {
        this.englobado = englobado;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setSuspensoEmissao(Boolean suspensoEmissao) {
        this.suspensoEmissao = suspensoEmissao;
    }

    @Generated
    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setBairro(Bairro bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setCorrespondenciaLocal(Boolean correspondenciaLocal) {
        this.correspondenciaLocal = correspondenciaLocal;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @Generated
    public void setDebitoAutomatico(Boolean debitoAutomatico) {
        this.debitoAutomatico = debitoAutomatico;
    }

    @Generated
    public void setIdentificacao(String identificacao) {
        this.identificacao = identificacao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setCep(Long cep) {
        this.cep = cep;
    }

    @Generated
    public void setMotivoExclusaoLogica(MotivoExclusaoLogica motivoExclusaoLogica) {
        this.motivoExclusaoLogica = motivoExclusaoLogica;
    }

    @Generated
    public void setDataRestauracaoLogica(LocalDate dataRestauracaoLogica) {
        this.dataRestauracaoLogica = dataRestauracaoLogica;
    }

    @Generated
    public void setDataExclusaoLogica(LocalDate dataExclusaoLogica) {
        this.dataExclusaoLogica = dataExclusaoLogica;
    }

    @Generated
    public void setEnderecoCorrespondencia(String enderecoCorrespondencia) {
        this.enderecoCorrespondencia = enderecoCorrespondencia;
    }

    @Generated
    public void setNumeroCorrespondencia(String numeroCorrespondencia) {
        this.numeroCorrespondencia = numeroCorrespondencia;
    }

    @Generated
    public void setComplementoCorrespondencia(String complementoCorrespondencia) {
        this.complementoCorrespondencia = complementoCorrespondencia;
    }

    @Generated
    public void setCidadeUfCorrespondencia(String cidadeUfCorrespondencia) {
        this.cidadeUfCorrespondencia = cidadeUfCorrespondencia;
    }

    @Generated
    public void setCepCorrespondencia(String cepCorrespondencia) {
        this.cepCorrespondencia = cepCorrespondencia;
    }

    @Generated
    public void setBairroCorrespondencia(String bairroCorrespondencia) {
        this.bairroCorrespondencia = bairroCorrespondencia;
    }

    @Generated
    public void setEnderecoEntregaCarneAnual(Boolean enderecoEntregaCarneAnual) {
        this.enderecoEntregaCarneAnual = enderecoEntregaCarneAnual;
    }

    @Generated
    public void setUfCorrespondencia(String ufCorrespondencia) {
        this.ufCorrespondencia = ufCorrespondencia;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setIsencoesMemoria(List<CadastroGeralIsencaoMemoria> isencoesMemoria) {
        this.isencoesMemoria = isencoesMemoria;
    }

    @Generated
    public String toString() {
        return "CadastroGeralMemoria(super=" + super.toString() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroGeralMemoria)) {
            return false;
        }
        CadastroGeralMemoria other = (CadastroGeralMemoria)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        CadastroGeralMemoriaId this$id = this.getId();
        CadastroGeralMemoriaId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroGeralMemoria;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CadastroGeralMemoriaId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

