/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.integracaocontabil;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.integracaocontabil.IntegracaoPatrimonial;
import br.com.elotech.tributos.dto.ClassificacaoTributo;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.integracaocontabil.ItemIntegracaoPatrimonialContabilidadeDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ItemIntegracaoPatrimonialDTO;
import br.com.elotech.tributos.dto.integracaocontabil.TipoMovimentoPatrimonial;
import java.math.BigDecimal;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.springframework.data.domain.Persistable;

@Entity
@Table(name="itemintegracaopatrimonial")
public class ItemIntegracaoPatrimonial
implements EloEntity<Long>,
Persistable<Long> {
    @Id
    @EloSequence(applyOnMerge=true, sequenceName="seq_itemintegracaopatrimonial")
    private Long id;
    @Enumerated(value=EnumType.STRING)
    private TipoMovimentoPatrimonial tipoMovimento;
    private Long tipoOperacaoDeducao;
    private String tributo;
    private String descricaoTributo;
    private ClassificacaoTributo classificacaoTributo;
    private SituacaoLegal situacaoLegal;
    private BigDecimal valor;
    private Long idDebito;
    private Long tipoDeducao;
    private Long tipoTributo;
    private Long idDebitoParcelaReceita;
    private Long idUnicoPessoa;
    @ManyToOne
    @JoinColumn(name="idintegracaopatrimonial", updatable=false, nullable=false)
    private IntegracaoPatrimonial integracao;

    public static ItemIntegracaoPatrimonial from(ItemIntegracaoPatrimonialDTO dto, IntegracaoPatrimonial integracaoPatrimonial) {
        ItemIntegracaoPatrimonial entity = new ItemIntegracaoPatrimonial();
        entity.setTipoMovimento(dto.getTipoMovimento());
        entity.setTipoOperacaoDeducao(dto.getTipoOperacaoDeducao());
        entity.setTributo(dto.getTributo());
        entity.setDescricaoTributo(dto.getDescricaoTributo());
        entity.setClassificacaoTributo(ClassificacaoTributo.fromValue((String)dto.getClassificacaoTributo()));
        entity.setSituacaoLegal(SituacaoLegal.fromValue((Integer)dto.getSituacaoLegal().intValue()));
        entity.setValor(dto.getValor());
        entity.setIdDebito(dto.getIdDebito());
        entity.setTipoDeducao(dto.getTipoDeducao());
        entity.setTipoTributo(dto.getTipoTributo());
        entity.setIdDebitoParcelaReceita(dto.getIdDebitoParcelaReceita());
        entity.setIdUnicoPessoa(dto.getIdUnicoPessoa());
        entity.setIntegracao(integracaoPatrimonial);
        return entity;
    }

    public ItemIntegracaoPatrimonialContabilidadeDTO toDto() {
        ItemIntegracaoPatrimonialContabilidadeDTO dto = new ItemIntegracaoPatrimonialContabilidadeDTO();
        dto.setTipoMovimento(this.tipoMovimento);
        dto.setTipoOperacaoDeducao(this.tipoOperacaoDeducao);
        dto.setTributo(this.tributo);
        dto.setDescricaoTributo(this.descricaoTributo);
        dto.setClassificacaoTributo(this.classificacaoTributo);
        dto.setSituacaoLegal(this.situacaoLegal);
        dto.setValor(this.valor);
        dto.setTipoTributo(this.tipoTributo);
        dto.setIdUnicoPessoa(this.idUnicoPessoa);
        return dto;
    }

    public boolean isNew() {
        return Boolean.TRUE;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemIntegracaoPatrimonial)) {
            return false;
        }
        ItemIntegracaoPatrimonial other = (ItemIntegracaoPatrimonial)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ItemIntegracaoPatrimonial;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public ItemIntegracaoPatrimonial() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public TipoMovimentoPatrimonial getTipoMovimento() {
        return this.tipoMovimento;
    }

    @Generated
    public Long getTipoOperacaoDeducao() {
        return this.tipoOperacaoDeducao;
    }

    @Generated
    public String getTributo() {
        return this.tributo;
    }

    @Generated
    public String getDescricaoTributo() {
        return this.descricaoTributo;
    }

    @Generated
    public ClassificacaoTributo getClassificacaoTributo() {
        return this.classificacaoTributo;
    }

    @Generated
    public SituacaoLegal getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public Long getTipoDeducao() {
        return this.tipoDeducao;
    }

    @Generated
    public Long getTipoTributo() {
        return this.tipoTributo;
    }

    @Generated
    public Long getIdDebitoParcelaReceita() {
        return this.idDebitoParcelaReceita;
    }

    @Generated
    public Long getIdUnicoPessoa() {
        return this.idUnicoPessoa;
    }

    @Generated
    public IntegracaoPatrimonial getIntegracao() {
        return this.integracao;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTipoMovimento(TipoMovimentoPatrimonial tipoMovimento) {
        this.tipoMovimento = tipoMovimento;
    }

    @Generated
    public void setTipoOperacaoDeducao(Long tipoOperacaoDeducao) {
        this.tipoOperacaoDeducao = tipoOperacaoDeducao;
    }

    @Generated
    public void setTributo(String tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setDescricaoTributo(String descricaoTributo) {
        this.descricaoTributo = descricaoTributo;
    }

    @Generated
    public void setClassificacaoTributo(ClassificacaoTributo classificacaoTributo) {
        this.classificacaoTributo = classificacaoTributo;
    }

    @Generated
    public void setSituacaoLegal(SituacaoLegal situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setTipoDeducao(Long tipoDeducao) {
        this.tipoDeducao = tipoDeducao;
    }

    @Generated
    public void setTipoTributo(Long tipoTributo) {
        this.tipoTributo = tipoTributo;
    }

    @Generated
    public void setIdDebitoParcelaReceita(Long idDebitoParcelaReceita) {
        this.idDebitoParcelaReceita = idDebitoParcelaReceita;
    }

    @Generated
    public void setIdUnicoPessoa(Long idUnicoPessoa) {
        this.idUnicoPessoa = idUnicoPessoa;
    }

    @Generated
    public void setIntegracao(IntegracaoPatrimonial integracao) {
        this.integracao = integracao;
    }

    @Generated
    public String toString() {
        return "ItemIntegracaoPatrimonial(id=" + this.getId() + ", tipoMovimento=" + this.getTipoMovimento() + ", tipoOperacaoDeducao=" + this.getTipoOperacaoDeducao() + ", tributo=" + this.getTributo() + ", descricaoTributo=" + this.getDescricaoTributo() + ", classificacaoTributo=" + this.getClassificacaoTributo() + ", situacaoLegal=" + this.getSituacaoLegal() + ", valor=" + this.getValor() + ", idDebito=" + this.getIdDebito() + ", tipoDeducao=" + this.getTipoDeducao() + ", tipoTributo=" + this.getTipoTributo() + ", idDebitoParcelaReceita=" + this.getIdDebitoParcelaReceita() + ", idUnicoPessoa=" + this.getIdUnicoPessoa() + ", integracao=" + this.getIntegracao() + ")";
    }
}

