/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.imobiliario;

import br.com.elotech.audit.reader.DiffRevisionIgnoreProperties;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.TipoAreaVerde;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.envers.AuditTable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.springframework.beans.BeanUtils;

@Entity
@Table(name="TRIBIMOBILIARIOAREAVERDE")
@Audited
@AuditTable(value="TRIBIMOBILIARIOAREAVERDE_AUD")
public class CadastroImobiliarioAreaVerde
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBIMOBILIARIOAREAVERDE_ID")
    private Long id;
    @Caption(value="Sequ\u00eancia")
    private Long sequencia;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Considera para C\u00e1lculo")
    private Boolean consideraParaCalculo = Boolean.FALSE;
    @ManyToOne
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @Caption(value="Tipo \u00c1rea Verde")
    @DiffRevisionIgnoreProperties(value={"id"})
    private TipoAreaVerde tipoAreaVerde;
    @Caption(value="\u00c1rea")
    private BigDecimal area = BigDecimal.ZERO;
    @NotAudited
    private BigDecimal valor = BigDecimal.ZERO;

    public void merge(CadastroImobiliarioAreaVerde novaAreaVerde) {
        this.area = novaAreaVerde.getArea();
        this.tipoAreaVerde = novaAreaVerde.getTipoAreaVerde();
        this.consideraParaCalculo = novaAreaVerde.getConsideraParaCalculo();
    }

    public CadastroImobiliarioAreaVerde copy() {
        CadastroImobiliarioAreaVerde cadastroImobiliarioAreaVerde = new CadastroImobiliarioAreaVerde();
        BeanUtils.copyProperties((Object)this, (Object)cadastroImobiliarioAreaVerde, (String[])new String[]{"id"});
        return cadastroImobiliarioAreaVerde;
    }

    @Generated
    public String toString() {
        return "CadastroImobiliarioAreaVerde(id=" + this.getId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroImobiliarioAreaVerde)) {
            return false;
        }
        CadastroImobiliarioAreaVerde other = (CadastroImobiliarioAreaVerde)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroImobiliarioAreaVerde;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public CadastroImobiliarioAreaVerde() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public Boolean getConsideraParaCalculo() {
        return this.consideraParaCalculo;
    }

    @Generated
    public TipoAreaVerde getTipoAreaVerde() {
        return this.tipoAreaVerde;
    }

    @Generated
    public BigDecimal getArea() {
        return this.area;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setConsideraParaCalculo(Boolean consideraParaCalculo) {
        this.consideraParaCalculo = consideraParaCalculo;
    }

    @Generated
    public void setTipoAreaVerde(TipoAreaVerde tipoAreaVerde) {
        this.tipoAreaVerde = tipoAreaVerde;
    }

    @Generated
    public void setArea(BigDecimal area) {
        this.area = area;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }
}

