/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.documento.peticao;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtiva;
import br.com.elotech.tributos.domain.documento.peticao.LotePeticaoItem;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="triblotepeticaoitemdetalhe")
public class LotePeticaoItemDetalhe
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="SLOTEPETICAOITEMDETALHE")
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idlotepeticaoitem", nullable=false)
    @JsonIgnore
    @MetaModelIgnore
    private LotePeticaoItem item;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="iddocumento", nullable=false)
    @JsonIgnoreProperties(value={"entidadeTributacao"})
    private Documento documento;
    @Length(max=1000, message="Tamanho m\u00e1ximo da inconsist\u00eancia \u00e9 1000 caracteres.")
    private @Length(max=1000, message="Tamanho m\u00e1ximo da inconsist\u00eancia \u00e9 1000 caracteres.") String inconsistencia;

    public BigDecimal getValorTotal() {
        return this.documento.getDocumentoItemDividaAtivas().stream().map(DocumentoItemDividaAtiva::getTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getValor() {
        return this.documento.getDocumentoItemDividaAtivas().stream().map(DocumentoItemDividaAtiva::getValor).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getValorAcrescimos() {
        return this.documento.getDocumentoItemDividaAtivas().stream().map(DocumentoItemDividaAtiva::getTotalAcrescimos).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Generated
    public LotePeticaoItemDetalhe() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public LotePeticaoItem getItem() {
        return this.item;
    }

    @Generated
    public Documento getDocumento() {
        return this.documento;
    }

    @Generated
    public String getInconsistencia() {
        return this.inconsistencia;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setItem(LotePeticaoItem item) {
        this.item = item;
    }

    @JsonIgnoreProperties(value={"entidadeTributacao"})
    @Generated
    public void setDocumento(Documento documento) {
        this.documento = documento;
    }

    @Generated
    public void setInconsistencia(String inconsistencia) {
        this.inconsistencia = inconsistencia;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LotePeticaoItemDetalhe)) {
            return false;
        }
        LotePeticaoItemDetalhe other = (LotePeticaoItemDetalhe)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LotePeticaoItemDetalhe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LotePeticaoItemDetalhe(id=" + this.getId() + ")";
    }
}

