/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.documento.cda;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.documento.cda.LoteCda;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItemDetalhe;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItemPessoa;
import br.com.elotech.tributos.domain.protesto.GeracaoProtestoErro;
import br.com.elotech.tributos.dto.LoteCdaItemAgrupadoDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Formula;

@Entity
@Table(name="triblotecdaitem")
public class LoteCdaItem
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="SLOTECDAITEM", applyOnMerge=true)
    private Long id;
    @NotNull
    private Long sequencia;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY", nullable=false)
    @JsonIgnoreProperties(value={"cadastroGeralIsencoes", "cadastroImobiliarioAvaliacoes", "cadastroImobiliarioSegmentos", "cadastroImobiliarioAreasVerde", "cadastroImobiliarioSituacoes", "cadastroImobiliarioSegmentos", "distritoInscricaoCadastral", "setorInscricaoCadastral", "condominio", "loteamento", "cadastroImobiliarioTestadas", "boletinsImobiliarioTerreno", "imobiliarioTestadasGenericas", "cmcResponsavel"})
    private CadastroGeral cadastroGeral;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="IDDOCUMENTO")
    @JsonIgnoreProperties(value={"cadastroGeral"})
    private Documento documento;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idlotecda", referencedColumnName="id", nullable=false)
    @JsonIgnore
    @MetaModelIgnore
    private LoteCda lote;
    @OneToMany(mappedBy="loteItem", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<LoteCdaItemDetalhe> itemDetalhes = new ArrayList();
    @OneToMany(mappedBy="loteItem", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<LoteCdaItemPessoa> itemPessoas = new ArrayList();
    @Formula(value="(select sum(tplid.valor + tplid.VALORCORRECAO + tplid.VALORJUROS + tplid.VALORMULTA)  from triblotecdaitemdetalhe tplid  where tplid.idlotecdaitem = id)")
    private BigDecimal valorTotal;
    @OneToMany(mappedBy="loteCdaItem", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<GeracaoProtestoErro> erroGeracaoProtesto = new ArrayList();

    @JsonIgnore
    public void setChildrenId() {
        this.itemDetalhes.forEach(loteCdaItemDetalhe -> loteCdaItemDetalhe.setLoteItem(this));
    }

    public BigDecimal calculateValorTotal() {
        return this.itemDetalhes.stream().map(LoteCdaItemDetalhe::getValorTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public List<LoteCdaItemAgrupadoDTO> getItensAgrupados() {
        Map<LoteCdaItemAgrupadoDTO, List<LoteCdaItemDetalhe>> itensDetalhesAgrupados = this.itemDetalhes.stream().collect(Collectors.groupingBy(LoteCdaItemAgrupadoDTO::ofWithoutValues));
        ArrayList itens = new ArrayList();
        itensDetalhesAgrupados.forEach((loteCdaItemAgrupadoDTO, loteCdaItemDetalhes) -> itens.add(loteCdaItemDetalhes.stream().map(LoteCdaItemAgrupadoDTO::of).reduce((LoteCdaItemAgrupadoDTO)loteCdaItemAgrupadoDTO, (item, acumulator) -> {
            acumulator.setValor(acumulator.getValor().add(item.getValor()));
            acumulator.setValorJuros(acumulator.getValorJuros().add(item.getValorJuros()));
            acumulator.setValorMulta(acumulator.getValorMulta().add(item.getValorMulta()));
            acumulator.setValorCorrecao(acumulator.getValorCorrecao().add(item.getValorCorrecao()));
            return acumulator;
        })));
        return itens.stream().sorted(Comparator.comparing(LoteCdaItemAgrupadoDTO::getExercicio).thenComparing(LoteCdaItemAgrupadoDTO::getDivida).thenComparing(LoteCdaItemAgrupadoDTO::getSubDivida).thenComparing(LoteCdaItemAgrupadoDTO::getParcela)).collect(Collectors.toList());
    }

    public void addDetalhe(LoteCdaItemDetalhe detalhe) {
        this.itemDetalhes.add(detalhe);
    }

    @Generated
    public LoteCdaItem() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Documento getDocumento() {
        return this.documento;
    }

    @Generated
    public LoteCda getLote() {
        return this.lote;
    }

    @Generated
    public List<LoteCdaItemDetalhe> getItemDetalhes() {
        return this.itemDetalhes;
    }

    @Generated
    public List<LoteCdaItemPessoa> getItemPessoas() {
        return this.itemPessoas;
    }

    @Generated
    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public List<GeracaoProtestoErro> getErroGeracaoProtesto() {
        return this.erroGeracaoProtesto;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @JsonIgnoreProperties(value={"cadastroGeralIsencoes", "cadastroImobiliarioAvaliacoes", "cadastroImobiliarioSegmentos", "cadastroImobiliarioAreasVerde", "cadastroImobiliarioSituacoes", "cadastroImobiliarioSegmentos", "distritoInscricaoCadastral", "setorInscricaoCadastral", "condominio", "loteamento", "cadastroImobiliarioTestadas", "boletinsImobiliarioTerreno", "imobiliarioTestadasGenericas", "cmcResponsavel"})
    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @JsonIgnoreProperties(value={"cadastroGeral"})
    @Generated
    public void setDocumento(Documento documento) {
        this.documento = documento;
    }

    @JsonIgnore
    @Generated
    public void setLote(LoteCda lote) {
        this.lote = lote;
    }

    @Generated
    public void setItemDetalhes(List<LoteCdaItemDetalhe> itemDetalhes) {
        this.itemDetalhes = itemDetalhes;
    }

    @Generated
    public void setItemPessoas(List<LoteCdaItemPessoa> itemPessoas) {
        this.itemPessoas = itemPessoas;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setErroGeracaoProtesto(List<GeracaoProtestoErro> erroGeracaoProtesto) {
        this.erroGeracaoProtesto = erroGeracaoProtesto;
    }

    @Generated
    public String toString() {
        return "LoteCdaItem(id=" + this.getId() + ", sequencia=" + this.getSequencia() + ", cadastroGeral=" + this.getCadastroGeral() + ", documento=" + this.getDocumento() + ", itemDetalhes=" + this.getItemDetalhes() + ", itemPessoas=" + this.getItemPessoas() + ", valorTotal=" + this.getValorTotal() + ", erroGeracaoProtesto=" + this.getErroGeracaoProtesto() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoteCdaItem)) {
            return false;
        }
        LoteCdaItem other = (LoteCdaItem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LoteCdaItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

