/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.devolucaocredito;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.converter.SituacaoDevolucaoCreditoConverter;
import br.com.elotech.tributos.converter.TipoDevolucaoCreditoConverter;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.SituacaoDevolucaoCredito;
import br.com.elotech.tributos.domain.TipoDevolucaoCredito;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoItem;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="tribDevolucaoCredito")
public class DevolucaoCredito
implements EloEntity<Long>,
Serializable {
    @Id
    @EloSequence(sequenceName="s05IDDevolucaoCredito")
    @Column(name="IDDEVOLUCAOCREDITO")
    private Long id;
    @EloSequence(sequenceName="s05DevolucaoCredito")
    private Long devolucaocredito;
    private Long entidade;
    private Long exercicio;
    private Long idProcesso;
    private String usuario;
    @NotNull
    private BigDecimal valorDevolucao;
    @Length(max=1000)
    private @Length(max=1000) String observacao;
    @Length(max=1000)
    private @Length(max=1000) String obsNotificacao;
    @Length(max=1000)
    private @Length(max=1000) String obsParecer;
    private LocalDate data;
    private LocalDate dataInclusao;
    private LocalDate dataCancelamento;
    @Convert(converter=SituacaoDevolucaoCreditoConverter.class)
    private SituacaoDevolucaoCredito situacao;
    @Convert(converter=TipoDevolucaoCreditoConverter.class)
    private TipoDevolucaoCredito tipo;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="motivoDesconto", referencedColumnName="motivoDesconto")
    private MotivoDeducao motivoDesconto;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="contaBancaria", referencedColumnName="contaBancaria"))})
    private ContaBancaria contaBancaria;
    @ManyToOne
    @JoinColumn(name="bancoCredito", referencedColumnName="banco")
    private Banco bancoCredito;
    private String agenciaCredito;
    @Length(max=15)
    private @Length(max=15) String contaCredito;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pessoaCredito", referencedColumnName="pessoa")
    private Pessoa pessoaCredito;
    @Length(max=10)
    private @Length(max=10) String contaOperacao;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean efetuarCorrecao;
    private LocalDate dataCorrecao;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="formaCorrecao", referencedColumnName="formaCorrecao")
    private FormaCorrecao formaCorrecao;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="id.devolucaoCredito", orphanRemoval=true)
    private List<DevolucaoCreditoItem> itens = new ArrayList();
    @Length(max=20, message="Tamanho m\u00e1ximo do Processo SEI \u00e9 de 20")
    private @Length(max=20, message="Tamanho m\u00e1ximo do Processo SEI \u00e9 de 20") String processoSei;

    @Generated
    public DevolucaoCredito() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getDevolucaocredito() {
        return this.devolucaocredito;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public BigDecimal getValorDevolucao() {
        return this.valorDevolucao;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getObsNotificacao() {
        return this.obsNotificacao;
    }

    @Generated
    public String getObsParecer() {
        return this.obsParecer;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public LocalDate getDataCancelamento() {
        return this.dataCancelamento;
    }

    @Generated
    public SituacaoDevolucaoCredito getSituacao() {
        return this.situacao;
    }

    @Generated
    public TipoDevolucaoCredito getTipo() {
        return this.tipo;
    }

    @Generated
    public MotivoDeducao getMotivoDesconto() {
        return this.motivoDesconto;
    }

    @Generated
    public ContaBancaria getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public Banco getBancoCredito() {
        return this.bancoCredito;
    }

    @Generated
    public String getAgenciaCredito() {
        return this.agenciaCredito;
    }

    @Generated
    public String getContaCredito() {
        return this.contaCredito;
    }

    @Generated
    public Pessoa getPessoaCredito() {
        return this.pessoaCredito;
    }

    @Generated
    public String getContaOperacao() {
        return this.contaOperacao;
    }

    @Generated
    public Boolean getEfetuarCorrecao() {
        return this.efetuarCorrecao;
    }

    @Generated
    public LocalDate getDataCorrecao() {
        return this.dataCorrecao;
    }

    @Generated
    public FormaCorrecao getFormaCorrecao() {
        return this.formaCorrecao;
    }

    @Generated
    public List<DevolucaoCreditoItem> getItens() {
        return this.itens;
    }

    @Generated
    public String getProcessoSei() {
        return this.processoSei;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDevolucaocredito(Long devolucaocredito) {
        this.devolucaocredito = devolucaocredito;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setIdProcesso(Long idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setValorDevolucao(BigDecimal valorDevolucao) {
        this.valorDevolucao = valorDevolucao;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setObsNotificacao(String obsNotificacao) {
        this.obsNotificacao = obsNotificacao;
    }

    @Generated
    public void setObsParecer(String obsParecer) {
        this.obsParecer = obsParecer;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setDataCancelamento(LocalDate dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @Generated
    public void setSituacao(SituacaoDevolucaoCredito situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setTipo(TipoDevolucaoCredito tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setMotivoDesconto(MotivoDeducao motivoDesconto) {
        this.motivoDesconto = motivoDesconto;
    }

    @Generated
    public void setContaBancaria(ContaBancaria contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public void setBancoCredito(Banco bancoCredito) {
        this.bancoCredito = bancoCredito;
    }

    @Generated
    public void setAgenciaCredito(String agenciaCredito) {
        this.agenciaCredito = agenciaCredito;
    }

    @Generated
    public void setContaCredito(String contaCredito) {
        this.contaCredito = contaCredito;
    }

    @Generated
    public void setPessoaCredito(Pessoa pessoaCredito) {
        this.pessoaCredito = pessoaCredito;
    }

    @Generated
    public void setContaOperacao(String contaOperacao) {
        this.contaOperacao = contaOperacao;
    }

    @Generated
    public void setEfetuarCorrecao(Boolean efetuarCorrecao) {
        this.efetuarCorrecao = efetuarCorrecao;
    }

    @Generated
    public void setDataCorrecao(LocalDate dataCorrecao) {
        this.dataCorrecao = dataCorrecao;
    }

    @Generated
    public void setFormaCorrecao(FormaCorrecao formaCorrecao) {
        this.formaCorrecao = formaCorrecao;
    }

    @Generated
    public void setItens(List<DevolucaoCreditoItem> itens) {
        this.itens = itens;
    }

    @Generated
    public void setProcessoSei(String processoSei) {
        this.processoSei = processoSei;
    }

    @Generated
    public String toString() {
        return "DevolucaoCredito(id=" + this.getId() + ", devolucaocredito=" + this.getDevolucaocredito() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", idProcesso=" + this.getIdProcesso() + ", usuario=" + this.getUsuario() + ", valorDevolucao=" + this.getValorDevolucao() + ", observacao=" + this.getObservacao() + ", obsNotificacao=" + this.getObsNotificacao() + ", obsParecer=" + this.getObsParecer() + ", data=" + this.getData() + ", dataInclusao=" + this.getDataInclusao() + ", dataCancelamento=" + this.getDataCancelamento() + ", situacao=" + this.getSituacao() + ", tipo=" + this.getTipo() + ", motivoDesconto=" + this.getMotivoDesconto() + ", contaBancaria=" + this.getContaBancaria() + ", bancoCredito=" + this.getBancoCredito() + ", agenciaCredito=" + this.getAgenciaCredito() + ", contaCredito=" + this.getContaCredito() + ", pessoaCredito=" + this.getPessoaCredito() + ", contaOperacao=" + this.getContaOperacao() + ", efetuarCorrecao=" + this.getEfetuarCorrecao() + ", dataCorrecao=" + this.getDataCorrecao() + ", formaCorrecao=" + this.getFormaCorrecao() + ", itens=" + this.getItens() + ", processoSei=" + this.getProcessoSei() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DevolucaoCredito)) {
            return false;
        }
        DevolucaoCredito other = (DevolucaoCredito)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DevolucaoCredito;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

