/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.atendimento;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.atendimento.TipoAtendimento;
import br.com.elotech.tributos.domain.atendimento.TipoFiltroAtendimento;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table
public class Atendimento
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="S_ATENDIMENTO_ID")
    private Long id;
    @NotNull
    @Column(name="tipo")
    @Enumerated(value=EnumType.STRING)
    private TipoAtendimento tipoAtendimento;
    private String atendenteCpfCnpj;
    @NotNull
    private LocalDateTime horarioInicio;
    private LocalDateTime horarioFim;
    @Length(max=14)
    private @Length(max=14) String cpfCnpjRequerente;
    @Length(max=150)
    private @Length(max=150) String nomeRequerente;
    @Length(max=250)
    private @Length(max=250) String observacao;
    @ManyToOne
    private Pessoa contribuinte;
    @NotNull
    @ManyToOne
    private CadastroGeral cadastroGeral;
    @Enumerated(value=EnumType.STRING)
    private TipoFiltroAtendimento tipoFiltro;

    public Boolean isFinalizado() {
        return this.getHorarioFim() != null;
    }

    @Generated
    public Atendimento() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public TipoAtendimento getTipoAtendimento() {
        return this.tipoAtendimento;
    }

    @Generated
    public String getAtendenteCpfCnpj() {
        return this.atendenteCpfCnpj;
    }

    @Generated
    public LocalDateTime getHorarioInicio() {
        return this.horarioInicio;
    }

    @Generated
    public LocalDateTime getHorarioFim() {
        return this.horarioFim;
    }

    @Generated
    public String getCpfCnpjRequerente() {
        return this.cpfCnpjRequerente;
    }

    @Generated
    public String getNomeRequerente() {
        return this.nomeRequerente;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public Pessoa getContribuinte() {
        return this.contribuinte;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public TipoFiltroAtendimento getTipoFiltro() {
        return this.tipoFiltro;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTipoAtendimento(TipoAtendimento tipoAtendimento) {
        this.tipoAtendimento = tipoAtendimento;
    }

    @Generated
    public void setAtendenteCpfCnpj(String atendenteCpfCnpj) {
        this.atendenteCpfCnpj = atendenteCpfCnpj;
    }

    @Generated
    public void setHorarioInicio(LocalDateTime horarioInicio) {
        this.horarioInicio = horarioInicio;
    }

    @Generated
    public void setHorarioFim(LocalDateTime horarioFim) {
        this.horarioFim = horarioFim;
    }

    @Generated
    public void setCpfCnpjRequerente(String cpfCnpjRequerente) {
        this.cpfCnpjRequerente = cpfCnpjRequerente;
    }

    @Generated
    public void setNomeRequerente(String nomeRequerente) {
        this.nomeRequerente = nomeRequerente;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setContribuinte(Pessoa contribuinte) {
        this.contribuinte = contribuinte;
    }

    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setTipoFiltro(TipoFiltroAtendimento tipoFiltro) {
        this.tipoFiltro = tipoFiltro;
    }

    @Generated
    public String toString() {
        return "Atendimento(id=" + this.getId() + ", tipoAtendimento=" + this.getTipoAtendimento() + ", atendenteCpfCnpj=" + this.getAtendenteCpfCnpj() + ", horarioInicio=" + this.getHorarioInicio() + ", horarioFim=" + this.getHorarioFim() + ", cpfCnpjRequerente=" + this.getCpfCnpjRequerente() + ", nomeRequerente=" + this.getNomeRequerente() + ", observacao=" + this.getObservacao() + ", contribuinte=" + this.getContribuinte() + ", cadastroGeral=" + this.getCadastroGeral() + ", tipoFiltro=" + this.getTipoFiltro() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Atendimento)) {
            return false;
        }
        Atendimento other = (Atendimento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Atendimento;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

