/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.acrescimo;

import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.acrescimo.IndiceCompostoId;
import br.com.elotech.tributos.domain.acrescimo.IndiceCorrecao;
import br.com.elotech.tributos.domain.acrescimo.PeriodoCorrecao;
import br.com.elotech.tributos.domain.acrescimo.TipoCorrecao;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="indicecomposto")
public class IndiceComposto
implements Serializable {
    @EmbeddedId
    private IndiceCompostoId id;
    @Column(name="datainicial")
    private LocalDate dataInicial;
    @Column(name="datafinal")
    private LocalDate dataFinal;
    @Column(name="sobreporperiodo")
    private Boolean sobreporPeriodo;

    @JsonIgnore
    public IndiceCorrecao getIndiceCorrecao() {
        return Optional.ofNullable(this.id).map(IndiceCompostoId::getIndiceCorrecao).orElse(null);
    }

    public void setIndiceCorrecao(IndiceCorrecao indiceCorrecao) {
        if (Objects.isNull(this.id)) {
            this.id = new IndiceCompostoId();
        }
        this.id.setIndiceCorrecao(indiceCorrecao);
    }

    @JsonIgnore
    public FormaCorrecao getFormaCorrecao() {
        return Optional.ofNullable(this.id).map(IndiceCompostoId::getFormaCorrecao).orElse(null);
    }

    public void setFormaCorrecao(FormaCorrecao formaCorrecao) {
        if (Objects.isNull(this.id)) {
            this.id = new IndiceCompostoId();
        }
        this.id.setFormaCorrecao(formaCorrecao);
    }

    public Boolean utilizaDataAlternativaIndiceMensal() {
        return TipoCorrecao.INDICE_MENSAL_ACUMULADO.equals((Object)this.getFormaCorrecao().getTipoCorrecao()) && PeriodoCorrecao.MENSAL.equals((Object)this.getIndiceCorrecao().getPeriodoCorrecao());
    }

    public void set(IndiceComposto indice) {
        Optional.ofNullable(indice.getId()).ifPresent(arg_0 -> this.setId(arg_0));
        Optional.ofNullable(indice.getDataInicial()).ifPresent(arg_0 -> this.setDataInicial(arg_0));
        Optional.ofNullable(indice.getDataFinal()).ifPresent(arg_0 -> this.setDataFinal(arg_0));
        Optional.ofNullable(indice.getFormaCorrecao()).ifPresent(arg_0 -> this.setFormaCorrecao(arg_0));
        Optional.ofNullable(indice.getIndiceCorrecao()).ifPresent(arg_0 -> this.setIndiceCorrecao(arg_0));
        Optional.ofNullable(indice.getSobreporPeriodo()).ifPresent(arg_0 -> this.setSobreporPeriodo(arg_0));
    }

    @Generated
    public IndiceComposto() {
    }

    @Generated
    public IndiceCompostoId getId() {
        return this.id;
    }

    @Generated
    public LocalDate getDataInicial() {
        return this.dataInicial;
    }

    @Generated
    public LocalDate getDataFinal() {
        return this.dataFinal;
    }

    @Generated
    public Boolean getSobreporPeriodo() {
        return this.sobreporPeriodo;
    }

    @Generated
    public void setId(IndiceCompostoId id) {
        this.id = id;
    }

    @Generated
    public void setDataInicial(LocalDate dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Generated
    public void setDataFinal(LocalDate dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Generated
    public void setSobreporPeriodo(Boolean sobreporPeriodo) {
        this.sobreporPeriodo = sobreporPeriodo;
    }

    @Generated
    public String toString() {
        return "IndiceComposto(id=" + this.getId() + ", dataInicial=" + this.getDataInicial() + ", dataFinal=" + this.getDataFinal() + ", sobreporPeriodo=" + this.getSobreporPeriodo() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndiceComposto)) {
            return false;
        }
        IndiceComposto other = (IndiceComposto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        IndiceCompostoId this$id = this.getId();
        IndiceCompostoId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IndiceComposto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IndiceCompostoId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

