/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.PagNegDebOrigemId;
import br.com.elotech.tributos.domain.PagamentoNegociado;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.StatusPagamentoNegociado;
import br.com.elotech.tributos.enums.OperacoesPagamentoNegociado;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="TRIBPGTONEGOCIADODEBITOORIGEM")
public class PagamentoNegociadoDebOrigem
implements EloEntity<PagNegDebOrigemId>,
Serializable {
    @EmbeddedId
    private PagNegDebOrigemId id;
    @MapsId(value="idpgtonegociado")
    @JoinColumn(name="idpgtonegociado")
    @ManyToOne(fetch=FetchType.LAZY)
    @JsonIgnore
    @MetaModelIgnore
    private PagamentoNegociado pagamentoNegociado;
    private LocalDate dataVencimento;
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal juros = BigDecimal.ZERO;
    private BigDecimal multa = BigDecimal.ZERO;
    private BigDecimal correcao = BigDecimal.ZERO;
    private String operacao;
    private Boolean reparcelado;
    @ManyToOne(fetch=FetchType.LAZY)
    @JsonIgnore
    @MetaModelIgnore
    @JoinColumn(name="idparcelamento")
    private Parcelamento parcelamento;
    private BigDecimal totalDebito = BigDecimal.ZERO;
    private BigDecimal valorTotal = BigDecimal.ZERO;

    public void setParcela(DebitoParcela parcela) {
        this.id.setDebitoParcela(parcela);
    }

    public static PagamentoNegociadoDebOrigem from(DebitoPagamentoNegociadoDTO debito) {
        PagNegDebOrigemId pagNegDebOrigemId = new PagNegDebOrigemId();
        PagamentoNegociadoDebOrigem debOrigem = new PagamentoNegociadoDebOrigem();
        debOrigem.setId(pagNegDebOrigemId);
        debOrigem.setCorrecao(debito.getValorCorrecao());
        debOrigem.setDataVencimento(debito.getDataVencimento());
        debOrigem.setJuros(debito.getValorJuros());
        debOrigem.setMulta(debito.getValorMulta());
        debOrigem.setReparcelado(debito.getReparcelado());
        debOrigem.setValor(debito.getValorPrincipal());
        debOrigem.setValorTotal(debito.getValorPrincipal().add(debito.getValorAcrescimos()));
        if (Objects.nonNull(debito.getIdParcelamento())) {
            Parcelamento parcelamento = new Parcelamento();
            parcelamento.setId(debito.getIdParcelamento());
            debOrigem.setParcelamento(parcelamento);
        }
        if (StatusPagamentoNegociado.PARCIAL.equals((Object)debito.getStatus())) {
            debOrigem.setTotalDebito(debito.getValorAbatido());
            debOrigem.setOperacao(OperacoesPagamentoNegociado.DIVIDIR_DEBITO.getTipo());
        } else {
            debOrigem.setTotalDebito(BigDecimal.ZERO);
            debOrigem.setOperacao(OperacoesPagamentoNegociado.BAIXAR_DEBITO.getTipo());
        }
        return debOrigem;
    }

    public boolean isParcialmenteBaixado() {
        return OperacoesPagamentoNegociado.DIVIDIR_DEBITO.getTipo().equals(this.operacao);
    }

    public boolean isTotalmenteBaixado() {
        return OperacoesPagamentoNegociado.BAIXAR_DEBITO.getTipo().equals(this.operacao);
    }

    @Generated
    public PagamentoNegociadoDebOrigem() {
    }

    @Generated
    public PagNegDebOrigemId getId() {
        return this.id;
    }

    @Generated
    public PagamentoNegociado getPagamentoNegociado() {
        return this.pagamentoNegociado;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getJuros() {
        return this.juros;
    }

    @Generated
    public BigDecimal getMulta() {
        return this.multa;
    }

    @Generated
    public BigDecimal getCorrecao() {
        return this.correcao;
    }

    @Generated
    public String getOperacao() {
        return this.operacao;
    }

    @Generated
    public Boolean getReparcelado() {
        return this.reparcelado;
    }

    @Generated
    public Parcelamento getParcelamento() {
        return this.parcelamento;
    }

    @Generated
    public BigDecimal getTotalDebito() {
        return this.totalDebito;
    }

    @Generated
    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public void setId(PagNegDebOrigemId id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setPagamentoNegociado(PagamentoNegociado pagamentoNegociado) {
        this.pagamentoNegociado = pagamentoNegociado;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setJuros(BigDecimal juros) {
        this.juros = juros;
    }

    @Generated
    public void setMulta(BigDecimal multa) {
        this.multa = multa;
    }

    @Generated
    public void setCorrecao(BigDecimal correcao) {
        this.correcao = correcao;
    }

    @Generated
    public void setOperacao(String operacao) {
        this.operacao = operacao;
    }

    @Generated
    public void setReparcelado(Boolean reparcelado) {
        this.reparcelado = reparcelado;
    }

    @JsonIgnore
    @Generated
    public void setParcelamento(Parcelamento parcelamento) {
        this.parcelamento = parcelamento;
    }

    @Generated
    public void setTotalDebito(BigDecimal totalDebito) {
        this.totalDebito = totalDebito;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoNegociadoDebOrigem)) {
            return false;
        }
        PagamentoNegociadoDebOrigem other = (PagamentoNegociadoDebOrigem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$reparcelado = this.getReparcelado();
        Boolean other$reparcelado = other.getReparcelado();
        if (this$reparcelado == null ? other$reparcelado != null : !((Object)this$reparcelado).equals(other$reparcelado)) {
            return false;
        }
        PagNegDebOrigemId this$id = this.getId();
        PagNegDebOrigemId other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        PagamentoNegociado this$pagamentoNegociado = this.getPagamentoNegociado();
        PagamentoNegociado other$pagamentoNegociado = other.getPagamentoNegociado();
        if (this$pagamentoNegociado == null ? other$pagamentoNegociado != null : !this$pagamentoNegociado.equals(other$pagamentoNegociado)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$juros = this.getJuros();
        BigDecimal other$juros = other.getJuros();
        if (this$juros == null ? other$juros != null : !((Object)this$juros).equals(other$juros)) {
            return false;
        }
        BigDecimal this$multa = this.getMulta();
        BigDecimal other$multa = other.getMulta();
        if (this$multa == null ? other$multa != null : !((Object)this$multa).equals(other$multa)) {
            return false;
        }
        BigDecimal this$correcao = this.getCorrecao();
        BigDecimal other$correcao = other.getCorrecao();
        if (this$correcao == null ? other$correcao != null : !((Object)this$correcao).equals(other$correcao)) {
            return false;
        }
        String this$operacao = this.getOperacao();
        String other$operacao = other.getOperacao();
        if (this$operacao == null ? other$operacao != null : !this$operacao.equals(other$operacao)) {
            return false;
        }
        Parcelamento this$parcelamento = this.getParcelamento();
        Parcelamento other$parcelamento = other.getParcelamento();
        if (this$parcelamento == null ? other$parcelamento != null : !this$parcelamento.equals(other$parcelamento)) {
            return false;
        }
        BigDecimal this$totalDebito = this.getTotalDebito();
        BigDecimal other$totalDebito = other.getTotalDebito();
        if (this$totalDebito == null ? other$totalDebito != null : !((Object)this$totalDebito).equals(other$totalDebito)) {
            return false;
        }
        BigDecimal this$valorTotal = this.getValorTotal();
        BigDecimal other$valorTotal = other.getValorTotal();
        return !(this$valorTotal == null ? other$valorTotal != null : !((Object)this$valorTotal).equals(other$valorTotal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoNegociadoDebOrigem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $reparcelado = this.getReparcelado();
        result = result * 59 + ($reparcelado == null ? 43 : ((Object)$reparcelado).hashCode());
        PagNegDebOrigemId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        PagamentoNegociado $pagamentoNegociado = this.getPagamentoNegociado();
        result = result * 59 + ($pagamentoNegociado == null ? 43 : $pagamentoNegociado.hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $juros = this.getJuros();
        result = result * 59 + ($juros == null ? 43 : ((Object)$juros).hashCode());
        BigDecimal $multa = this.getMulta();
        result = result * 59 + ($multa == null ? 43 : ((Object)$multa).hashCode());
        BigDecimal $correcao = this.getCorrecao();
        result = result * 59 + ($correcao == null ? 43 : ((Object)$correcao).hashCode());
        String $operacao = this.getOperacao();
        result = result * 59 + ($operacao == null ? 43 : $operacao.hashCode());
        Parcelamento $parcelamento = this.getParcelamento();
        result = result * 59 + ($parcelamento == null ? 43 : $parcelamento.hashCode());
        BigDecimal $totalDebito = this.getTotalDebito();
        result = result * 59 + ($totalDebito == null ? 43 : ((Object)$totalDebito).hashCode());
        BigDecimal $valorTotal = this.getValorTotal();
        result = result * 59 + ($valorTotal == null ? 43 : ((Object)$valorTotal).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PagamentoNegociadoDebOrigem(id=" + this.getId() + ", pagamentoNegociado=" + this.getPagamentoNegociado() + ", dataVencimento=" + this.getDataVencimento() + ", valor=" + this.getValor() + ", juros=" + this.getJuros() + ", multa=" + this.getMulta() + ", correcao=" + this.getCorrecao() + ", operacao=" + this.getOperacao() + ", reparcelado=" + this.getReparcelado() + ", parcelamento=" + this.getParcelamento() + ", totalDebito=" + this.getTotalDebito() + ", valorTotal=" + this.getValorTotal() + ")";
    }
}

