/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.PagamentoDebitoId;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.enums.SituacaoPagamentoDebitoEnum;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="TRIBPAGAMENTODEBITO")
public class PagamentoDebito
implements EloEntity<PagamentoDebitoId> {
    @EmbeddedId
    private PagamentoDebitoId id;
    private BigDecimal valorCalculado = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorPrincipal = BigDecimal.ZERO;
    private BigDecimal valorDesconto = BigDecimal.ZERO;
    private BigDecimal valorPago = BigDecimal.ZERO;
    private Boolean estorno = Boolean.FALSE;
    @Enumerated(value=EnumType.STRING)
    private SituacaoPagamentoDebitoEnum situacao = SituacaoPagamentoDebitoEnum.NORMAL;
    private BigDecimal valorPagoMaior = BigDecimal.ZERO;
    private SituacaoLegal situacaoLegal;
    private LocalDate dataEstorno;
    private BigDecimal valorDevolvido = BigDecimal.ZERO;
    private Boolean devolvido = Boolean.FALSE;
    private BigDecimal valorPagoMenor = BigDecimal.ZERO;
    private BigDecimal tempValorPago = BigDecimal.ZERO;
    private BigDecimal valorDescontoAux = BigDecimal.ZERO;
    private BigDecimal valorAux = BigDecimal.ZERO;
    private BigDecimal valorAtualizacao = BigDecimal.ZERO;
    private BigDecimal valorDescontoPrincipal = BigDecimal.ZERO;
    private BigDecimal valorDescontoJuros = BigDecimal.ZERO;
    private BigDecimal valorDescontoMulta = BigDecimal.ZERO;
    private BigDecimal valorDescontoCorrecao = BigDecimal.ZERO;
    @Column(name="valorDescontoJurosFinan")
    private BigDecimal valorDescontoJurosFinanciamento = BigDecimal.ZERO;

    public BigDecimal getValorTotalDesconto() {
        return this.getValorDescontoPrincipal().add(this.getValorDescontoJuros()).add(this.getValorDescontoMulta()).add(this.getValorDescontoCorrecao());
    }

    public BigDecimal getValorTotal() {
        return this.getValorPrincipal().add(this.getValorCorrecao()).add(this.getValorJuros()).add(this.getValorMulta()).subtract(this.getValorTotalDesconto());
    }

    public BigDecimal getValorPrincipalComDesconto() {
        return this.valorPrincipal.subtract(this.valorDescontoPrincipal);
    }

    public BigDecimal getValorMultaComDesconto() {
        return this.valorMulta.subtract(this.valorDescontoMulta);
    }

    public BigDecimal getValorJurosComDesconto() {
        return this.valorJuros.subtract(this.valorDescontoJuros);
    }

    public BigDecimal getValorCorrecaoComDesconto() {
        return this.valorCorrecao.subtract(this.valorDescontoCorrecao);
    }

    public static PagamentoDebito from(BoletoDebito boletoDebito, Long idPagamentoBoleto) {
        PagamentoDebitoId pagamentoDebitoId = new PagamentoDebitoId();
        pagamentoDebitoId.setDebitoParcelaTributo(boletoDebito.getId().getDebitoParcelaTributo());
        pagamentoDebitoId.setIdPagamentoBoleto(idPagamentoBoleto);
        PagamentoDebito pagamentoDebito = new PagamentoDebito();
        pagamentoDebito.setId(pagamentoDebitoId);
        pagamentoDebito.setValorPrincipal(boletoDebito.getValorPrincipalAcrescimo());
        pagamentoDebito.setValorJuros(boletoDebito.getValorJurosAcrescimo());
        pagamentoDebito.setValorMulta(boletoDebito.getValorMultaAcrescimo());
        pagamentoDebito.setValorCorrecao(boletoDebito.getValorCorrecaoAcrescimo());
        pagamentoDebito.setValorCalculado(boletoDebito.getValorTotalComAcrescimos());
        pagamentoDebito.setValorPago(boletoDebito.getValorTotalComAcrescimos());
        pagamentoDebito.setValorDesconto(boletoDebito.getValorDesconto());
        pagamentoDebito.setValorDescontoPrincipal(boletoDebito.getValorDescontoPrincipal());
        pagamentoDebito.setValorDescontoJuros(boletoDebito.getValorDescontoJuros());
        pagamentoDebito.setValorDescontoMulta(boletoDebito.getValorDescontoMulta());
        pagamentoDebito.setValorDescontoCorrecao(boletoDebito.getValorDescontoCorrecao());
        pagamentoDebito.setSituacaoLegal(boletoDebito.getId().getDebitoParcelaTributo().getDebitoParcela().getSituacaoLegal());
        return pagamentoDebito;
    }

    public void zeraAcrescimosEDescontos() {
        this.valorJuros = BigDecimal.ZERO;
        this.valorMulta = BigDecimal.ZERO;
        this.valorCorrecao = BigDecimal.ZERO;
        this.valorDesconto = BigDecimal.ZERO;
        this.valorDescontoPrincipal = BigDecimal.ZERO;
        this.valorDescontoJuros = BigDecimal.ZERO;
        this.valorDescontoMulta = BigDecimal.ZERO;
        this.valorDescontoCorrecao = BigDecimal.ZERO;
    }

    @Generated
    public PagamentoDebito() {
    }

    @Generated
    public PagamentoDebitoId getId() {
        return this.id;
    }

    @Generated
    public BigDecimal getValorCalculado() {
        return this.valorCalculado;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorPrincipal() {
        return this.valorPrincipal;
    }

    @Generated
    public BigDecimal getValorDesconto() {
        return this.valorDesconto;
    }

    @Generated
    public BigDecimal getValorPago() {
        return this.valorPago;
    }

    @Generated
    public Boolean getEstorno() {
        return this.estorno;
    }

    @Generated
    public SituacaoPagamentoDebitoEnum getSituacao() {
        return this.situacao;
    }

    @Generated
    public BigDecimal getValorPagoMaior() {
        return this.valorPagoMaior;
    }

    @Generated
    public SituacaoLegal getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public LocalDate getDataEstorno() {
        return this.dataEstorno;
    }

    @Generated
    public BigDecimal getValorDevolvido() {
        return this.valorDevolvido;
    }

    @Generated
    public Boolean getDevolvido() {
        return this.devolvido;
    }

    @Generated
    public BigDecimal getValorPagoMenor() {
        return this.valorPagoMenor;
    }

    @Generated
    public BigDecimal getTempValorPago() {
        return this.tempValorPago;
    }

    @Generated
    public BigDecimal getValorDescontoAux() {
        return this.valorDescontoAux;
    }

    @Generated
    public BigDecimal getValorAux() {
        return this.valorAux;
    }

    @Generated
    public BigDecimal getValorAtualizacao() {
        return this.valorAtualizacao;
    }

    @Generated
    public BigDecimal getValorDescontoPrincipal() {
        return this.valorDescontoPrincipal;
    }

    @Generated
    public BigDecimal getValorDescontoJuros() {
        return this.valorDescontoJuros;
    }

    @Generated
    public BigDecimal getValorDescontoMulta() {
        return this.valorDescontoMulta;
    }

    @Generated
    public BigDecimal getValorDescontoCorrecao() {
        return this.valorDescontoCorrecao;
    }

    @Generated
    public BigDecimal getValorDescontoJurosFinanciamento() {
        return this.valorDescontoJurosFinanciamento;
    }

    @Generated
    public void setId(PagamentoDebitoId id) {
        this.id = id;
    }

    @Generated
    public void setValorCalculado(BigDecimal valorCalculado) {
        this.valorCalculado = valorCalculado;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorPrincipal(BigDecimal valorPrincipal) {
        this.valorPrincipal = valorPrincipal;
    }

    @Generated
    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Generated
    public void setValorPago(BigDecimal valorPago) {
        this.valorPago = valorPago;
    }

    @Generated
    public void setEstorno(Boolean estorno) {
        this.estorno = estorno;
    }

    @Generated
    public void setSituacao(SituacaoPagamentoDebitoEnum situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setValorPagoMaior(BigDecimal valorPagoMaior) {
        this.valorPagoMaior = valorPagoMaior;
    }

    @Generated
    public void setSituacaoLegal(SituacaoLegal situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setDataEstorno(LocalDate dataEstorno) {
        this.dataEstorno = dataEstorno;
    }

    @Generated
    public void setValorDevolvido(BigDecimal valorDevolvido) {
        this.valorDevolvido = valorDevolvido;
    }

    @Generated
    public void setDevolvido(Boolean devolvido) {
        this.devolvido = devolvido;
    }

    @Generated
    public void setValorPagoMenor(BigDecimal valorPagoMenor) {
        this.valorPagoMenor = valorPagoMenor;
    }

    @Generated
    public void setTempValorPago(BigDecimal tempValorPago) {
        this.tempValorPago = tempValorPago;
    }

    @Generated
    public void setValorDescontoAux(BigDecimal valorDescontoAux) {
        this.valorDescontoAux = valorDescontoAux;
    }

    @Generated
    public void setValorAux(BigDecimal valorAux) {
        this.valorAux = valorAux;
    }

    @Generated
    public void setValorAtualizacao(BigDecimal valorAtualizacao) {
        this.valorAtualizacao = valorAtualizacao;
    }

    @Generated
    public void setValorDescontoPrincipal(BigDecimal valorDescontoPrincipal) {
        this.valorDescontoPrincipal = valorDescontoPrincipal;
    }

    @Generated
    public void setValorDescontoJuros(BigDecimal valorDescontoJuros) {
        this.valorDescontoJuros = valorDescontoJuros;
    }

    @Generated
    public void setValorDescontoMulta(BigDecimal valorDescontoMulta) {
        this.valorDescontoMulta = valorDescontoMulta;
    }

    @Generated
    public void setValorDescontoCorrecao(BigDecimal valorDescontoCorrecao) {
        this.valorDescontoCorrecao = valorDescontoCorrecao;
    }

    @Generated
    public void setValorDescontoJurosFinanciamento(BigDecimal valorDescontoJurosFinanciamento) {
        this.valorDescontoJurosFinanciamento = valorDescontoJurosFinanciamento;
    }

    @Generated
    public String toString() {
        return "PagamentoDebito(id=" + this.getId() + ", valorCalculado=" + this.getValorCalculado() + ", valorJuros=" + this.getValorJuros() + ", valorMulta=" + this.getValorMulta() + ", valorCorrecao=" + this.getValorCorrecao() + ", valorPrincipal=" + this.getValorPrincipal() + ", valorDesconto=" + this.getValorDesconto() + ", valorPago=" + this.getValorPago() + ", estorno=" + this.getEstorno() + ", situacao=" + this.getSituacao() + ", valorPagoMaior=" + this.getValorPagoMaior() + ", situacaoLegal=" + this.getSituacaoLegal() + ", dataEstorno=" + this.getDataEstorno() + ", valorDevolvido=" + this.getValorDevolvido() + ", devolvido=" + this.getDevolvido() + ", valorPagoMenor=" + this.getValorPagoMenor() + ", tempValorPago=" + this.getTempValorPago() + ", valorDescontoAux=" + this.getValorDescontoAux() + ", valorAux=" + this.getValorAux() + ", valorAtualizacao=" + this.getValorAtualizacao() + ", valorDescontoPrincipal=" + this.getValorDescontoPrincipal() + ", valorDescontoJuros=" + this.getValorDescontoJuros() + ", valorDescontoMulta=" + this.getValorDescontoMulta() + ", valorDescontoCorrecao=" + this.getValorDescontoCorrecao() + ", valorDescontoJurosFinanciamento=" + this.getValorDescontoJurosFinanciamento() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoDebito)) {
            return false;
        }
        PagamentoDebito other = (PagamentoDebito)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PagamentoDebitoId this$id = this.getId();
        PagamentoDebitoId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoDebito;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PagamentoDebitoId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

