/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaObservacaoId;
import br.com.elotech.tributos.security.SecurityUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.LocalDate;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="tribdebitoparcelaobservacao")
public class DebitoParcelaObservacao
implements EloEntity<DebitoParcelaObservacaoId>,
Serializable {
    @EmbeddedId
    private DebitoParcelaObservacaoId id;
    @Length(max=2000, message="Tamanho m\u00e1ximo da observa\u00e7\u00e3o \u00e9 de 2000 na Debito Parcela Observa\u00e7\u00e3o")
    private @Length(max=2000, message="Tamanho m\u00e1ximo da observa\u00e7\u00e3o \u00e9 de 2000 na Debito Parcela Observa\u00e7\u00e3o") String observacao;
    private LocalDate dataInclusao;
    private String usuario;
    @MapsId(value="entidade,exercicio,divida,tipocadastro,cadastrogeral,subdivida,parcela")
    @MetaModelIgnore
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade"), @JoinColumn(name="exercicio", referencedColumnName="exercicio"), @JoinColumn(name="tipocadastro", referencedColumnName="tipoCadastro"), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastroGeral"), @JoinColumn(name="guiarecolhimento", referencedColumnName="guiarecolhimento"), @JoinColumn(name="subdivida", referencedColumnName="subdivida"), @JoinColumn(name="parcela", referencedColumnName="parcela")})
    private DebitoParcela debitoParcela;

    public static DebitoParcelaObservacao from(DebitoParcela debitoParcela, String observacao) {
        return DebitoParcelaObservacao.from((DebitoParcela)debitoParcela, (String)observacao, (String)SecurityUtils.getUserAise());
    }

    public static DebitoParcelaObservacao from(DebitoParcela debitoParcela, String observacao, String usuario) {
        DebitoParcelaObservacao debitoParcelaObservacao = new DebitoParcelaObservacao();
        debitoParcelaObservacao.setId(DebitoParcelaObservacaoId.create((DebitoParcela)debitoParcela));
        debitoParcelaObservacao.setObservacao(observacao);
        debitoParcelaObservacao.setUsuario(usuario);
        debitoParcelaObservacao.setDataInclusao(LocalDate.now());
        debitoParcelaObservacao.setDebitoParcela(debitoParcela);
        return debitoParcelaObservacao;
    }

    @Generated
    public DebitoParcelaObservacao() {
    }

    @Generated
    public DebitoParcelaObservacaoId getId() {
        return this.id;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public DebitoParcela getDebitoParcela() {
        return this.debitoParcela;
    }

    @Generated
    public void setId(DebitoParcelaObservacaoId id) {
        this.id = id;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @JsonIgnore
    @Generated
    public void setDebitoParcela(DebitoParcela debitoParcela) {
        this.debitoParcela = debitoParcela;
    }

    @Generated
    public String toString() {
        return "DebitoParcelaObservacao(id=" + this.getId() + ", observacao=" + this.getObservacao() + ", dataInclusao=" + this.getDataInclusao() + ", usuario=" + this.getUsuario() + ", debitoParcela=" + this.getDebitoParcela() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoParcelaObservacao)) {
            return false;
        }
        DebitoParcelaObservacao other = (DebitoParcelaObservacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DebitoParcelaObservacaoId this$id = this.getId();
        DebitoParcelaObservacaoId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoParcelaObservacao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DebitoParcelaObservacaoId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

