/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoObservacaoId;
import br.com.elotech.tributos.security.SecurityUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.LocalDate;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="tribdebitoobservacao")
public class DebitoObservacao
implements EloEntity<DebitoObservacaoId>,
Serializable {
    @EmbeddedId
    private DebitoObservacaoId id;
    @NotNull
    @Length(max=2000, message="Tamanho m\u00e1ximo da observa\u00e7\u00e3o \u00e9 de 2000")
    private @NotNull @Length(max=2000, message="Tamanho m\u00e1ximo da observa\u00e7\u00e3o \u00e9 de 2000") String observacao;
    private LocalDate dataInclusao;
    @Length(max=15, message="Tamanho m\u00e1ximo de usu\u00e1rio \u00e9 de 15")
    private @Length(max=15, message="Tamanho m\u00e1ximo de usu\u00e1rio \u00e9 de 15") String usuario;
    @MapsId(value="entidade,exercicio,divida,tipocadastro,cadastrogeral,subdivida")
    @MetaModelIgnore
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade"), @JoinColumn(name="exercicio", referencedColumnName="exercicio"), @JoinColumn(name="tipocadastro", referencedColumnName="tipoCadastro"), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastroGeral"), @JoinColumn(name="guiarecolhimento", referencedColumnName="guiarecolhimento"), @JoinColumn(name="subdivida", referencedColumnName="subdivida")})
    private Debito debito;

    public static DebitoObservacao from(Debito debito, String observacao) {
        DebitoObservacao debitoObservacao = new DebitoObservacao();
        debitoObservacao.setId(DebitoObservacaoId.of((Debito)debito));
        debitoObservacao.setObservacao(observacao);
        debitoObservacao.setUsuario(SecurityUtils.getUserAise());
        debitoObservacao.setDataInclusao(LocalDate.now());
        debitoObservacao.setDebito(debito);
        return debitoObservacao;
    }

    @Generated
    public DebitoObservacao() {
    }

    @Generated
    public DebitoObservacaoId getId() {
        return this.id;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Debito getDebito() {
        return this.debito;
    }

    @Generated
    public void setId(DebitoObservacaoId id) {
        this.id = id;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @JsonIgnore
    @Generated
    public void setDebito(Debito debito) {
        this.debito = debito;
    }

    @Generated
    public String toString() {
        return "DebitoObservacao(id=" + this.getId() + ", observacao=" + this.getObservacao() + ", dataInclusao=" + this.getDataInclusao() + ", usuario=" + this.getUsuario() + ", debito=" + this.getDebito() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoObservacao)) {
            return false;
        }
        DebitoObservacao other = (DebitoObservacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DebitoObservacaoId this$id = this.getId();
        DebitoObservacaoId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoObservacao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DebitoObservacaoId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

