/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.ContenciosoDebitoID;
import br.com.elotech.tributos.domain.ContenciosoDebitoParcela;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoTributo;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.SituacaoContenciosoDebito;
import br.com.elotech.tributos.domain.SituacaoContenciosoDebitoConverter;
import br.com.elotech.tributos.domain.memoria.MemoriaCadastro;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitoDTO;
import br.com.elotech.tributos.enums.SituacaoRecalculoContencioso;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="tribcontenciosodebito")
public class ContenciosoDebito
implements Serializable,
EloEntity<ContenciosoDebitoID> {
    @EmbeddedId
    private ContenciosoDebitoID id;
    @MapsId(value="entidade,exercicio,divida,tipocadastro,cadastrogeral,subdivida")
    @MetaModelIgnore
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade"), @JoinColumn(name="exercicio", referencedColumnName="exercicio"), @JoinColumn(name="tipocadastro", referencedColumnName="tipoCadastro"), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastroGeral"), @JoinColumn(name="guiarecolhimento", referencedColumnName="guiarecolhimento"), @JoinColumn(name="subdivida", referencedColumnName="subdivida")})
    private Debito debito;
    @Convert(converter=SituacaoContenciosoDebitoConverter.class)
    private SituacaoContenciosoDebito situacao;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumns(value={@JoinColumn(name="idcontencioso", referencedColumnName="idcontencioso", updatable=false), @JoinColumn(name="entidade", referencedColumnName="entidade", updatable=false), @JoinColumn(name="exercicio", referencedColumnName="exercicio", updatable=false), @JoinColumn(name="tipocadastro", referencedColumnName="tipocadastro", updatable=false), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastrogeral", updatable=false), @JoinColumn(name="guiarecolhimento", referencedColumnName="guiarecolhimento", updatable=false), @JoinColumn(name="subdivida", referencedColumnName="subdivida", updatable=false)})
    private List<ContenciosoDebitoParcela> parcelas = new ArrayList();
    @Transient
    private Boolean selecionado = false;
    @Length(max=2000)
    private @Length(max=2000) String motivoParecer;
    @Column(name="porParcelamento")
    private Boolean porParcelamento = false;
    private LocalDateTime dataRecalculo;
    @Enumerated(value=EnumType.STRING)
    private SituacaoRecalculoContencioso situacaoRecalculo;
    private BigDecimal valorRecalculo;
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="iddebitorecalculo", referencedColumnName="iddebito")
    private Debito debitoRecalculo;
    private Long idAutoInfracaoFiscal;
    @Transient
    private LocalDate dataPrimeiroVencimentoOriginal;
    private LocalDate dataPrimeiroVencimento;
    private String inconsistencias;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="idmemoriacadastro", referencedColumnName="idmemoriacadastro")
    private MemoriaCadastro memoriaCadastro;

    public Long getIdDebitoRecalculo() {
        return Optional.ofNullable(this.debitoRecalculo).map(Debito::getId).orElse(null);
    }

    @JsonProperty(value="idMemoriaCadastro")
    public Long getIdMemoriaCadastro() {
        return Optional.ofNullable(this.memoriaCadastro).map(MemoriaCadastro::getId).orElse(null);
    }

    public Long getIdDebito() {
        return Optional.ofNullable(this.debito).map(Debito::getId).orElse(0L);
    }

    public String getSituacaoDetalhada() {
        return Optional.ofNullable(this.situacao).map(SituacaoContenciosoDebito::getDescricao).orElse("");
    }

    public BigDecimal getValorTotal() {
        return Optional.ofNullable(this.debito).map(Debito::getValorTotalDebito).orElse(BigDecimal.ZERO);
    }

    public List<DebitoTributo> getTributos() {
        return Optional.ofNullable(this.debito).map(Debito::getTributos).orElse(new ArrayList());
    }

    public String getDividaDetalhada() {
        return Optional.ofNullable(this.debito).map(Debito::getDivida).map(Divida::getDescricao).orElse("");
    }

    public Boolean isSelected() {
        return this.selecionado;
    }

    public boolean equalsToDto(ContenciosoDebitoDTO dto) {
        return Objects.equals(this.getId().getIdContencioso(), dto.getId().getIdContencioso()) && Objects.equals(this.getId().getEntidade(), dto.getId().getEntidade()) && Objects.equals(this.getId().getExercicio(), dto.getId().getExercicio()) && Objects.equals(this.getId().getTipoCadastro().getValue(), dto.getId().getTipoCadastro()) && Objects.equals(this.getId().getCadastroGeral(), dto.getId().getCadastroGeral()) && Objects.equals(this.getId().getDivida(), dto.getId().getDivida()) && Objects.equals(this.getId().getSubDivida(), dto.getId().getSubDivida());
    }

    @Generated
    public ContenciosoDebito() {
    }

    @Generated
    public ContenciosoDebitoID getId() {
        return this.id;
    }

    @Generated
    public Debito getDebito() {
        return this.debito;
    }

    @Generated
    public SituacaoContenciosoDebito getSituacao() {
        return this.situacao;
    }

    @Generated
    public List<ContenciosoDebitoParcela> getParcelas() {
        return this.parcelas;
    }

    @Generated
    public Boolean getSelecionado() {
        return this.selecionado;
    }

    @Generated
    public String getMotivoParecer() {
        return this.motivoParecer;
    }

    @Generated
    public Boolean getPorParcelamento() {
        return this.porParcelamento;
    }

    @Generated
    public LocalDateTime getDataRecalculo() {
        return this.dataRecalculo;
    }

    @Generated
    public SituacaoRecalculoContencioso getSituacaoRecalculo() {
        return this.situacaoRecalculo;
    }

    @Generated
    public BigDecimal getValorRecalculo() {
        return this.valorRecalculo;
    }

    @Generated
    public Debito getDebitoRecalculo() {
        return this.debitoRecalculo;
    }

    @Generated
    public Long getIdAutoInfracaoFiscal() {
        return this.idAutoInfracaoFiscal;
    }

    @Generated
    public LocalDate getDataPrimeiroVencimentoOriginal() {
        return this.dataPrimeiroVencimentoOriginal;
    }

    @Generated
    public LocalDate getDataPrimeiroVencimento() {
        return this.dataPrimeiroVencimento;
    }

    @Generated
    public String getInconsistencias() {
        return this.inconsistencias;
    }

    @Generated
    public MemoriaCadastro getMemoriaCadastro() {
        return this.memoriaCadastro;
    }

    @Generated
    public void setId(ContenciosoDebitoID id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setDebito(Debito debito) {
        this.debito = debito;
    }

    @Generated
    public void setSituacao(SituacaoContenciosoDebito situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setParcelas(List<ContenciosoDebitoParcela> parcelas) {
        this.parcelas = parcelas;
    }

    @Generated
    public void setSelecionado(Boolean selecionado) {
        this.selecionado = selecionado;
    }

    @Generated
    public void setMotivoParecer(String motivoParecer) {
        this.motivoParecer = motivoParecer;
    }

    @Generated
    public void setPorParcelamento(Boolean porParcelamento) {
        this.porParcelamento = porParcelamento;
    }

    @Generated
    public void setDataRecalculo(LocalDateTime dataRecalculo) {
        this.dataRecalculo = dataRecalculo;
    }

    @Generated
    public void setSituacaoRecalculo(SituacaoRecalculoContencioso situacaoRecalculo) {
        this.situacaoRecalculo = situacaoRecalculo;
    }

    @Generated
    public void setValorRecalculo(BigDecimal valorRecalculo) {
        this.valorRecalculo = valorRecalculo;
    }

    @JsonIgnore
    @Generated
    public void setDebitoRecalculo(Debito debitoRecalculo) {
        this.debitoRecalculo = debitoRecalculo;
    }

    @Generated
    public void setIdAutoInfracaoFiscal(Long idAutoInfracaoFiscal) {
        this.idAutoInfracaoFiscal = idAutoInfracaoFiscal;
    }

    @Generated
    public void setDataPrimeiroVencimentoOriginal(LocalDate dataPrimeiroVencimentoOriginal) {
        this.dataPrimeiroVencimentoOriginal = dataPrimeiroVencimentoOriginal;
    }

    @Generated
    public void setDataPrimeiroVencimento(LocalDate dataPrimeiroVencimento) {
        this.dataPrimeiroVencimento = dataPrimeiroVencimento;
    }

    @Generated
    public void setInconsistencias(String inconsistencias) {
        this.inconsistencias = inconsistencias;
    }

    @JsonIgnore
    @Generated
    public void setMemoriaCadastro(MemoriaCadastro memoriaCadastro) {
        this.memoriaCadastro = memoriaCadastro;
    }

    @Generated
    public String toString() {
        return "ContenciosoDebito(id=" + this.getId() + ", debito=" + this.getDebito() + ", situacao=" + this.getSituacao() + ", parcelas=" + this.getParcelas() + ", selecionado=" + this.getSelecionado() + ", motivoParecer=" + this.getMotivoParecer() + ", porParcelamento=" + this.getPorParcelamento() + ", dataRecalculo=" + this.getDataRecalculo() + ", situacaoRecalculo=" + this.getSituacaoRecalculo() + ", valorRecalculo=" + this.getValorRecalculo() + ", debitoRecalculo=" + this.getDebitoRecalculo() + ", idAutoInfracaoFiscal=" + this.getIdAutoInfracaoFiscal() + ", dataPrimeiroVencimentoOriginal=" + this.getDataPrimeiroVencimentoOriginal() + ", dataPrimeiroVencimento=" + this.getDataPrimeiroVencimento() + ", inconsistencias=" + this.getInconsistencias() + ", memoriaCadastro=" + this.getMemoriaCadastro() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContenciosoDebito)) {
            return false;
        }
        ContenciosoDebito other = (ContenciosoDebito)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ContenciosoDebitoID this$id = this.getId();
        ContenciosoDebitoID other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContenciosoDebito;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContenciosoDebitoID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

