/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.Agencia;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.TipoPagamento;
import java.io.Serializable;
import java.time.LocalDate;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="CONTABANCARIA")
public class ContaBancaria
implements EloEntity<Long>,
Serializable {
    @Id
    @EloSequence(sequenceName="SEQ_CONTABANCARIA")
    private Long id;
    @NotNull
    private Long entidade;
    @EloSequence(sequenceName="s05contabancaria")
    private Long contaBancaria;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="banco", referencedColumnName="banco"), @JoinColumn(name="agencia", referencedColumnName="agencia")})
    private Agencia agencia;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="banco", referencedColumnName="banco", insertable=false, updatable=false)
    private Banco banco;
    @Length(max=15)
    private @Length(max=15) String conta;
    @Length(max=10)
    private @Length(max=10) String convenio;
    private Long diasRepasse;
    private TipoPagamento tipoPagamento;
    @ManyToOne(fetch=FetchType.LAZY)
    private FormaPagamento formaPagamento;
    private LocalDate dataAbertura;
    private LocalDate dataEncerramento;
    @Length(max=50)
    private @Length(max=50) String descricao;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean contaArrecadacao;
    private Long localContabil;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean integraArrecadacao;
    @Length(max=20)
    private @Length(max=20) String ordemBancaria;

    @Generated
    public ContaBancaria() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public Agencia getAgencia() {
        return this.agencia;
    }

    @Generated
    public Banco getBanco() {
        return this.banco;
    }

    @Generated
    public String getConta() {
        return this.conta;
    }

    @Generated
    public String getConvenio() {
        return this.convenio;
    }

    @Generated
    public Long getDiasRepasse() {
        return this.diasRepasse;
    }

    @Generated
    public TipoPagamento getTipoPagamento() {
        return this.tipoPagamento;
    }

    @Generated
    public FormaPagamento getFormaPagamento() {
        return this.formaPagamento;
    }

    @Generated
    public LocalDate getDataAbertura() {
        return this.dataAbertura;
    }

    @Generated
    public LocalDate getDataEncerramento() {
        return this.dataEncerramento;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Boolean getContaArrecadacao() {
        return this.contaArrecadacao;
    }

    @Generated
    public Long getLocalContabil() {
        return this.localContabil;
    }

    @Generated
    public Boolean getIntegraArrecadacao() {
        return this.integraArrecadacao;
    }

    @Generated
    public String getOrdemBancaria() {
        return this.ordemBancaria;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setContaBancaria(Long contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public void setAgencia(Agencia agencia) {
        this.agencia = agencia;
    }

    @Generated
    public void setBanco(Banco banco) {
        this.banco = banco;
    }

    @Generated
    public void setConta(String conta) {
        this.conta = conta;
    }

    @Generated
    public void setConvenio(String convenio) {
        this.convenio = convenio;
    }

    @Generated
    public void setDiasRepasse(Long diasRepasse) {
        this.diasRepasse = diasRepasse;
    }

    @Generated
    public void setTipoPagamento(TipoPagamento tipoPagamento) {
        this.tipoPagamento = tipoPagamento;
    }

    @Generated
    public void setFormaPagamento(FormaPagamento formaPagamento) {
        this.formaPagamento = formaPagamento;
    }

    @Generated
    public void setDataAbertura(LocalDate dataAbertura) {
        this.dataAbertura = dataAbertura;
    }

    @Generated
    public void setDataEncerramento(LocalDate dataEncerramento) {
        this.dataEncerramento = dataEncerramento;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setContaArrecadacao(Boolean contaArrecadacao) {
        this.contaArrecadacao = contaArrecadacao;
    }

    @Generated
    public void setLocalContabil(Long localContabil) {
        this.localContabil = localContabil;
    }

    @Generated
    public void setIntegraArrecadacao(Boolean integraArrecadacao) {
        this.integraArrecadacao = integraArrecadacao;
    }

    @Generated
    public void setOrdemBancaria(String ordemBancaria) {
        this.ordemBancaria = ordemBancaria;
    }

    @Generated
    public String toString() {
        return "ContaBancaria(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", contaBancaria=" + this.getContaBancaria() + ", agencia=" + this.getAgencia() + ", banco=" + this.getBanco() + ", conta=" + this.getConta() + ", convenio=" + this.getConvenio() + ", diasRepasse=" + this.getDiasRepasse() + ", tipoPagamento=" + this.getTipoPagamento() + ", formaPagamento=" + this.getFormaPagamento() + ", dataAbertura=" + this.getDataAbertura() + ", dataEncerramento=" + this.getDataEncerramento() + ", descricao=" + this.getDescricao() + ", contaArrecadacao=" + this.getContaArrecadacao() + ", localContabil=" + this.getLocalContabil() + ", integraArrecadacao=" + this.getIntegraArrecadacao() + ", ordemBancaria=" + this.getOrdemBancaria() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContaBancaria)) {
            return false;
        }
        ContaBancaria other = (ContaBancaria)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContaBancaria;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

