/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.web.advice.JsonFilterFields;
import br.com.elotech.tributos.domain.CertificadoRaw;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

@Entity
@JsonFilterFields(of={"id", "cnpj", "certificadoRaw.file", "certificadoRaw.name", "certificadoRaw.fileNameFormated"})
@Table(name="certificado")
public class Certificado
implements EloEntity<Long> {
    @Generated
    private static final Logger log = LogManager.getLogger(Certificado.class);
    private static final Pattern CNPJ_CPF_PATERN = Pattern.compile("([0-9]{2}[\\.]?[0-9]{3}[\\.]?[0-9]{3}[\\/]?[0-9]{4}[-]?[0-9]{2})|([0-9]{3}[\\.]?[0-9]{3}[\\.]?[0-9]{3}[-]?[0-9]{2})");
    private static final String PKCS12 = "pkcs12";
    private static final String JKS = "JKS";
    @Id
    @Column(name="entidade", columnDefinition="long")
    private Long id;
    private String senha;
    private String cnpj;
    @Embedded
    @NonNull
    private CertificadoRaw certificadoRaw;
    @Transient
    @JsonIgnore
    private KeyStore keyStore;
    @Transient
    @JsonIgnore
    private X509Certificate x509Certificate;
    @Transient
    @JsonIgnore
    private Key privateKey;
    @Transient
    @JsonIgnore
    private KeyManager[] keyManagers;
    @Transient
    @JsonIgnore
    private TrustManager[] trustManagers;
    @Transient
    @JsonIgnore
    private String alias;

    public Key getPrivateKey() {
        if (this.privateKey == null) {
            try {
                this.privateKey = this.getKeyStore().getKey(this.getAlias(), this.getSenha().toCharArray());
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return this.privateKey;
    }

    public X509Certificate getX509Certificate() {
        if (this.x509Certificate == null) {
            try {
                this.x509Certificate = (X509Certificate)this.getKeyStore().getCertificate(this.getAlias());
            }
            catch (KeyStoreException e) {
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return this.x509Certificate;
    }

    public String getAlias() {
        if (this.alias == null) {
            try {
                while (this.getKeyStore().aliases().hasMoreElements() && this.alias == null) {
                    this.alias = this.getKeyStore().aliases().nextElement();
                }
            }
            catch (KeyStoreException | NoSuchElementException e) {
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return this.alias;
    }

    @JsonIgnore
    public String getCpfCnpj() throws CertificateEncodingException {
        if (Objects.nonNull(this.getX509Certificate())) {
            RDN cn = new JcaX509CertificateHolder(this.getX509Certificate()).getSubject().getRDNs(BCStyle.CN)[0];
            String cnValue = IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
            Matcher matcher = CNPJ_CPF_PATERN.matcher(cnValue);
            if (matcher.find()) {
                return matcher.group();
            }
            return this.cnpj;
        }
        return null;
    }

    public KeyStore getKeyStore() {
        block8: {
            if (this.keyStore == null) {
                try (ByteArrayInputStream keyStoreStream = new ByteArrayInputStream(this.getCertificadoRaw().getFile());){
                    this.keyStore = KeyStore.getInstance(PKCS12);
                    this.keyStore.load(keyStoreStream, Optional.ofNullable(this.getSenha()).orElse("").toCharArray());
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    if (!"keystore password was incorrect".equals(e.getMessage())) break block8;
                    throw new IllegalArgumentException("A senha do certificado est\u00e1 incorreta!", e);
                }
            }
        }
        return this.keyStore;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getSenha() {
        return this.senha;
    }

    @Generated
    public String getCnpj() {
        return this.cnpj;
    }

    @NonNull
    @Generated
    public CertificadoRaw getCertificadoRaw() {
        return this.certificadoRaw;
    }

    @Generated
    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSenha(String senha) {
        this.senha = senha;
    }

    @Generated
    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    @Generated
    public void setCertificadoRaw(@NonNull CertificadoRaw certificadoRaw) {
        if (certificadoRaw == null) {
            throw new NullPointerException("certificadoRaw is marked non-null but is null");
        }
        this.certificadoRaw = certificadoRaw;
    }

    @JsonIgnore
    @Generated
    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @JsonIgnore
    @Generated
    public void setX509Certificate(X509Certificate x509Certificate) {
        this.x509Certificate = x509Certificate;
    }

    @JsonIgnore
    @Generated
    public void setPrivateKey(Key privateKey) {
        this.privateKey = privateKey;
    }

    @JsonIgnore
    @Generated
    public void setKeyManagers(KeyManager[] keyManagers) {
        this.keyManagers = keyManagers;
    }

    @JsonIgnore
    @Generated
    public void setTrustManagers(TrustManager[] trustManagers) {
        this.trustManagers = trustManagers;
    }

    @JsonIgnore
    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Certificado)) {
            return false;
        }
        Certificado other = (Certificado)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Certificado;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

