/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.converter.MotivoDevolucaoConverter;
import br.com.elotech.tributos.converter.SituacaoCarneConverter;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.CarneBoleto;
import br.com.elotech.tributos.domain.CarneBoletoId;
import br.com.elotech.tributos.domain.CarneId;
import br.com.elotech.tributos.enums.MotivoDevolucao;
import br.com.elotech.tributos.enums.SituacaoCarne;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBCARNE")
public class Carne
implements EloEntity<CarneId>,
Serializable {
    @EmbeddedId
    private CarneId id;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long numero;
    private LocalDate data;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean retirado = Boolean.FALSE;
    private LocalDate dataRetirada;
    @Convert(converter=SituacaoCarneConverter.class)
    @Column(name="situacaonaoretirado")
    private SituacaoCarne situacaoCarne;
    private LocalDate dataSituacao;
    @Length(max=250)
    private @Length(max=250) String usuario;
    @Length(max=60)
    private @Length(max=60) String codigoBarras;
    @Length(max=250)
    private @Length(max=250) String usuarioRetirada;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean impresso = Boolean.FALSE;
    @Length(max=250)
    private @Length(max=250) String usuarioEmissao;
    @OneToMany(mappedBy="carne", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="bloqueto")
    private List<CarneBoleto> boletos = new ArrayList();
    @Convert(converter=MotivoDevolucaoConverter.class)
    private MotivoDevolucao motivoDevolucao;
    private String observacaoDevolucao;
    private String usuarioDevolucao;
    private LocalDate dataDevolucao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="tipocadastro", referencedColumnName="tipocadastro", insertable=false, updatable=false), @JoinColumn(name="cadastrogeral", referencedColumnName="cadastrogeral", insertable=false, updatable=false)})
    private CadastroGeral cadastroGeralEntity;

    public void addBoleto(Bloqueto boleto) {
        CarneBoletoId carneBoletoId = CarneBoletoId.builder().entidade(this.id.getEntidade()).exercicio(this.id.getExercicio()).carne(this.id.getCarne()).boleto(boleto.getBloqueto()).build();
        CarneBoleto carneBoleto = new CarneBoleto(carneBoletoId);
        carneBoleto.setCarne(this);
        carneBoleto.setBoleto(boleto);
        this.boletos.add(carneBoleto);
    }

    @Generated
    public Carne() {
    }

    @Generated
    public CarneId getId() {
        return this.id;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getNumero() {
        return this.numero;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public Boolean getRetirado() {
        return this.retirado;
    }

    @Generated
    public LocalDate getDataRetirada() {
        return this.dataRetirada;
    }

    @Generated
    public SituacaoCarne getSituacaoCarne() {
        return this.situacaoCarne;
    }

    @Generated
    public LocalDate getDataSituacao() {
        return this.dataSituacao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    @Generated
    public String getUsuarioRetirada() {
        return this.usuarioRetirada;
    }

    @Generated
    public Boolean getImpresso() {
        return this.impresso;
    }

    @Generated
    public String getUsuarioEmissao() {
        return this.usuarioEmissao;
    }

    @Generated
    public List<CarneBoleto> getBoletos() {
        return this.boletos;
    }

    @Generated
    public MotivoDevolucao getMotivoDevolucao() {
        return this.motivoDevolucao;
    }

    @Generated
    public String getObservacaoDevolucao() {
        return this.observacaoDevolucao;
    }

    @Generated
    public String getUsuarioDevolucao() {
        return this.usuarioDevolucao;
    }

    @Generated
    public LocalDate getDataDevolucao() {
        return this.dataDevolucao;
    }

    @Generated
    public CadastroGeral getCadastroGeralEntity() {
        return this.cadastroGeralEntity;
    }

    @Generated
    public void setId(CarneId id) {
        this.id = id;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setRetirado(Boolean retirado) {
        this.retirado = retirado;
    }

    @Generated
    public void setDataRetirada(LocalDate dataRetirada) {
        this.dataRetirada = dataRetirada;
    }

    @Generated
    public void setSituacaoCarne(SituacaoCarne situacaoCarne) {
        this.situacaoCarne = situacaoCarne;
    }

    @Generated
    public void setDataSituacao(LocalDate dataSituacao) {
        this.dataSituacao = dataSituacao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @Generated
    public void setUsuarioRetirada(String usuarioRetirada) {
        this.usuarioRetirada = usuarioRetirada;
    }

    @Generated
    public void setImpresso(Boolean impresso) {
        this.impresso = impresso;
    }

    @Generated
    public void setUsuarioEmissao(String usuarioEmissao) {
        this.usuarioEmissao = usuarioEmissao;
    }

    @Generated
    public void setBoletos(List<CarneBoleto> boletos) {
        this.boletos = boletos;
    }

    @Generated
    public void setMotivoDevolucao(MotivoDevolucao motivoDevolucao) {
        this.motivoDevolucao = motivoDevolucao;
    }

    @Generated
    public void setObservacaoDevolucao(String observacaoDevolucao) {
        this.observacaoDevolucao = observacaoDevolucao;
    }

    @Generated
    public void setUsuarioDevolucao(String usuarioDevolucao) {
        this.usuarioDevolucao = usuarioDevolucao;
    }

    @Generated
    public void setDataDevolucao(LocalDate dataDevolucao) {
        this.dataDevolucao = dataDevolucao;
    }

    @Generated
    public void setCadastroGeralEntity(CadastroGeral cadastroGeralEntity) {
        this.cadastroGeralEntity = cadastroGeralEntity;
    }

    @Generated
    public String toString() {
        return "Carne(id=" + this.getId() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", numero=" + this.getNumero() + ", data=" + this.getData() + ", retirado=" + this.getRetirado() + ", dataRetirada=" + this.getDataRetirada() + ", situacaoCarne=" + this.getSituacaoCarne() + ", dataSituacao=" + this.getDataSituacao() + ", usuario=" + this.getUsuario() + ", codigoBarras=" + this.getCodigoBarras() + ", usuarioRetirada=" + this.getUsuarioRetirada() + ", impresso=" + this.getImpresso() + ", usuarioEmissao=" + this.getUsuarioEmissao() + ", boletos=" + this.getBoletos() + ", motivoDevolucao=" + this.getMotivoDevolucao() + ", observacaoDevolucao=" + this.getObservacaoDevolucao() + ", usuarioDevolucao=" + this.getUsuarioDevolucao() + ", dataDevolucao=" + this.getDataDevolucao() + ", cadastroGeralEntity=" + this.getCadastroGeralEntity() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Carne)) {
            return false;
        }
        Carne other = (Carne)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        CarneId this$id = this.getId();
        CarneId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Carne;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CarneId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

