/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Pessoa;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.springframework.web.multipart.MultipartFile;

@Table(name="TRIBCADASTROGERALIMAGEM")
@Entity
public class CadastroGeralImagem
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="idcadastrogeralimagem")
    @EloSequence
    private Long id;
    @Column(name="idcgtipoimagem")
    private Long cgTipoImagem;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="tipoCadastro", referencedColumnName="tipoCadastro"), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastroGeral")})
    @JsonIgnore
    @MetaModelIgnore
    private CadastroGeral cadastroGeral;
    @ManyToOne
    @MetaModelIgnore
    @JsonIgnore
    private Pessoa pessoa;
    private String mimeType;
    private LocalDate dataInclusao;
    @Column(name="idtipoimagem")
    private Long tipoImagem;
    private String descricao;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean geraPortalTransparencia;
    private String tipoDocumento;
    private String numeroDocumento;
    private LocalDate dataValidade;
    private String usuario;
    private Long idCadastroGeral;

    public static CadastroGeralImagem from(MultipartFile file, CadastroGeral cadastroGeral, String usuario, Long id) {
        CadastroGeralImagem cadastroGeralImagem = new CadastroGeralImagem();
        cadastroGeralImagem.setMimeType(file.getContentType());
        cadastroGeralImagem.setDescricao(file.getOriginalFilename());
        cadastroGeralImagem.setDataInclusao(LocalDate.now());
        cadastroGeralImagem.setUsuario(usuario);
        cadastroGeralImagem.setId(id);
        cadastroGeralImagem.setCadastroGeral(cadastroGeral);
        cadastroGeralImagem.setPessoa(cadastroGeral.getPessoa());
        cadastroGeralImagem.setIdCadastroGeral(cadastroGeral.getId());
        return cadastroGeralImagem;
    }

    @Generated
    public CadastroGeralImagem() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getCgTipoImagem() {
        return this.cgTipoImagem;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public String getMimeType() {
        return this.mimeType;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public Long getTipoImagem() {
        return this.tipoImagem;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Boolean getGeraPortalTransparencia() {
        return this.geraPortalTransparencia;
    }

    @Generated
    public String getTipoDocumento() {
        return this.tipoDocumento;
    }

    @Generated
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Generated
    public LocalDate getDataValidade() {
        return this.dataValidade;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Long getIdCadastroGeral() {
        return this.idCadastroGeral;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCgTipoImagem(Long cgTipoImagem) {
        this.cgTipoImagem = cgTipoImagem;
    }

    @JsonIgnore
    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @JsonIgnore
    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setTipoImagem(Long tipoImagem) {
        this.tipoImagem = tipoImagem;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setGeraPortalTransparencia(Boolean geraPortalTransparencia) {
        this.geraPortalTransparencia = geraPortalTransparencia;
    }

    @Generated
    public void setTipoDocumento(String tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    @Generated
    public void setNumeroDocumento(String numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
    }

    @Generated
    public void setDataValidade(LocalDate dataValidade) {
        this.dataValidade = dataValidade;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setIdCadastroGeral(Long idCadastroGeral) {
        this.idCadastroGeral = idCadastroGeral;
    }

    @Generated
    public String toString() {
        return "CadastroGeralImagem(id=" + this.getId() + ", cgTipoImagem=" + this.getCgTipoImagem() + ", cadastroGeral=" + this.getCadastroGeral() + ", pessoa=" + this.getPessoa() + ", mimeType=" + this.getMimeType() + ", dataInclusao=" + this.getDataInclusao() + ", tipoImagem=" + this.getTipoImagem() + ", descricao=" + this.getDescricao() + ", geraPortalTransparencia=" + this.getGeraPortalTransparencia() + ", tipoDocumento=" + this.getTipoDocumento() + ", numeroDocumento=" + this.getNumeroDocumento() + ", dataValidade=" + this.getDataValidade() + ", usuario=" + this.getUsuario() + ", idCadastroGeral=" + this.getIdCadastroGeral() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroGeralImagem)) {
            return false;
        }
        CadastroGeralImagem other = (CadastroGeralImagem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroGeralImagem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

