/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.calculo.dto.CalculoGeracaoLoteFiltroDTO;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.AvisoCadastroDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="tribavisocadastro")
public class AvisoCadastro
implements EloEntity<Long> {
    @Id
    @Column(name="id")
    @EloSequence(sequenceName="seq_aviso_cadastro")
    private Long id;
    private TipoCadastro tipoCadastro;
    private String aviso;
    private String filtro;
    private Boolean status = true;
    private LocalDateTime dataAlteracao;
    private String usuario;
    private LocalDateTime dataCriacao;
    private String usuarioCriacao;

    public static AvisoCadastro from(AvisoCadastroDTO dto) {
        AvisoCadastro avisoCadastro = new AvisoCadastro();
        Optional.ofNullable(dto).ifPresent(d -> {
            String AND = " and ";
            String where = " and " + dto.getFiltro().stream().map(CalculoGeracaoLoteFiltroDTO::generateFiltro).collect(Collectors.joining(" and "));
            avisoCadastro.setId(d.getId());
            avisoCadastro.setTipoCadastro(d.getTipoCadastro());
            avisoCadastro.setAviso(d.getAviso());
            avisoCadastro.setStatus(d.getStatus());
            avisoCadastro.setFiltro(where);
            avisoCadastro.setDataAlteracao(LocalDateTime.now());
            avisoCadastro.setUsuario(SecurityUtils.getUserAise());
            avisoCadastro.setDataCriacao(LocalDateTime.now());
            avisoCadastro.setUsuarioCriacao(SecurityUtils.getUserAise());
        });
        return avisoCadastro;
    }

    @Generated
    public AvisoCadastro() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getAviso() {
        return this.aviso;
    }

    @Generated
    public String getFiltro() {
        return this.filtro;
    }

    @Generated
    public Boolean getStatus() {
        return this.status;
    }

    @Generated
    public LocalDateTime getDataAlteracao() {
        return this.dataAlteracao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public LocalDateTime getDataCriacao() {
        return this.dataCriacao;
    }

    @Generated
    public String getUsuarioCriacao() {
        return this.usuarioCriacao;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setAviso(String aviso) {
        this.aviso = aviso;
    }

    @Generated
    public void setFiltro(String filtro) {
        this.filtro = filtro;
    }

    @Generated
    public void setStatus(Boolean status) {
        this.status = status;
    }

    @Generated
    public void setDataAlteracao(LocalDateTime dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setDataCriacao(LocalDateTime dataCriacao) {
        this.dataCriacao = dataCriacao;
    }

    @Generated
    public void setUsuarioCriacao(String usuarioCriacao) {
        this.usuarioCriacao = usuarioCriacao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AvisoCadastro)) {
            return false;
        }
        AvisoCadastro other = (AvisoCadastro)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AvisoCadastro;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AvisoCadastro(id=" + this.getId() + ")";
    }
}

