/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.config;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.client.minio.ArquivoClientMinio;
import br.com.elotech.arquivos.properties.ArquivoStorageProperties;
import br.com.elotech.arquivos.util.LogginOutputStream;
import io.minio.MinioClient;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidPortException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;

@Configuration
@EnableConfigurationProperties(value={ArquivoStorageProperties.class})
public class TributosArquivosConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArquivoClientMinio.class);

    @Bean
    @Primary
    public ArquivoClient arquivoClientMinio(ArquivoStorageProperties properties, @Lazy MinioClient minioClient) {
        return new ArquivoClientMinio(minioClient, properties.getBucketName());
    }

    @Bean
    @Scope(value="prototype")
    @Primary
    public MinioClient minioClient(ArquivoStorageProperties properties) throws InvalidPortException, InvalidEndpointException {
        MinioClient minioClient = new MinioClient(properties.getHost(), properties.getPort().intValue(), properties.getAccessKeyId(), properties.getAccessKeySecret(), properties.getRegion(), properties.getSecure().booleanValue());
        if (Boolean.TRUE.equals(properties.getEnableLog())) {
            minioClient.traceOn((OutputStream)new LogginOutputStream(LOGGER, properties.getLogLevel()));
        }
        return minioClient;
    }

    @Bean
    @Qualifier(value="novo")
    public ArquivoClient arquivoClientMinioNovo(ArquivoStorageProperties properties, @Lazy @Qualifier(value="novo") MinioClient minioClient) {
        return new ArquivoClientMinio(minioClient, properties.getBucketName());
    }

    @Bean
    @Scope(value="prototype")
    @Qualifier(value="novo")
    public MinioClient minioClientNovo(ArquivoStorageProperties properties, @Value(value="${elotech.storage.accessKeyId-novo}") String accessKeyIdNovo, @Value(value="${elotech.storage.accessKeySecret-novo}") String accessKeySecretNovo, @Value(value="${elotech.storage.region-novo}") String regiaoS3Novo) throws InvalidPortException, InvalidEndpointException {
        MinioClient minioClient = new MinioClient(properties.getHost(), properties.getPort().intValue(), accessKeyIdNovo, accessKeySecretNovo, regiaoS3Novo, properties.getSecure().booleanValue());
        if (Boolean.TRUE.equals(properties.getEnableLog())) {
            minioClient.traceOn((OutputStream)new LogginOutputStream(LOGGER, properties.getLogLevel()));
        }
        return minioClient;
    }
}

