/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.dto.AuxiliaresCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.calculo.dto.CalculoContext;
import br.com.elotech.tributos.calculo.dto.CalculoResultadoDTO;
import br.com.elotech.tributos.calculo.dto.CampoDetalheDTO;
import br.com.elotech.tributos.calculo.dto.ImobiliarioDTO;
import br.com.elotech.tributos.calculo.dto.ImobiliarioSegmentoDTO;
import br.com.elotech.tributos.calculo.dto.ImobiliarioTestadaDTO;
import br.com.elotech.tributos.calculo.dto.ImobiliarioTestadaGenericaDTO;
import br.com.elotech.tributos.calculo.dto.ParametroTesteScriptDTO;
import br.com.elotech.tributos.calculo.dto.ProjetoDTO;
import br.com.elotech.tributos.calculo.dto.ProjetoItemDTO;
import br.com.elotech.tributos.calculo.helpers.AuxiliaresCalculoHelper;
import br.com.elotech.tributos.calculo.repository.CalculoProjetoRepository;
import br.com.elotech.tributos.calculo.service.CalculoProjetoExecucaoService;
import br.com.elotech.tributos.calculo.service.TabelaValorService;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.calculo.CalculoProjeto;
import br.com.elotech.tributos.domain.calculo.TipoCalculoConfig;
import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.domain.projeto.ProjetoPK;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.params.CalculoProjetoParams;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.camposdinamicos.GrupoCampoService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class CalculoProjetoService
extends CrudService<CalculoProjeto, Long> {
    private final TabelaValorService tabelaValorService;
    private final CalculoProjetoExecucaoService execucaoService;
    private final CalculoProjetoRepository calculoProjetoRepository;
    private final DividaService dividaService;
    private final ContextService contextService;
    private final GrupoCampoService grupoCampoService;

    public List<DebitoManualTributoDTO> geraTributosParaDebito(Long exercicio, Long codigoDivida, List<String> tributos, CalculoProjetoParams params) {
        List formulas = this.findCalculoProjetoByDividaAndExercicio(exercicio, codigoDivida);
        if (Objects.nonNull(tributos) && !tributos.isEmpty()) {
            formulas = formulas.stream().filter(formula -> tributos.contains(formula.getTributo().getTributo())).collect(Collectors.toList());
        }
        List roots = this.calcular(formulas, params, exercicio);
        return params.isPorItem() ? this.geraReceitaPorProjetoItem(roots) : this.geraReceitaPorProjeto(roots);
    }

    private List<DebitoManualTributoDTO> geraReceitaPorProjetoItem(List<CadastroCalculoRoot<ProjetoPK>> roots) {
        return roots.stream().flatMap(root -> root.getChildren().stream()).map(CadastroCalculoDTO::getResultadoCalculoProjeto).map(arg_0 -> this.geraReceita(arg_0)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<DebitoManualTributoDTO> geraReceitaPorProjeto(List<CadastroCalculoRoot<ProjetoPK>> roots) {
        return roots.stream().map(CadastroCalculoRoot::getResultadoCalculoProjeto).map(arg_0 -> this.geraReceita(arg_0)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<DebitoManualTributoDTO> geraReceita(Map<CalculoProjeto, CalculoResultadoDTO> resultados) {
        return resultados.entrySet().stream().map(entry -> {
            CalculoProjeto calculoProjeto = (CalculoProjeto)entry.getKey();
            CalculoResultadoDTO resultadoDTO = (CalculoResultadoDTO)entry.getValue();
            DebitoManualTributoDTO tributo = new DebitoManualTributoDTO();
            tributo.setTributo(calculoProjeto.getTributo().getTributo());
            tributo.setValorTributo(BigDecimal.valueOf(resultadoDTO.getValor()));
            tributo.setValorDesconto(BigDecimal.ZERO);
            tributo.setValorBaseCalculo(BigDecimal.valueOf(resultadoDTO.getValorBase()));
            return tributo;
        }).collect(Collectors.toList());
    }

    public List<CadastroCalculoRoot<ProjetoPK>> calcular(List<CalculoProjeto> calculoProjeto, CalculoProjetoParams params, Long exercicio) {
        return this.execucaoService.calcular(calculoProjeto, params, exercicio);
    }

    public CalculoCadastro testarScript(ParametroTesteScriptDTO parametroCalculoDTO) {
        return this.execucaoService.testarScript(parametroCalculoDTO);
    }

    public List<CalculoProjeto> findCalculoProjetoByDividaAndExercicio(Long exercicio, Long codigoDivida) {
        Long entidade = this.contextService.getEntidadePrincipal();
        Divida divida = this.dividaService.findByEntidadeAndExercicioAndDividaRequired(entidade, exercicio, codigoDivida);
        return this.calculoProjetoRepository.findByDividaInAndExercicio(Collections.singletonList(divida), divida.getExercicio());
    }

    protected void beforeSave(CalculoProjeto entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        Optional identificadorDuplicado = entity.getIdentificadorDuplicado();
        if (identificadorDuplicado.isPresent()) {
            throw new EloValidationException(String.format("Identificador %s est\u00e1 duplicado.", identificadorDuplicado.get()));
        }
        Long entidade = entity.getEntidade();
        Long exercicio = entity.getExercicio();
        Long divida = entity.getDivida().getDivida();
        String tributo = entity.getTributo().getTributo();
        this.calculoProjetoRepository.findByEntidadeAndExercicioAndDividaAndTributo(entidade, exercicio, divida, tributo).filter(other -> !other.getId().equals(entity.getId())).ifPresent(other -> {
            throw new EloValidationException(String.format("J\u00e1 existe um registro no exercicio %d para a divida %d e tributo %s.", exercicio, divida, tributo));
        });
        entity.getScript().forEach(linha -> linha.setCalculoProjeto(entity));
    }

    public AuxiliaresCalculoDTO getAuxiliares(Long exercicio, TipoCalculoConfig tipo) {
        List tabelaValor = this.tabelaValorService.findByExercicio(exercicio);
        AuxiliaresCalculoDTO result = new AuxiliaresCalculoDTO();
        result.setTabelasValor(AuxiliaresCalculoHelper.mapToFuncaoDetalheDTO((List)tabelaValor));
        result.setCamposFixos(this.getCampos(tipo));
        result.setFuncoes(AuxiliaresCalculoHelper.extractFuncaoDetalheDTO(CalculoContext.class));
        result.setCamposDinamicos(this.getCamposDinamicos());
        return result;
    }

    public List<CampoDetalheDTO> getCampos(TipoCalculoConfig tipo) {
        ArrayList<CampoDetalheDTO> campos = new ArrayList<CampoDetalheDTO>();
        if (TipoCalculoConfig.SEGMENTO.equals((Object)tipo)) {
            campos.addAll(AuxiliaresCalculoHelper.extractCampos(ProjetoItemDTO.class, (CampoDetalheDTO.OrigemCampoDetalhe)CampoDetalheDTO.OrigemCampoDetalhe.PROJETOITEM));
        }
        campos.addAll(AuxiliaresCalculoHelper.extractCampos(ProjetoDTO.class, (CampoDetalheDTO.OrigemCampoDetalhe)CampoDetalheDTO.OrigemCampoDetalhe.PROJETO));
        campos.addAll(AuxiliaresCalculoHelper.extractCampos(ImobiliarioDTO.class, (CampoDetalheDTO.OrigemCampoDetalhe)CampoDetalheDTO.OrigemCampoDetalhe.CADASTRO));
        campos.addAll(AuxiliaresCalculoHelper.extractCampos(ImobiliarioSegmentoDTO.class, (CampoDetalheDTO.OrigemCampoDetalhe)CampoDetalheDTO.OrigemCampoDetalhe.CADASTRO));
        campos.addAll(AuxiliaresCalculoHelper.extractCampos(ImobiliarioTestadaDTO.class, (CampoDetalheDTO.OrigemCampoDetalhe)CampoDetalheDTO.OrigemCampoDetalhe.CADASTRO));
        campos.addAll(AuxiliaresCalculoHelper.extractCampos(ImobiliarioTestadaGenericaDTO.class, (CampoDetalheDTO.OrigemCampoDetalhe)CampoDetalheDTO.OrigemCampoDetalhe.CADASTRO));
        return campos;
    }

    private List<CampoDetalheDTO> getCamposDinamicos() {
        List<FuncionalidadeCampo> funcionalidadeCampos = Arrays.asList(FuncionalidadeCampo.TERRENO, FuncionalidadeCampo.SEGMENTO, FuncionalidadeCampo.LOGRADOURO);
        return this.grupoCampoService.getCampoDetalhesPorFuncionalidade(funcionalidadeCampos);
    }

    @Generated
    public CalculoProjetoService(TabelaValorService tabelaValorService, CalculoProjetoExecucaoService execucaoService, CalculoProjetoRepository calculoProjetoRepository, DividaService dividaService, ContextService contextService, GrupoCampoService grupoCampoService) {
        this.tabelaValorService = tabelaValorService;
        this.execucaoService = execucaoService;
        this.calculoProjetoRepository = calculoProjetoRepository;
        this.dividaService = dividaService;
        this.contextService = contextService;
        this.grupoCampoService = grupoCampoService;
    }
}

