/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.calculo.repository.CalculoAvaliacaoRepository;
import br.com.elotech.tributos.domain.calculo.CalculoAvaliacao;
import java.util.Optional;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class CalculoAvaliacaoService
extends CrudService<CalculoAvaliacao, Long> {
    private final CalculoAvaliacaoRepository calculoAvaliacaoRepository;

    public CalculoAvaliacaoService(CalculoAvaliacaoRepository calculoAvaliacaoRepository) {
        this.calculoAvaliacaoRepository = calculoAvaliacaoRepository;
    }

    protected void beforeSave(CalculoAvaliacao entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        Optional identificadorDuplicado = entity.getIdentificadorDuplicado();
        if (identificadorDuplicado.isPresent()) {
            throw new EloValidationException(String.format("Identificador %s est\u00e1 duplicado.", identificadorDuplicado.get()));
        }
        this.findByEntidadeAndExercicio(entity.getEntidade(), entity.getExercicio()).filter(other -> !other.getId().equals(entity.getId())).ifPresent(other -> {
            throw new EloValidationException(String.format("J\u00e1 existe um registro para o exerc\u00edcio %d e entidade %d.", entity.getExercicio(), entity.getEntidade()));
        });
        entity.getScript().forEach(linha -> linha.setCalculoAvaliacao(entity));
    }

    public Optional<CalculoAvaliacao> findByEntidadeAndExercicio(Long entidade, Long exercicio) {
        return this.calculoAvaliacaoRepository.findByEntidadeAndExercicio(entidade, exercicio);
    }
}

