/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.calculo.domain.CalculoLoteImpressao;
import br.com.elotech.tributos.calculo.dto.CalculoLoteImpressaoDTO;
import br.com.elotech.tributos.calculo.dto.CalculoLoteImpressaoItemDTO;
import br.com.elotech.tributos.calculo.service.CalculoLoteImpressaoItemService;
import br.com.elotech.tributos.calculo.service.CalculoLoteImpressaoService;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lotes-impressao"})
public class CalculoLoteImpressaoResource
extends ReadOnlyResource<CalculoLoteImpressao, Long> {
    private final CalculoLoteImpressaoService calculoLoteImpressaoService;
    private final CalculoLoteImpressaoItemService calculoLoteImpressaoItemService;

    public CalculoLoteImpressaoResource(CalculoLoteImpressaoService calculoLoteImpressaoService, CalculoLoteImpressaoItemService calculoLoteImpressaoItemService) {
        this.calculoLoteImpressaoService = calculoLoteImpressaoService;
        this.calculoLoteImpressaoItemService = calculoLoteImpressaoItemService;
    }

    @GetMapping(value={"{id}/dto"})
    public ResponseEntity<CalculoLoteImpressaoDTO> findDtoById(@PathVariable Long id) {
        CalculoLoteImpressao calculoLoteImpressao = (CalculoLoteImpressao)this.calculoLoteImpressaoService.findOne((Serializable)id);
        if (calculoLoteImpressao == null) {
            throw RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar lote de impress\u00e3o com id %d", id));
        }
        return ResponseEntity.ok((Object)CalculoLoteImpressaoDTO.of((CalculoLoteImpressao)calculoLoteImpressao));
    }

    @GetMapping(value={"/{id}/itens"})
    public ResponseEntity<Page<CalculoLoteImpressaoItemDTO>> getItensById(@PathVariable Long id, @RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.calculoLoteImpressaoItemService.findByLoteImpressaoId(id, search, pageable));
    }

    @PostMapping(value={"/{id}/arquivo-grafica"})
    public ResponseEntity<Void> gerarArquivoGrafica(@PathVariable Long id) {
        this.calculoLoteImpressaoService.validaInicioTarefaArquivoGrafica(id);
        this.calculoLoteImpressaoService.startTarefaArquivoGrafica(id);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{id}/arquivo-grafica-pdf"})
    public ResponseEntity<Void> generateLoteCarnePDF(@PathVariable Long id) {
        this.calculoLoteImpressaoService.validaInicioTarefaGeracaoPdf(id);
        UserSecurityDTO userId = SecurityUtils.getUserSecurityDTO();
        this.calculoLoteImpressaoService.createImpressaoCarneLotePdf(id, userId);
        return ResponseEntity.ok().build();
    }

    @Transactional
    @DeleteMapping(value={"/{id}/arquivo-grafica"})
    public ResponseEntity<Void> deletarArquivoGrafica(@PathVariable Long id) {
        this.calculoLoteImpressaoService.deletarArquivoGrafica(id);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{id}/download-carne-pdf"})
    public ResponseEntity<String> printCarnePdf(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.calculoLoteImpressaoService.printUrlCarnePdf(id));
    }

    @GetMapping(value={"/url-arquivo-grafica/{uuid}"})
    public ResponseEntity<String> getUrlArquivoGrafica(@PathVariable UUID uuid) {
        return ResponseEntity.ok((Object)this.calculoLoteImpressaoService.getUrlArquivoGrafica(uuid));
    }

    @PostMapping(value={"/{id}/duplicar"})
    public ResponseEntity<CalculoLoteImpressaoDTO> duplicarLoteImpressao(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.calculoLoteImpressaoService.duplicarLoteImpressao(id));
    }
}

