/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.calculo.domain.TipoCampoDinamico;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.calculo.dto.CadastroIsencaoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroMobiliarioCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CampoDinamicoScriptDTO;
import br.com.elotech.tributos.calculo.dto.RespostaDTO;
import br.com.elotech.tributos.calculo.repository.CadastroCalculoRepositoryUtils;
import br.com.elotech.tributos.calculo.repository.CadastroMobiliarioCalculoDTORowMapper;
import com.google.common.base.Stopwatch;
import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CadastroMobiliarioCalculoRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CadastroMobiliarioCalculoRepository.class);
    private static final String CADASTRO_MOBILIARIO = "br/com/elotech/tributos/calculo/repository/load-cadastro-mobiliario.sql";
    private static final String BOLETIM_MOBILIARIO = "br/com/elotech/tributos/calculo/repository/load-cadastro-mobiliario-boletim.sql";
    private static final String CADASTRO_ISENCOES = "br/com/elotech/tributos/calculo/repository/load-cadastro-isencao.sql";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public CadastroMobiliarioCalculoRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<CadastroCalculoRoot<Long>> loadCadastros(String filtro, Long exercicio, Set<CampoDinamicoScriptDTO> camposDinamicos, LocalDate dataReferencia) {
        List cadastros = this.cadastros(filtro, exercicio, dataReferencia);
        Map boletimMobiliario = this.loadBoletim(filtro, camposDinamicos);
        Map isencoes = this.loadIsencoes(filtro, exercicio);
        return cadastros.stream().collect(Collectors.groupingBy(CadastroCalculoDTO::getId)).entrySet().stream().map(cadastro -> this.buildRoot(cadastro, (List)boletimMobiliario.getOrDefault(cadastro.getKey(), new ArrayList()), (List)isencoes.getOrDefault(cadastro.getKey(), new ArrayList()))).collect(Collectors.toList());
    }

    private List<CadastroMobiliarioCalculoDTO> cadastros(String filtro, Long exercicio, LocalDate dataReferencia) {
        String sql = String.format(FileUtils.readResourceAsString((String)CADASTRO_MOBILIARIO), filtro);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("exercicio", (Object)exercicio);
        parameters.addValue("data", (Object)Date.valueOf(dataReferencia));
        Stopwatch stopwatch = Stopwatch.createStarted();
        List cadastros = this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new CadastroMobiliarioCalculoDTORowMapper());
        stopwatch.stop();
        LOGGER.debug("Carregando {} cadastros do banco - {} m {} s {} ms - {} ns", new Object[]{cadastros.size(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        return cadastros;
    }

    private CadastroCalculoRoot<Long> buildRoot(Map.Entry<Long, List<CadastroMobiliarioCalculoDTO>> cadastros, List<RespostaDTO> respostasMobiliario, List<CadastroIsencaoDTO> isencoes) {
        CadastroCalculoRoot root = new CadastroCalculoRoot();
        root.setChildren(cadastros.getValue());
        root.setIsencoes(isencoes);
        if (!cadastros.getValue().isEmpty()) {
            root.setId((Object)cadastros.getKey());
            root.setTipoCadastro(cadastros.getValue().get(0).getTipoCadastro());
            root.setCadastroGeral(cadastros.getValue().get(0).getCadastroGeral());
            Map boletimMobiliario = CadastroCalculoRepositoryUtils.parseBoletim(respostasMobiliario);
            cadastros.getValue().forEach(cadastro -> {
                cadastro.getCadastro().setBoletim(boletimMobiliario);
                cadastro.getCadastro().setIsencoes(isencoes);
            });
        }
        return root;
    }

    private Map<Long, List<RespostaDTO>> loadBoletim(String filtro, Set<CampoDinamicoScriptDTO> camposDinamicos) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String filtroCamposDinamicos = CadastroCalculoRepositoryUtils.buildFiltroCampoDinamico((TipoCampoDinamico)TipoCampoDinamico.CADASTRO, camposDinamicos);
        if (StringUtils.isBlank((CharSequence)filtroCamposDinamicos)) {
            return new HashMap<Long, List<RespostaDTO>>();
        }
        String sqlBoletimTerreno = String.format(FileUtils.readResourceAsString((String)BOLETIM_MOBILIARIO), filtro, filtroCamposDinamicos);
        List result = this.namedParameterJdbcTemplate.query(sqlBoletimTerreno, new HashMap(), (RowMapper)new ElotechBeanPropertyRowMapper(RespostaDTO.class));
        stopwatch.stop();
        LOGGER.debug("Carregando {} boletim - {} m {} s {} ms - {} ns", new Object[]{result.size(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        return result.stream().collect(Collectors.groupingBy(RespostaDTO::getReferencia));
    }

    private Map<Long, List<CadastroIsencaoDTO>> loadIsencoes(String filtro, Long exercicio) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String sqlIsencoes = String.format(FileUtils.readResourceAsString((String)CADASTRO_ISENCOES), filtro);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("exercicio", (Object)exercicio);
        List result = this.namedParameterJdbcTemplate.query(sqlIsencoes, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(CadastroIsencaoDTO.class));
        stopwatch.stop();
        LOGGER.debug("Carregando {} isencoes - {} m {} s {} ms - {} ns", new Object[]{result.size(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        return result.stream().collect(Collectors.groupingBy(CadastroIsencaoDTO::getIdCadastro));
    }
}

